/*  Copyright (C) 2001  Dobin Rutishauser               anthraxx@gmx.net
                        Bjrn Paetzel                     kolrabi@gmx.de

  ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either  version 2 of the  License, or
    any later version.

    This program is distributed in the hope that it  will be useful, but
    WITHOUT  ANY  WARRANTY;  without   even  the  implied   warranty  of
    MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU
    General Public License for more details.
	
    You should have received a copy  of the  GNU  General Public License
    along with this program (GPL.TXT); if not, write to the 

	Free Software Foundation, Inc., 
	59 Temple Place, Suite 330, 
	Boston, MA
	02111-1307, USA.
*/

#include "../common/messages.h"
#include "../common/config.h"


#ifndef		CLIENTSOCKET_TYPES_DEFINED
#define		CLIENTSOCKET_TYPES_DEFINED

typedef struct _server_s
{
	char				name[64];
	unsigned int		port;
	SOCKET				sock;
	unsigned int		anzports;
} server_t;

#endif


extern server_t	*serverlist;
extern int servercount;


void	ctrlc_handler(int p);
void	initialise_sockets();
void	shutdown_sockets();
void	handle_connection(int server);
int	authorize(SOCKET sock, int pkt_count);
int	make_connection();
int	send_ports(int connectedsockets);
int	recv_srv_answer(int connectedsockets);
int	fill_in_ports (char *server, char *sports);
void	fill_server_list();
int 	handle_ip_file(char *filename);
int	host_mod(char done[MAX_ARG_LEN], char work[MAX_ARG_LEN]);
int	leet_subnet_scan(char server[MAX_ARG_LEN], char portarg[MAX_ARG_LEN]);
void	list_show(void);
