/*  Copyright (C) 2001  Dobin Rutishauser               anthraxx@gmx.net
                        Bjrn Paetzel                     kolrabi@gmx.de
   
  ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either  version 2 of the  License, or
    any later version.

    This program is distributed in the hope that it  will be useful, but
    WITHOUT  ANY  WARRANTY;  without   even  the  implied   warranty  of
    MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU
    General Public License for more details.
	
    You should have received a copy  of the  GNU  General Public License
    along with this program (GPL.TXT); if not, write to the 

	Free Software Foundation, Inc., 
	59 Temple Place, Suite 330, 
	Boston, MA
	02111-1307, USA.
*/

// ---------------------------------------------------------- //
// config.c
//
// this file includes function for both, the client and the server

// ---------------------------------------------------------- //
// includes

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "utils.h"
#include "config.h"


// ---------------------------------------------------------- //
// functions


// find_variable_for_name()
//
// parameters:
//
// char		*name	name of the variable to find
//
// return values:
//
// -1 if not found
// number of the variable otherwise
//
// finds the number of a configuration variable given its name

int		find_variable_for_name( const char *name )
{
	int	num = 0;

	while( configvars[num].name )
	{
		strupr( (char*)name );
		if (!strcmp( name, configvars[num].name ))
			return num;

		num++;
	}

	return -1;
}



// set_variable()
//
// parameters:
//
// int 		num		number of config variable to set
// char		*value	new value of the variable as a string
//
// return values:
//
// zero if the variable is invalid, not zero if successful
//
// sets a configuration variable to a value given its number

int		set_variable( int num, char *value )
{
	if (!configvars[num].var)
		return 0;

	if (!value)
		return 0;

	if (!strlen(value))
		return 0;

	/* it seems that shit cannot handle " " correctly */
	strtrm( value, " \n\t"); 

	/* that should be good enough :) */
	if(*value == ' ') {
          value++;
	}


	switch ( configvars[num].type )
	{
		case vt_string:
			sprintf( (char*)configvars[num].var, "%s", value );
			break;

		case vt_int:
			*(int*)configvars[num].var = atoi( value );
			break;

		case vt_long:
			*(long*)configvars[num].var = atol( value );
			break;
		
		case vt_float:
			*(float*)configvars[num].var = (float)atof( value );
			break;

		case vt_boolean:
			strupr( value );
			if ( ! ( strcmp( value, "1" )	&& strcmp( value, "YES" )	&&
					 strcmp( value, "JA" )	&& strcmp( value, "OUI" )	&&
					 strcmp( value, "HAI" ) && strcmp( value, "+" )		&&
					 strcmp( value, "Y" )	&& strcmp( value, "J" )	) )
				*(char*)configvars[num].var = 1;
			else
				*(char*)configvars[num].var = 0;

			break;
	}

	return 1;
}



/*
 * parse_config_line()							 19. 04. 2001
 *
 * parameters:
 * 
 * char		*line	line to parse
 * int 		linenum	number of current line (for errors)
 *
 * parses a line from the config file and sets configuration
 * variables
*/

void	parse_config_line( const char *line, int linenum )
{
	char	varname[32];
	int		varnum;
	char	*p;

	memset( varname, 0, 32 );

	// ignore comments
	p = strchr( line, '#' );
	if (p) *p = 0;

	// trim it
	line = strtrm( line, " \t\n\r" );

	// ignore empty lines
	if (strlen(line)==0)
		return;

	p = strchr( line, '=' );

	if (!p)
	{
		logprintf( LVL_WARNING, "missing '=' in %s at line %u ignored.", configfile, linenum );
		return;
	}

	if (p>line+31)
	{
		logprintf( LVL_ERROR, "variable name too long in %s at line %u", configfile, linenum );
		return;
	}

	memcpy( varname, line, p-line );

	strtrm( varname, " \n\t" );
	varnum = find_variable_for_name( varname );

	if (!(varnum+1))
	{
		logprintf( LVL_WARNING, "unknown variable %s in %s at line %u ignored.", varname, configfile, linenum );
		return;
	}


	if ( !set_variable( varnum, p+1 ) )
	{
		logprintf( LVL_WARNING, "illegal value '%s' in %s at line %u ignored.", p+1, configfile, linenum );
		return;
	}
}



// set_default_config()
//
// fills configuration variables with default values

void	set_default_config()
{
	int	num = 0;

	while( configvars[num].name )
	{
		set_variable( num, configvars[num].defaultval );
		num++;
	}
}


/*
 * read_config_file()
 *
 * parameters:
 * char		*name	filename of the config file to read
*/

int		read_config_file( char *name )
{
	FILE	*fcfg;
	char	line[MAX_ARG_LEN];
	int	linenum = 0;

	set_default_config();
	fcfg = fopen( name, "r" );

	if (!fcfg) return 0;

	while(!feof(fcfg))
	{
		linenum++;
		if ( fgets( line, MAX_ARG_LEN, fcfg ) )
			parse_config_line( line, linenum );
	}
	fclose(fcfg);

	return 1;
}
