/*  Copyright (C) 2001  Dobin Rutishauser               anthraxx@gmx.net
                        Bjrn Paetzel                     kolrabi@gmx.de
   
  ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either  version 2 of the  License, or
    any later version.

    This program is distributed in the hope that it  will be useful, but
    WITHOUT  ANY  WARRANTY;  without   even  the  implied   warranty  of
    MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU
    General Public License for more details.
	
    You should have received a copy  of the  GNU  General Public License
    along with this program (GPL.TXT); if not, write to the 

	Free Software Foundation, Inc., 
	59 Temple Place, Suite 330, 
	Boston, MA
	02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <stdarg.h>

#include "config.h"
#include "utils.h"


/* here are some functions that are not ansi c */

char	charupr( char c )
{
	if ( c>='a' && c<='z' )
		return c-32;

	return c;
}

char	charlwr( char c )
{
	if ( c>='A' && c<='Z' )
		return c+32;

	return c;
}

char	*strupr( char *string )
{
	char *p = string;

	while (*p)
	{
		*p = charupr(*p);
		p++;
	}

	return string;
}

char	*strlwr( char *string )
{
	char *p = string;

	while (*p)
	{
		*p = charlwr(*p);
		p++;
	}

	return string;
}

char	*strtrml( const char *string, char *trimchrs )
{
	int		l = strlen(string);
	char	*p;

	p = (char*)string;

	while(strchr( trimchrs, *p ) && p<(string+l)) p++;

	return p;
}

char	*strtrmr( const char *string, char *trimchrs )
{
	int		l = strlen(string);
	char	*p;

	p = (char*)string+l-1;

	while(strchr( trimchrs, *p ) && p>(string+1)) p--;

	if (p<string+l-1 && *p)
	{
		p++;
		*p = 0;
	}

	return (char*)string;
}



char	*strtrm( const char *string, char *trimchrs )
{
	char	*p = strtrml( string, trimchrs );

	p = strtrmr( string, trimchrs );
	p = strtrml( p, trimchrs );

	return p;
}




// ---------------------------------------------------------- //
// logging functions

char	*getlevelname( int level )
{
	switch (level)
	{
		case LVL_DEBUG:		return "DGB";
		case LVL_VERBOSE:	return "VER";
		case LVL_MESSAGE:	return "MSG";
		case LVL_WARNING:	return "WRN";
		case LVL_ERROR:		return "ERR";
		case LVL_CRITICAL:	return "CRT";
	}
	return "???";
}

void	logprintf( int level, char *fmt, ... )
{
	va_list argptr;
	char	text[256];

	va_start (argptr, fmt);
	vsnprintf (text, sizeof(text), fmt, argptr);
	va_end (argptr);

	if (level>=debuglevel)
		printf("(%s) %s\n", getlevelname(level), text);

	if (level>2)
		exit(level);
}

