/*  B A S T A R D    A P I  :  */
/*  */

#include <bdb.h>  /* main DB structure definitions */

/* Public Parts */
 /* ADDRESS types and permissions */
#define ADDR_CODE      0x01
#define ADDR_DATA      0x02
#define ADDR_IMPORT      0x10
#define ADDR_EXPORT      0x20
#define ADDR_SECTION   0x40
#define ADDR_STRUCT      0x100
#define ADDR_STRING      0x200
#define ADDR_FUNCTION   0x400
#define ADDR_INLINE      0x800
#define ADDR_NAME      0x1000
#define ADDR_COMMENT   0x2000
#define ADDR_SYMBOL   0x4000

/* these 2 are really just guesses based on target size and base rva */

/*   addr_is_valid:  Determine if given address is valid [ this is interpreted
 *                 to mean 'the given rva exists in some section', not 'the
 *                 given rva belongs to an ADDRESS object]. This is a bit
 *                 redundant with GetSection(), but makes code more clear.
 *    Return Value:   1 if valid, 0 if invalid
 *     Arguments:      long rva -- address to be checked */
int addr_is_valid( long rva );
/*   addr_is_valid_code: Determine if given address is a valid code address 
 *                    [i.e., does it exist in a section of type SECTION_CODE]
 *    Return Value:   1 if valid, 0 if invalid
 *     Arguments:      long rva -- address to be checked */
int addr_is_valid_code( long rva );
/*   addr_exists: Determine if the given address is an ADDRESS object
 *    Return Value:   1 if it exists, 0 if it does not
 *     Arguments:      long rva -- address to be checked */
int addr_exists( long rva );
/*  addr_find_closest : Find ADDRESS object containing given address --
 *                    this searches if 'rva' exists and, if it doesn't,
 *                    searches backwards looking for the ADDRESS object
 *                    that begins before rva.
 *    Return Value:    the rva closest to the given address
 *     Arguments:       long rva -- address to be located */
long addr_find_closest( long rva );
/*  addr_new :      Create an ADDRESS object at the given address, of the
 *                    specified size. This will resize existing addresses if
 *                    need be.
 *    Return Value:    1 if success, 0 if failure
 *     Arguments:       long rva   -- address to be created
 *                     int  size  -- size of address in bytes
 *                     long  pa   -- physical address of 'rva'
 *                     int  flags -- Flags for ADDRESS object, e.g. : 
 *                                   ADDR_CODE ADDR_DATA */
int addr_new( long rva, int size, long pa, int flags );
/*   addr_del:  Remove ADDRESS object for given address
 *    Return Value:   1 if success, 0 if failure
 *     Arguments:      long rva -- address to delete */
int addr_del( long rva );
/*  asmsprintf : print formatted line of assembly to buffer. This is like
 *                 sprintf(), only with custom format specificers:
 *                  %a - rva            %p - pa               %n - name  
 *                  %m - mnemonic       %b - hex bytes        %S - section name
 *                  %d - dest operand   %s - source operand   %t - aux operand
 *                  %c - comment        %x - xrefs
 *                 These specifiers allow a length byte, which for string
 *                 specifiers [%a %pa %n %m %s %d %x %S %c] limits the length
 *                 of the string, for xrefs or hex bytes [%x %b] soecifies 
 *                 how many to display. Examples:
 *                     %4x  - show up to 4 xrefs
 *                     %8b  - show up to 8 hexadecimal bytes
 *                     %64c - show up to 64 characters of comment
 *                 There are conditional punctuation specifiers:
 *                  %, - insert a comma if the next specifier is non-null
 *                  %; - insert a semicolon if any text follows
 *                  %: - append a colon if any text precedes it
 *                  %^ - append a newline if any text precedes it
 *                 The default format string for the Intel architecture is:
 *                     "%n%:%^%a %8b\t%m\t%d%, %s %;%c %x"
 *                 Note that as with sprintf(), a '%' can be printed by using
 *                 "%%".
 *    Return Value:   1 if success, 0 if failure
 *     Arguments:      char *buf    -- buffer to fill. It better e big enough.
 *                    char *format -- format string 
 *                    struct address *addr -- address to be printed */
int asmsprintf(char *buf, char *format, struct address *addr);
/*  addr_print: 
 *    Return Value:   
 *     Arguments:       */
int addr_print( long rva );
/*   addr_make_code: 
 *    Return Value:   
 *     Arguments:       */
int addr_make_code( long addr );
/*   addr_make_data: 
 *    Return Value:   
 *     Arguments:       */
int addr_make_data( long addr );
/*   addr_pa: 
 *    Return Value:   
 *     Arguments:       */
long addr_pa( long rva );
/*   addr_rva: 
 *    Return Value:   
 *     Arguments:       */
long addr_rva( long pa );
/*   addr_type: 
 *    Return Value:   
 *     Arguments:       */
int addr_type( long rva );
/*   addr_size: 
 *    Return Value:   
 *     Arguments:       */
int addr_size( long rva );
/*   addr_flags: 
 *    Return Value:   
 *     Arguments:       */
int addr_flags( long addr );
/*   addr_bytes: 
 *    Return Value:   
 *     Arguments:       */
int addr_bytes( long rva, char *buf );
/*   addr_next: 
 *    Return Value:   
 *     Arguments:       */
long addr_next( long rva );
/*   addr_prev: 
 *    Return Value:   
 *     Arguments:       */
long addr_prev( long rva );
/*  addr_set_flags : 
 *    Return Value:   
 *     Arguments:       */
int addr_set_flags( long rva, int flags );


/* move these into addr.c: */
/*   addr_constant: 
 *    Return Value:   
 *     Arguments:       */
int addr_constant( long rva );
/*   addr_struct: 
 *    Return Value:   
 *     Arguments:       */
int addr_struct( long rva );
/*   addr_set_constant: 
 *    Return Value:   
 *     Arguments:       */
int addr_set_constant( long rva, int id );
/*   addr_set_struct: 
 *    Return Value:   
 *     Arguments:       */
int addr_set_struct( long rva, int id );

/*  addr_get_by_name: 
 *    Return Value:   
 *     Arguments:       */
long addr_get_by_name( char *name );
/*   addr_add_comment: 
 *    Return Value:   
 *     Arguments:       */
int addr_add_comment( long rva, char *buf );
/*   addr_comment: 
 *    Return Value:   
 *     Arguments:       */
int addr_comment( long rva );
/*   addr_set_comment: 
 *    Return Value:   
 *     Arguments:       */
int addr_set_comment( long rva, int id );

int addr_foreach_xref( struct address *a, BAPI_CALLBACK fn, void *arg );

/* Private Parts ;)  */
#ifndef INCLUDED_FROM_BASTARD_H

#endif
