/*  B A S T A R D    A P I  :  */
/*  */

#include <bdb.h>  /* main DB structure definitions */

/* Public Parts */
/* these could reuse OP types, but those types are too general... */
#define ADDEXP_SCALE_MASK  0x000000FF
#define ADDEXP_INDEX_MASK  0x0000FF00
#define ADDEXP_BASE_MASK   0x00FF0000
#define ADDEXP_DISP_MASK   0xFF000000
#define ADDEXP_SCALE_OFFSET 0
#define ADDEXP_INDEX_OFFSET 8
#define ADDEXP_BASE_OFFSET  16
#define ADDEXP_DISP_OFFSET  24
#define ADDREXP_BYTE    0x01
#define ADDREXP_WORD    0x02
#define ADDREXP_DWORD   0x03     
#define ADDREXP_QWORD   0x04
#define ADDREXP_REG     0x10 /*0x00 implies non-register */

#define AddrExp_ScaleType(x) x & ADDEXP_SCALE_MASK
#define AddrExp_IndexType(x) (x & ADDEXP_INDEX_MASK) >> 8
#define AddrExp_BaseType(x) (x & ADDEXP_BASE_MASK) >> 16
#define AddrExp_DispType(x) (x & ADDEXP_DISP_MASK) >> 24

int addrexp_new(int scale, int index, int base, int disp, int flags);
int addrexp_get( int id, struct addr_exp *exp );
int addrexp_sprint( int id, char *string, int len);
/* returns 1 if addr_exp id1 and addr_exp id2 are equivalent, 0 otherwise */
int addrexp_equiv( int id1, int id2 );

/* Private Parts ;)  */
#ifndef INCLUDED_FROM_BASTARD_H

#endif
