/*  B A S T A R D    A P I  :  */
/*  */

#ifndef BASTARD_API_INTCODE_H
#define BASTARD_API_INTCODE_H

#include <bdb.h>  /* main DB structure definitions */

/* Public Parts */
#define USE_SRC		0x0000EEE1
#define USE_DEST		0x0000EEE2
#define USE_AUX		0x0000EEE3

#define USE_CODEID	0x0000EEE4
#define USE_FUNCID	0x0000EEE5
/*#define USE_LOCALID	0x0000EEE6  // no idea what these would be used for
#define USE_NAMEID	0x0000EEE7
#define USE_INTID		0x0000EEE8 */

#define USE_WORDSIZE	0x0000EEEA
#define USE_DWORDSIZE	0x0000EEEB

#define BASE_OPTYPE_MASK 	0x0000FFFF

/* basic op types */
enum basic_op_types {
	op_greg = 1,		/* general-purpose register */
	op_ireg,			/* incoming args */
	op_oreg,			/* outgoing args */
	op_lreg,			/* local vars */
	op_rreg,			/* specific physical registers */
	op_specreg,			/* special register */
	op_scratch,			/* temporary block-of-intcode reg */
	op_imm,			/* immediate value */
	op_label,			/* named address */
	op_dir			/* directive argument (special) */
};

/* specific op types  -- these are operands */
enum special_regs	{
	reg_sp = 1,
	reg_fp,
	reg_pc,
	reg_cz,
	reg_cn,
	reg_cv,
	reg_cc
};

/* these are types */
enum immediate_ops {
	imm_byte = 0x10000,
	imm_ubyte = 0x20000,
	imm_hword = 0x30000,
	imm_uhword = 0x40000,
	imm_word = 0x50000,
	imm_uword = 0x60000
};

enum label_ops { /* these may not be nec... */
	label_name = 0x10000,
	label_code = 0x20000,
	label_func = 0x30000,
	label_struct = 0x40000 	/* and so on and so on... */
};


#define DEREF_OP        0x10000000

/*
Here is the basic opcode format, in 4 bytes:

		0x00 00 00 00
		            ^----- dest size
		           ^------ src size
		         ^-------- cond code
		        ^--------- trap or branch type [unused]
	  	     ^^----------- instruction
  		  ^^-------------- instruction type [FPU, basic, special]
*/
	
#define BASE_ISA	0x00000000
#define EXT_ISA	0x10000000
#define FPU_ISA	0x01000000

/* macro for specifying a basic instruction */
#define INSTR(x) ( x << 16 ) | BASE_ISA
#define INSCC(x, y) ( x << 16 ) | ( y << 8 ) | BASE_ISA
/* macro for specifying a directive */
#define DIR(x) ( x << 16 ) | EXT_ISA
/* macro for specifying an FP instruction */
#define FPU(x) ( x << 16 ) | FPU_ISA

enum inst_size { 	
	sz_none, 
	sz_byte, sz_ubyte, 	/* 1, 2 */    /* 00001b == signed */
	sz_hword, sz_uhword,	/* 3, 4 */
	sz_word, sz_uword, 	/* 5, 6 */
	sz_dword, sz_udword,	/* 7, 8 */
	sz_qword, sz_uqword,	/* 9, A */
	sz_ext_prec			/* B */    /* extended precision */
};

enum cond_code {
	cc_n = 1, cc_a, cc_e, cc_ne, cc_g, cc_le, cc_l, cc_ge, cc_neg, cc_pos,
	cc_cs, cc_cc, cc_vs, cc_vc
};

enum base_isa {	/* leave xor last */
	i_add = 1, 
	i_and, i_b, i_blcr, i_bset, i_btog, i_btst, i_call, i_clr, 
	i_cmp, i_dec, i_div, i_inc, i_jmp, i_ld, i_mod, i_mul, i_mv, i_neg,
	i_not, i_or, i_restore, i_ret, i_rol, i_ror, i_save, i_set, i_sll, 
	i_sra, i_srl, i_st, i_sub, i_swap, i_t, i_tret, i_test, i_xor
};

enum ext_isa {	/* leave clobber last */
	i_label = 1, 
	i_data, i_global, i_frame, i_unframe, i_proc, i_asm, 
	i_block, i_unblock, i_calc, i_uncalc, i_clobber
};

/* API routines */
int intcode_gen( struct function *f, int options );

/* routines for formatting INT_CODE */
int intcode_getstr_mnem( unsigned long opcode, char *buf, int len );
int intcode_sprint_op(unsigned long op, unsigned long type, char *buf, int len);
int intcode_sprint_dirop( struct int_code *i, char *buf, int len );
int intcode_sprint( struct int_code *i, char *buf, int len );
int intcode_sprintf( char *buf, char *fmt, struct int_code *i );

/* Private Parts ;)  */
#ifndef INCLUDED_FROM_BASTARD_H

#endif

/* REMINDER:
 	struct INT_CODE {
		unsigned long id;
		unsigned long opcode;
		unsigned long src, sType;
		unsigned long dest, dType;
		unsigned long arg, aType;
		unsigned long fn_id;
		unsigned long addr_id;
		unsigned int order;
		unsigned long cmt_id;
	};
 */


#endif
