/*  B A S T A R D    A P I  :  */
/*  */

#include <bdb.h>  /* main DB structure definitions */

/* Public Parts */



/* THIS INTERFACE SUCKS!!! REPLACE ASAP USING DB_QUERY INTERFACE */

/* Each of these 'Find' functions initiates a search if *search is NULL --
 * the Find becomes a FindFirst, and *search is filled with a search handle.
 * Subsequent calls to the Find function act as a FindNext, until the search
 * returns 0 hits [and the handle is automatically freed]. If you are finished
 * with the search before it returns 0 --for example if you only want the first
 * ten matches -- then you must call FreeSearchHandle to dealloc the memory
 * used for *search. */

/*  FindBytes: Find a sequence of bytes in the target image
 *    Return Value:   Rva of found location or 0 if not found
 *     Arguments:      char * bytes -- sequence of bytes to search for
 *                    int    len   -- length of the sequence 
 *                    int **search -- void pointer to store search handle in */
int find_bytes( unsigned char *bytes, int len, int **search);
/*  FindOperand:     Find an operand in all the code objects
 *    Return Value:   rva of match or 0 if no match
 *     Arguments:      char *str    -- operand to search for 
 *                    int **search -- void pointer to store search handle in */
int find_operand( char *str, int **search);
/*  FindMnemonic:    Find a mnemonic in all the code objects
 *    Return Value:   rva of match or 0 if no match
 *     Arguments:      char *str    -- mnemonic to search for
 *                    int **search -- void pointer to store search handle in */
int find_mnemonic( char *str, int **search);
/*  FindConstant:    Find an Imeediate Value/Constant in all the CODE objects
 *    Return Value:   rva of match or 0 if no match
 *     Arguments:      long value   -- value to search for 
 *                    int **search -- void pointer to store search handle in */
int find_constant( long value, int **search);
/*  FreeSearchHandle: Use this if you terminate a search before viewing all
 *                    the hits.
 *    Return Value:    Returns a count of the matches examined
 *     Arguments:       int **search -- void pointer to a search handle */
int find_free_handle( int **search );

/* The following searches are one-offs and do not use a search handle.
 * These take a given operand [assumed to be a regiser or address] and
 * search backwards or forwards for up to 'ttl' instructions looking for
 * an instruction where that operand is accessed with OP_R, OP_W, or OP_X
 * permissions. 
 *    Return Value:   rva where the match occurs or 0 if ttl expired
 *    Arguments:      char *operand -- operand to search for
 *                    long rva      -- address to start searching after/before
 *                    int ttl       -- max # of addresses to search */
long find_next_op_r( char *operand, long rva, int ttl );
long find_prev_op_r( char *operand, long rva, int ttl );
long find_next_op_w( char *operand, long rva, int ttl );
long find_prev_op_w( char *operand, long rva, int ttl );
long find_next_op_x( char *operand, long rva, int ttl );
long find_prev_op_x( char *operand, long rva, int ttl );

/* Private Parts ;)  */
#ifndef INCLUDED_FROM_BASTARD_H

#endif
