/*  B A S T A R D    A P I  :  */
/*  */

#include <bdb.h>  /* main DB structure definitions */

/* Public Parts */
/* sys_init : Starts the DB and the interpreter, calls ReInit(); */
void sys_init( char *home);
/* sys_re_init : Clears bastard internal structs and sets $HOME to home */
void sys_re_init(char *home);
int sys_find_home(char *buf, int len, char **argv);

/*  sys_msg: Print a message to STDOUT unless QUIET flags is set 
 *     Arguments:   char *str -- Message to print    */
void sys_msg( const char *str ) ;

/*  sys_visual: Print an ascii art graphic :P */
#define sys_visual(x) if (!env_get_opt_flag(NO_VISUALS)) sys_msg(x)

/*  sys_errmsg: Print Error Code & Message w/newline, regardless of QUIET flag
 *     Arguments:   int num -- Error Code    char *str -- Message to print    */
void sys_errmsg( int num, const char *str ) ;
/*  sys_quit: Exit the bastard */
void sys_quit( ) ;
/*   sys_exec: Execute the target via system() 
 *    Return Value:   exit status of process
 *     Arguments:      char *args -- arguments to append to command line */
int sys_exec( char *args );
/*  sys_debug: Execute target in gdb via system()
 *    Return Value:   exit status of process */
int sys_debug( );
/*  sys_set_lasterr:  Sets the 'last error' internal variable 
 *    Return Value:   Returns 0 always
 *     Arguments:      int errnum -- error code for last error */
int sys_set_lasterr( int errnum );
/*  sys_get_lasterr: Returns error code of last error
 *    Return Value:   Error Code or 0 if failure
 *     Arguments:      none */
int sys_get_lasterr( );
/*  sys_lasterr_str: Returns pointer to string representing the last error
 *    Return Value:      const char * -- pointer to string or NULL if failure
 *     Arguments:         none */
char* sys_lasterr_str( );
/*  sys_print_errmsg:  Print string for error code to STDOUT
 *     Arguments:     int errnum -- error code to print    */
void sys_print_errmsg(int errnum);
/*  sys_sprint_errmsg:  Fills buffer with string for error code
 *     Arguments:      char buf[80] -- buffer for string
 *                    int  errnum  -- error code to look up */
void sys_sprint_errmsg(char *buf, int errnum);

/* Private Parts ;)  */
#ifndef INCLUDED_FROM_BASTARD_H

#endif
