/*  B A S T A R D    A P I  :  */
/*  */

#include <limits.h>
#include <bdb.h>  /* main DB structure definitions */

/* Public Parts */
#define DISASM_TGT_LOADED        0x01
#define DISASM_TGT_FORMAT_SET    0x02
#define DISASM_TGT_ARCH_SET      0x03
#define DISASM_TGT_OS_SET        0x04
#define DISASM_TGT_ASM_SET       0x05
#define DISASM_TGT_COMP_SET      0x06
#define DISASM_TGT_LANG_SET      0x07
#define DISASM_TGT_PREDISASM     0x08
#define DISASM_TGT_DISASM        0x09
#define DISASM_TGT_POSTDISASM    0x0A
#define DISASM_TGT_INTCODE       0x0B
#define DISASM_TGT_FINCODE       0x0C

struct DISASM_TGT_EXT {
	char name[64];
	int options;
};

struct DISASM_TGT_INFO {
	int endian;				/* endian from EXT_ARCH */
	int size;				/* size from stat() */
	int type;				/* type from formats.h */
	unsigned long entry;		/* entry point from EXT_FORMAT */
	char *header;			/* header summary from EXT_FORMAT */
      char   name[64];         	/* name of target */
      char   path[PATH_MAX]; 		/* full path of target */
      char   dbname[PATH_MAX];	/* full path to .bdb for target */
};

struct DISASM_TGT {   /* target information */
      int status;				/* how far disassembly has gotten */
	/* file descriptors for various thynges */
	int fd, history, log;
      char *image;         		/* mem-mapped image of target */
	struct DISASM_TGT_INFO info;
	struct DISASM_TGT_EXT arch, assembler, format;
	struct DISASM_TGT_EXT comp, os, lang;
};

/*   target_load: Open target file for disassenbly
 *    Return Value:   1 -- Success       0 -- Failure
 *     Arguments:      char *target -- full name/path of file to open */
int target_load( char *path );
/*  target_load_bdb: Open previously disassembled file 
 *    Return Value:   1 -- Success       0 -- Failure
 *    Arguments:      char *dbname -- full name/path of .bdb file */
int target_load_bdb( char *dbname );
/*  target_set_ext: Set all extensions with default ('0') options
 *  */
int target_set_ext(char *format, char *arch, char * comp, char *os, 
		             char *lang, char *asmblr);
/*  target_set_format: Specify Format of Target [e.g. "ELF"]
 *    Return Value:   1 -- Success       0 -- Failure
 *    Arguments:      char *file_format -- name of format
 *    Notes:      Valid formats can be listed with GetValidFormats(); */
int target_set_format( char *file_format, int options );
int target_apply_format( void );
/*  target_set_arch: Specify Processor Target was compiled for [e.g. "i386"]
 *    Return Value:   1 -- Success       0 -- Failure
 *    Arguments:      char *file_arch -- name of architecture
 *    Notes:      Valid architectures are listed with GetValidArchs(); */
int target_set_arch( char *file_arch, int options );
/*  target_set_asm: Set the assembly language output format -- these are
 *                      .so's in $BASTARD_HOME/asm . The output assembler
 *                      determines the [default] formatting for screen and
 *                      .asm file output [e.g. AT&T vs Intel syntax]
 *    Return Value:   1 -- Success       0 -- Failure
 *    Arguments:      char *asm_output -- name of target assembler */
int target_set_asm( char *asm_output, int options );
/* target_set_comp : Specify the compiler the target was compiled with [e.g.
 *                     gcc, lcc ] ... this determines defaults for string
 *                     style, calling convention, library signatures, etc. 
 *                     Compiler modules are .so's in $BASTARD_HOME/comp
 *    Return Value:   1 -- Success       0 -- Failure
 *    Arguments:      char *compiler -- name of compiler */
int target_set_comp( char *compiler, int options );
/* target_set_os : Specify the OS the target was written for  [e.g. linux,
 *                     win32, freebsd, solaris] ... this is needed for 
 *                     making assumptions later during INT_CODE generation.
 *                     OS modules are .so's in $BASTARD_HOME/os
 *    Return Value:   1 -- Success       0 -- Failure
 *    Arguments:      char *os -- name of OS */
int target_set_os( char *os, int options );
/* target_set_lang : Specify the language the target was written in [e.g.
 *                     C, FORTRAN] ... this determines defaults for string
 *                     style, calling convention, etc. Language modules are
 *                     .so's in $BASTARD_HOME/lang
 *    Return Value:   1 -- Success       0 -- Failure
 *    Arguments:      char *language -- name of language */
int target_set_lang( char *language, int options );
/* Get file descriptor of open target file */
int target_fd();
/* Get starting addr of mmap'ed target image */
char * target_image();
/* Get size of target */
int target_size();
/* Get entry point of target */
long target_entry();


 /*  target_save_db: Save current DB as .bdb file
 *    Notes : Uses ./$target.bdb for filename */
void target_save_db( );
/*  target_save_bak: Save current DB to a unique 'temp' filename
 *    Notes: Uses ./$target.$timestamp.bdb as filename */
void target_save_bak( );
/*  target_close_db: Close the current DB and target [i.e. before loading a new one] */
void target_close_db( );
/*  target_save_db_as: Save DB as the specified filename
 *    Arguments:      char *filename -- name of file to save DB as */
void target_save_db_as( char *filename );
/*  target_save_asm: Save a disassembled listing of the file
 *    Return Value :   0 -- Success       -1 -- Failure
 *    Arguments :      char *filename -- name of file to save listing as 
 *    Notes :       Will change to SaveAsLST and make new routine for 
 *                GAS and NASM asm files */
int target_save_asm( char *filename );
int target_save_hll( char *filename );
int target_save_lst( char *filename );
/*  target_save_hex: Save a  hex dump of the target
 *    Return Value :   1 -- Success       0 -- Failure
 *    Arguments :      char *filename -- name of file to save dump as  */
int target_save_hex( char *filename );
/*  target_save_diff: Create a binary diff [patch] between the original target and
 *              the current DB image of the target. Useless if you have not
 *              patched the target inside the disassembler.
 *    Return Value :   1 -- Success       0 -- Failure
 *    Arguments :      char *filename -- name of file to save diff as  */
int target_save_diff( char *filename );
/*  target_save_binary: Create a new binary image of the target, using the DB image
 *                of the target. Used to 'recreate' a missing or patched 
 *                target.
 *    Return Value :   1 -- Success       0 -- Failure
 *    Arguments :      char *filename -- name of file to save target as  */
int target_save_binary( char *filename );
int target_output_as(char *output, char *filename);


int target_set_size(int size);
int target_set_entry(long rva);
const char * target_arch();
const char * target_asm();
const char * target_format();
const char * target_lang();
const char * target_comp();
const char * target_os();
int target_os_type();

/* Private Parts ;)  */
#ifndef INCLUDED_FROM_BASTARD_H

#endif
