#define OFFSET(s, m) (long)&s.m - (long)&s
db_table target_schema[27];

/* ADDRESS table */
struct address a;
db_field address_rec[9] = {
   {ADDRESS_RVA,"rva", TYPE_ULONG, 1, ADDRESS_RVA, 0, 0, 
      "", &address_rec[1]},
   {PA,"pa", TYPE_ULONG, 1, PA, 0, OFFSET(a,pa), 
      "", &address_rec[2]},
   {ADDRESS_SIZE,"size", TYPE_USHORT, 1, 0, 0, OFFSET(a,size), 
      "", &address_rec[3]},
   {ADDRESS_FLAGS,"flags", TYPE_ULONG, 1, 0, 0, OFFSET(a,flags), 
      "", &address_rec[4]},
   {DATATYPE,"dataType", TYPE_ULONG, 1, 0, DATA_TYPE, OFFSET(a,dataType), 
      "", &address_rec[5]},
   {DATASIZE,"dataSize", TYPE_INT, 1, 0, 0, OFFSET(a,dataSize), 
      "", &address_rec[6]},
   {DATACONST,"dataConst", TYPE_ULONG, 1, 0, CONSTANT, OFFSET(a,dataConst), 
      "", &address_rec[7]},
   {ADDRESS_STRUCTURE,"structure", TYPE_ULONG, 1, 0,STRUCTURE,OFFSET(a,structure), 
      "", &address_rec[8]},
   {ADDRESS_COMMENT,"comment", TYPE_ULONG, 1, 0, COMMENT, OFFSET(a,comment), 
      "", NULL}
};

db_index address_idx[] = {
   {ADDRESS_RVA, "ADDRESS_RVA", address_rec, NULL, &target_schema[0], &address_idx[1]},
   {PA, "PA", &address_rec[1], NULL, &target_schema[0], NULL}
};

/* SECTION table */
struct section s;
db_field section_rec[4] = {
   {SECTION_NAME,"name", TYPE_CHAR, 32, SECTION_NAME, 0, 0, 
      "", &section_rec[1]},
   {SECTION_RVA,"rva", TYPE_ULONG, 1, SECTION_RVA, ADDRESS, OFFSET(s,rva), 
      "", &section_rec[2]},
   {SECTION_SIZE,"size", TYPE_ULONG, 1, 0, 0, OFFSET(s,size), 
      "", &section_rec[3]},
   {SECTION_FLAGS,"flags", TYPE_ULONG, 1, 0, 0, OFFSET(s,flags), 
      "", NULL}
};

db_index section_idx[] = {
   {SECTION_NAME, "SECTION_NAME", section_rec, NULL, &target_schema[1], &section_idx[1]},
   {SECTION_RVA, "SECTION_RVA", &section_rec[1], NULL, &target_schema[1], NULL}
};

/* XREF table */
struct xref x;
db_field xref_rec[4] = {
   {XREF_ID,"id", TYPE_ULONG, 1, XREF_ID, 0, 0, 
      "", &xref_rec[1]},
   {FROM_RVA,"from_rva", TYPE_ULONG, 1, FROM_RVA, ADDRESS, OFFSET(x,from_rva), 
      "", &xref_rec[2]},
   {TO_RVA,"to_rva", TYPE_ULONG, 1, TO_RVA, ADDRESS, OFFSET(x,to_rva), 
      "", &xref_rec[3]},
   {XREF_TYPE,"type", TYPE_ULONG, 1, 0, 0, OFFSET(x,type), 
      "", NULL}
};

db_index xref_idx[] = {
   {XREF_ID, "XREF_ID", xref_rec, NULL, &target_schema[2], &xref_idx[1]},
   {FROM_RVA, "FROM_RVA", &xref_rec[1], NULL, &target_schema[2], &xref_idx[2]},
   {TO_RVA, "TO_RVA", &xref_rec[2], NULL, &target_schema[2], &xref_idx[3]},
   {XREF_FROM_RVA, "XREF_FROM_RVA",&xref_rec[1], &xref_rec[2], &target_schema[2], &xref_idx[4]},
   {XREF_TO_RVA, "XREF_TO_RVA", &xref_rec[2], &xref_rec[1], &target_schema[2], NULL}
};

/* CODE table */
struct code c;
db_field code_rec[10] = {
   {CODE_RVA,"rva", TYPE_ULONG, 1, CODE_RVA, ADDRESS, 0, 
      "", &code_rec[1]},
   {CODE_FUNC, "func", TYPE_ULONG, 1, CODE_FUNCTION, FUNCTION, 0, 
      "", &code_rec[2]},
   {MNEMONIC,"mnemonic", TYPE_CHAR, 16, CODE_MNEMONIC, 0, OFFSET(c,mnemonic), 
      "", &code_rec[3]},
   {CODE_DEST,"dest", TYPE_LONG, 1, CODE_DEST_OP, 0, OFFSET(c,dest), 
      "", &code_rec[4]},
   {CODE_SRC,"src", TYPE_LONG, 1, CODE_SRC_OP, 0, OFFSET(c,src), 
      "", &code_rec[5]},
   {AUX,"aux", TYPE_LONG, 1, 0, 0, OFFSET(c,aux), 
      "", &code_rec[6]},
   {MNEMTYPE,"mnemType", TYPE_ULONG, 1, 0, 0, OFFSET(c,mnemType), 
      "", &code_rec[7]},
   {DESTTYPE,"destType", TYPE_ULONG, 1, 0, 0, OFFSET(c,destType), 
      "", &code_rec[8]},
   {SRCTYPE,"srcType", TYPE_ULONG, 1, 0, 0, OFFSET(c,srcType), 
      "", &code_rec[9]},
   {AUXTYPE,"auxType", TYPE_ULONG, 1, 0, 0, OFFSET(c,auxType), 
      "", NULL},

};

db_index code_idx[] = {
   {CODE_RVA, "CODE_RVA", code_rec, NULL, &target_schema[3], &code_idx[1]},
   {CODE_FUNCTION, "CODE_FUNC", &code_rec[2], code_rec, &target_schema[3], &code_idx[2]},
   {CODE_DEST_OP, "CODE_DEST_OP", &code_rec[3], code_rec, &target_schema[3], &code_idx[3]},
   {CODE_SRC_OP, "CODE_SRC_OP", &code_rec[4], code_rec, &target_schema[3], &code_idx[4]},
   {CODE_MNEMONIC, "CODE_MNEMONIC", &code_rec[5], code_rec, &target_schema[3], NULL}
};

/* ADDR_EXP table */
struct addr_exp ae;
db_field addrexp_rec[7] = {
   {ADDR_EXP_ID,"id", TYPE_ULONG, 1, ADDR_EXP_ID, 0, 0, 
      "", &addrexp_rec[1]},
   {SCALE,"scale", TYPE_INT, 1, 0, 0, OFFSET(ae,scale), 
      "", &addrexp_rec[2]},
   {INDEX,"index", TYPE_INT, 1, 0, 0, OFFSET(ae,index), 
      "", &addrexp_rec[3]},
   {BASE,"base", TYPE_INT, 1, 0, 0, OFFSET(ae,base), 
      "", &addrexp_rec[4]},
   {DISP,"disp", TYPE_LONG, 1, 0, 0, OFFSET(ae,disp), 
      "", &addrexp_rec[5]},
   {ADDR_EXP_FLAGS,"flags", TYPE_ULONG, 1, 0, 0, OFFSET(ae,flags), 
      "", &addrexp_rec[6]},
   {ADDR_EXP_NAME,"name", TYPE_LONG, 1, 0, NAME, OFFSET(ae,name), 
      "", NULL}
};

db_index addrexp_idx[] = {
   {ADDR_EXP_ID, "ADDR_EXP_ID", addrexp_rec, NULL, &target_schema[4], NULL}
};

/* CODE_EFFECT table */
struct code_effect ce;
db_field ceffect_rec[6] = {
   {CODE_EFFECT_ID,"id", TYPE_ULONG, 1, CODE_EFFECT_ID, 0, 0, 
      "", &ceffect_rec[1]},
   {CODE_EFFECT_RVA,"rva",TYPE_ULONG,1,CODE_EFFECT_RVAID,ADDRESS,OFFSET(ce,rva),
      "", &ceffect_rec[2]},
   {CODE_EFFECT_LOC,"loc", TYPE_INT, 1, 0, 0, OFFSET(ce,loc), 
      "", &ceffect_rec[3]},
   {CODE_EFFECT_TYPE,"type", TYPE_ULONG, 1, 0, 0, OFFSET(ce,type), 
      "", &ceffect_rec[4]},
   {CODE_EFFECT_CHANGE,"change", TYPE_ULONG, 1, 0, 0, OFFSET(ce,change), 
      "", &ceffect_rec[5]},
   {CODE_EFFECT_AMOUNT,"amount", TYPE_INT, 1, 0, 0, OFFSET(ce,amount), 
      "", NULL}
};

db_index ceffect_idx[] = {
   {CODE_EFFECT_ID, "CODE_EFFECT_ID", ceffect_rec, NULL, &target_schema[5], &ceffect_idx[1]},
   {CODE_EFFECT_RVAID, "CODE_EFFECT_RVAID", &ceffect_rec[1], ceffect_rec, &target_schema[5], NULL}
};

/* REG_STATE table */
struct reg_state rs;
db_field regstate_rec[5] = {
   {REG_STATE_ID,"id", TYPE_ULONG, 1, REG_STATE_ID, 0, 0, 
      "", &regstate_rec[1]},
   {REG,"reg",TYPE_INT,1, 0, 0,OFFSET(rs,reg),
      "", &regstate_rec[2]},
   {VAL,"val", TYPE_ULONG, 1, 0, 0, OFFSET(rs,val), 
      "", &regstate_rec[3]},
   {REFTYPE,"reftype", TYPE_INT, 1, 0, 0, OFFSET(rs,reftype), 
      "", &regstate_rec[4]},
   {REG_STATE_REF,"ref", TYPE_ULONG, 1, REG_STATE_BY_REF, SYSREF_ID, OFFSET(rs,ref), 
      "", NULL},
};

db_index regstate_idx[] = {
   {REG_STATE_ID, "REG_STATE_ID", regstate_rec, NULL, &target_schema[6], &regstate_idx[1]},
   {REG_STATE_BY_REF, "REG_STATE_BY_REF", &regstate_rec[4], &regstate_rec[3], &target_schema[6], NULL}
};

/* SYSREF table */
struct sysref sr;
db_field sysref_rec[5] = {
   {SYSREF_ID,"id", TYPE_ULONG, 1, SYSREF_ID, 0, 0, 
      "", &sysref_rec[1]},
   {SYSREF_TYPE,"type",TYPE_INT,1,SYSREF_TYPE_ID,0,OFFSET(sr,type),
      "", &sysref_rec[2]},
   {SUBTYPE,"subtype",TYPE_INT,1,0,0,OFFSET(sr,subtype),
      "", &sysref_rec[3]},
   {SYSREF_REF,"ref", TYPE_INT, 1, 0, 0, OFFSET(sr,ref), 
      "", &sysref_rec[4]},
   {SYSREF_RVA,"rva", TYPE_ULONG, 1,SYSREF_FROM , CODE_RVA, OFFSET(sr,rva), 
      "", NULL},
};

db_index sysref_idx[3] = {
   {SYSREF_ID, "SYSREF_ID", sysref_rec, NULL, &target_schema[7], &sysref_idx[1]},
   {SYSREF_TYPE_ID, "SYSREF_TYPE_ID", &sysref_rec[1], &sysref_rec[2], &target_schema[7], &sysref_idx[2]},
   {SYSREF_FROM, "SYSREF_FROM", &sysref_rec[4], &sysref_rec[1], &target_schema[7], NULL}
};

/* INT_CODE table */
struct int_code ic;
db_field intcode_rec[12] = {
   {INT_CODE_ID,"id", TYPE_ULONG, 1, INT_CODE_ID, 0, 0, 
      "", &intcode_rec[1]},
   {OPCODE,"opcode", TYPE_ULONG, 1, 0, 0, OFFSET(ic, opcode), 
      "", &intcode_rec[2]},
   {INT_CODE_SRC,"src", TYPE_ULONG, 1, 0, 0, OFFSET(ic, src), 
      "", &intcode_rec[3]},
   {STYPE,"sType", TYPE_ULONG, 1, 0, 0, OFFSET(ic, sType), 
      "", &intcode_rec[4]},
   {INT_CODE_DEST,"dest", TYPE_ULONG, 1, 0, 0, OFFSET(ic, dest), 
      "", &intcode_rec[5]},
   {DTYPE,"dType", TYPE_ULONG, 1, 0, 0, OFFSET(ic, dType), 
      "", &intcode_rec[6]},
   {ARG,"arg", TYPE_ULONG, 1, 0, 0, OFFSET(ic, arg), 
      "", &intcode_rec[7]},
   {ATYPE,"aType", TYPE_ULONG, 1, 0, 0, OFFSET(ic, aType), 
      "", &intcode_rec[8]},
   {INT_CODE_FUNC,"func", TYPE_ULONG, 1, 0, 0, OFFSET(ic, func), 
      "", &intcode_rec[9]},
   {INT_CODE_ORDER,"order", TYPE_ULONG, 1, 0, 0, OFFSET(ic, order), 
      "", &intcode_rec[10]},
   {INT_CODE_RVA,"rva", TYPE_ULONG, 1, 0, 0, OFFSET(ic, rva), 
      "", &intcode_rec[11]},
   {INT_CODE_COMMENT,"comment", TYPE_ULONG, 1, 0, 0, OFFSET(ic, comment), 
      "", NULL}
};

db_index intcode_idx[] = {
   {INT_CODE_ID, "INT_CODE_ID", intcode_rec, NULL, &target_schema[8], &intcode_idx[1]},
   {INT_CODE_RVA, "INT_CODE_RVA", &intcode_rec[10], NULL, &target_schema[8], &intcode_idx[2]},
   {FN_ORDER, "FN_ORDER", &intcode_rec[8], &intcode_rec[9], &target_schema[8], NULL}
};


/* FIN_CODE table */
struct fin_code fc;
db_field fincode_rec[4] = {
   {FIN_CODE_ID,"id", TYPE_ULONG, 1, FIN_CODE_ID, 0, 0, 
      "", &fincode_rec[1]},
   {FIN_CODE_RVA,"rva", TYPE_ULONG, 1, FIN_CODE_RVA, ADDRESS, OFFSET(fc,rva), 
      "", &fincode_rec[2]},
   {FIN_CODE_SIZE,"size", TYPE_INT, 1, 0, 0, OFFSET(fc,size), 
      "", &fincode_rec[3]},
   {LINE,"line", TYPE_CHAR,256, 0, 0, OFFSET(fc,line), 
      "", NULL}
};

db_index fincode_idx[] = {
   {FIN_CODE_ID, "FIN_CODE_ID", fincode_rec, NULL, &target_schema[9], &fincode_idx[1]},
   {FIN_CODE_RVA, "FIN_CODE_RVA", &fincode_rec[1], NULL, &target_schema[9], NULL}
};

/* EXPORT_ADDR table */
struct export_addr ea;
db_field export_rec[1] = {
   {EXPORT_ADDR_RVA,"rva", TYPE_ULONG, 1, EXPORT_ADDR_RVA, ADDRESS, 0, 
      "", NULL}
};

db_index export_idx[] = {
   {EXPORT_ADDR_RVA, "EXPORT_ADDR_RVA", export_rec, NULL, &target_schema[10], NULL}
};

/* IMPORT_ADDR table */
struct import_addr ia;
db_field import_rec[3] = {
   {LIBRARY,"library", TYPE_ULONG, 1, IMPORT_LIBRARY, LIB, 0, 
      "", &import_rec[1]},
   {IMPORT_ADDR_TYPE,"type", TYPE_ULONG, 1, 0, 0, OFFSET(ia,type), 
      "", &import_rec[2]},
   {IMPORT_ADDR_RVA,"rva",TYPE_ULONG,1,IMPORT_ADDR_RVA,ADDRESS,OFFSET(ia,rva), 
      "", NULL}
};

db_index import_idx[] = {
   {IMPORT_ADDR_RVA, "IMPORT_ADDR_RVA", &import_rec[2], NULL, &target_schema[11], &import_idx[1]},
   {IMPORT_LIBRARY, "IMPORT_LIBRARY", import_rec, &import_rec[2], &target_schema[11], NULL}
};

/* LIBRARY table */
struct lib l;
db_field lib_rec[4] = {
   {LIB_ID,"id", TYPE_ULONG, 1, LIB_ID, 0, 0, 
      "", &lib_rec[1]},
   {LIB_NAME,"name", TYPE_CHAR, 64, LIB_NAME, 0, OFFSET(l,name), 
      "", &lib_rec[2]},
   {VER_HI,"ver_hi", TYPE_INT, 1, 0, 0, OFFSET(l,ver_hi), 
      "", &lib_rec[3]},
   {VER_LO,"ver_lo", TYPE_INT, 1, 0, 0, OFFSET(l,ver_lo), 
      "", NULL}
};

db_index lib_idx[] = {
   {LIB_ID, "LIB_ID", lib_rec, NULL, &target_schema[12], &lib_idx[1]},
   {LIB_NAME, "LIB_NAME", &lib_rec[1], NULL, &target_schema[12], NULL}
};

/* STRING table */
struct string str;
db_field string_rec[3] = {
   {STRING_RVA,"rva", TYPE_ULONG, 1, STRING_RVA, ADDRESS, 0, 
      "", &string_rec[1]},
   {LENGTH,"length", TYPE_INT, 1, 0, 0, OFFSET(str,length), 
      "", &string_rec[2]},
   {STRING_TEXT,"text", TYPE_CHAR, 256, 0, 0, OFFSET(str,text), 
      "", NULL}
};

db_index string_idx[] = {
   {STRING_RVA, "STRING_RVA", string_rec, NULL, &target_schema[13], NULL}
};

/* NAME table */
struct name n;
db_field name_rec[4] = {
   {NAME_ID,"id", TYPE_ULONG, 1, NAME_ID, 0, 0, 
      "", &name_rec[1]},
   {NAME_RVA,"rva", TYPE_ULONG, 1, NAME_RVA, ADDRESS, OFFSET(n, rva),  
      "", &name_rec[2]},
   {NAME_TYPE,"type", TYPE_ULONG, 1, 0, 0, OFFSET(n,type), 
      "", &name_rec[3]},
   {NAME_TEXT,"text", TYPE_CHAR, 64, NAME_TEXT, 0, OFFSET(n,text), 
      "", NULL}
};

db_index name_idx[] = {
   {NAME_RVA, "NAME_RVA", name_rec, NULL, &target_schema[14], &name_idx[1]},
   {NAME_TEXT, "NAME_TEXT", &name_rec[2], NULL, &target_schema[14], NULL}
};

/* COMMENT table */
struct comment cmt;
db_field comment_rec[3] = {
   {COMMENT_ID,"id", TYPE_ULONG, 1, COMMENT_ID, 0, 0, 
      "", &comment_rec[1]},
   {COMMENT_TYPE,"type", TYPE_ULONG, 1, 0, 0, OFFSET(cmt,type), 
      "", &comment_rec[2]},
   {COMMENT_TEXT,"text", TYPE_CHAR, 256, 0, 0, OFFSET(cmt,text), 
      "", NULL}
};

db_index comment_idx[] = {
   {COMMENT_ID, "COMMENT_ID", comment_rec, NULL, &target_schema[15], NULL}
};

/* FUNCTION table */
struct function f;
db_field func_rec[5] = {
   {FUNCTION_ID,"id", TYPE_ULONG, 1, FUNCTION_ID, 0, 0, 
      "", &func_rec[1]},
   {FUNCTION_RVA,"rva", TYPE_ULONG, 1, FUNCTION_RVA, ADDRESS, OFFSET(f,rva), 
      "", &func_rec[2]},
   {FUNCTION_SIZE,"size", TYPE_USHORT, 1, 0, 0, OFFSET(f,size), 
      "", &func_rec[3]},
   {RET_TYPE,"ret_type", TYPE_ULONG, 1, 0, DATA_TYPE, OFFSET(f,ret_type), 
      "", &func_rec[4]},
   {FUNCTION_COMMENT,"comment", TYPE_ULONG, 1, 0, COMMENT, OFFSET(f,comment), 
      "", NULL}
};

db_index func_idx[] = {
   {FUNCTION_ID, "FUNCTION_ID", func_rec, NULL, &target_schema[16], &func_idx[1]},
   {FUNCTION_RVA, "FUNCTION_RVA", &func_rec[1], NULL, &target_schema[16], NULL}
};

/* FUNC_PARAM table */
struct func_param fp;
db_field fparam_rec[7] = {
   {FUNC_PARAM_ID,"id", TYPE_ULONG, 1, FUNC_PARAM_ID, 0, 0, 
      "", &fparam_rec[1]},
   {FUNC_PARAM_FUNC,"func",TYPE_ULONG,1,FUNC_PARAM_FUNCID,FUNCTION,OFFSET(fp,func),
      "", &fparam_rec[2]},
   {FUNC_PARAM_TYPE,"type", TYPE_ULONG, 1, 0, DATA_TYPE, OFFSET(fp,type), 
      "", &fparam_rec[3]},
   {FUNC_PARAM_SIZE,"size", TYPE_INT, 1, 0, 0, OFFSET(fp,size), 
      "", &fparam_rec[4]},
   {FUNC_PARAM_ADDR_EXP,"addr_exp", TYPE_ULONG, 1,0,ADDR_EXP,OFFSET(fp,addr_exp), 
      "", &fparam_rec[5]},
   {FUNC_PARAM_FLAGS,"flags", TYPE_ULONG, 1, 0, 0, OFFSET(fp,flags), 
      "", &fparam_rec[6]},
   {FUNC_PARAM_NAME,"name", TYPE_CHAR, 32, 0, 0, OFFSET(fp,name), 
      "", NULL}
};

db_index fparam_idx[] = {
   {FUNC_PARAM_ID, "FUNC_PARAM_ID", fparam_rec, NULL, &target_schema[17], &fparam_idx[1]},
   {FUNC_PARAM_FUNCID, "FUNC_PARAM_FUNCID", &fparam_rec[1], fparam_rec, &target_schema[17], NULL}
};

/* FUNC_LOCAL table */
struct func_local fl;
db_field flocal_rec[7] = {
   {FUNC_LOCAL_ID,"id", TYPE_ULONG, 1, FUNC_LOCAL_ID, 0, 0, 
      "", &flocal_rec[1]},
   {FUNC_LOCAL_FUNC,"func", TYPE_ULONG, 1, FUNC_LOCAL_FUNCID, FUNCTION, OFFSET(fl,func), 
      "", &flocal_rec[2]},
   {FUNC_LOCAL_TYPE,"type", TYPE_ULONG, 1, 0, DATA_TYPE, OFFSET(fl,type), 
      "", &flocal_rec[3]},
   {FUNC_LOCAL_SIZE,"size", TYPE_INT, 1, 0, 0, OFFSET(fl,size), 
      "", &flocal_rec[4]},
   {FUNC_LOCAL_ADDR_EXP,"addr_exp", TYPE_ULONG, 1, 0, ADDR_EXP, OFFSET(fl,addr_exp), 
      "", &flocal_rec[5]},
   {FUNC_LOCAL_FLAGS,"flags", TYPE_ULONG, 1, 0, 0, OFFSET(fl,flags), 
      "", &flocal_rec[6]},
   {FUNC_LOCAL_NAME,"name", TYPE_CHAR, 32, 0, 0, OFFSET(fl,name), 
      "", NULL}
};

db_index flocal_idx[] = {
   {FUNC_LOCAL_ID, "FUNC_LOCAL_ID", flocal_rec, NULL, &target_schema[18], &flocal_idx[1]},
   {FUNC_LOCAL_FUNCID, "FUNC_LOCAL_FUNCID", &flocal_rec[1], flocal_rec, &target_schema[18], NULL}
};

/* FUNC_EFFECT table */
struct func_effect fe;
db_field feffect_rec[6] = {
   {FUNC_EFFECT_ID,"id", TYPE_ULONG, 1, FUNC_EFFECT_ID, 0, 0, 
      "", &feffect_rec[1]},
   {FUNC_EFFECT_FUNC,"func", TYPE_ULONG, 1, FUNC_EFFECT_FUNCID, FUNCTION, OFFSET(fe,func), 
      "", &feffect_rec[2]},
   {FUNC_EFFECT_LOC,"loc", TYPE_INT, 1, 0, 0, OFFSET(fe,loc), 
      "", &feffect_rec[3]},
   {FUNC_EFFECT_TYPE,"type", TYPE_ULONG, 1, 0, 0, OFFSET(fe,type), 
      "", &feffect_rec[4]},
   {FUNC_EFFECT_CHANGE,"change", TYPE_ULONG, 1, 0, 0, OFFSET(fe,change), 
      "", &feffect_rec[5]},
   {FUNC_EFFECT_AMOUNT,"amount", TYPE_INT, 1, 0, 0, OFFSET(fe,amount), 
      "", NULL}
};

db_index feffect_idx[] = {
   {FUNC_EFFECT_ID, "FUNC_EFFECT_ID", feffect_rec, NULL, &target_schema[19], &feffect_idx[1]},
   {FUNC_EFFECT_FUNCID, "FUNC_EFFECT_FUNCID", &feffect_rec[1],feffect_rec,&target_schema[19], NULL}
};

/* F_INLINE table */
struct f_inline fi;
db_field finline_rec[4] = {
   {F_INLINE_ID,"id", TYPE_ULONG, 1, F_INLINE_ID, 0, 0, 
      "", &finline_rec[1]},
   {F_INLINE_NAME,"name", TYPE_CHAR, 64, 0, 0, OFFSET(fi,name), 
      "", &finline_rec[2]},
   {F_INLINE_RVA,"rva", TYPE_ULONG, 1, F_INLINE_RVA, ADDRESS, OFFSET(fi,rva), 
      "", &finline_rec[3]},
   {F_INLINE_SIZE,"size", TYPE_USHORT, 1, 0, 0, OFFSET(fi,size), 
      "", NULL}
};

db_index finline_idx[] = {
   {F_INLINE_ID, "F_INLINE_ID", finline_rec, NULL, &target_schema[20], &finline_idx[1]},
   {F_INLINE_RVA, "F_INLINE_RVA", &finline_rec[2], NULL, &target_schema[20], NULL}
};

/* STRUCTURE table */
struct structure st;
db_field struct_rec[3] = {
   {STRUCTURE_ID,"id", TYPE_ULONG, 1, STRUCTURE_ID, 0, 0, 
      "", &struct_rec[1]},
   {STRUCTURE_NAME,"name", TYPE_CHAR, 32, 0, 0, OFFSET(st,name), 
      "", &struct_rec[2]},
   {STRUCTURE_SIZE,"size", TYPE_USHORT, 1, 0, 0, OFFSET(st,size), 
      "", NULL}
};

db_index struct_idx[] = {
   {STRUCTURE_ID, "STRUCTURE_ID", struct_rec, NULL, &target_schema[21], NULL}
};

/* STRUCT_MEMBER table */
struct struct_member sm;
db_field structmem_rec[6] = {
   {STRUCT_MEMBER_ID,"id", TYPE_ULONG, 1, STRUCT_MEMBER_ID, 0, 0, 
      "", &structmem_rec[1]},
   {STRUCT_MEMBER_TYPE,"type", TYPE_ULONG, 1, 0, DATA_TYPE, OFFSET(sm,type),
      "", &structmem_rec[2]},
   {STRUCT_MEMBER_SIZE,"size", TYPE_INT, 1, 0, 0, OFFSET(sm,size), 
      "", &structmem_rec[3]},
   {STRUCT_MEMBER_STRUCTURE,"structure", TYPE_ULONG, 1, STRUCT_MEMBER_STRUCT, STRUCTURE, OFFSET(sm,structure),
      "", &structmem_rec[4]},
   {STRUCT_MEMBER_ORDER,"order", TYPE_INT, 1, 0, 0, OFFSET(sm,order),
      "", &structmem_rec[5]},
   {STRUCT_MEMBER_NAME,"name", TYPE_CHAR,32, 0, 0, OFFSET(sm,name),
      "", NULL}
};

db_index structmem_idx[] = {
   {STRUCT_MEMBER_ID, "STRUCT_MEMBER_ID",structmem_rec,NULL,&target_schema[22], &structmem_idx[1]},
   {STRUCT_MEMBER_STRUCT, "STRUCT_MEMBER_STRUCT", &structmem_rec[3], &structmem_rec[4], &target_schema[22], NULL}
};

/* DATA_TYPE table */
struct data_type dt;
db_field dtype_rec[4] = {
   {DATA_TYPE_ID,"id", TYPE_ULONG, 1, DATA_TYPE_ID, 0, 0, 
      "", &dtype_rec[1]},
   {DATA_TYPE_SIZE,"size", TYPE_INT, 1, 0, 0, OFFSET(dt,size),
      "", &dtype_rec[2]},
   {DATA_TYPE_FLAGS,"flags", TYPE_ULONG, 1, 0, 0, OFFSET(dt,flags),
      "", &dtype_rec[3]},
   {DATA_TYPE_NAME,"name", TYPE_CHAR, 32, DATA_TYPE_NAME, 0, OFFSET(dt,name),
      "", NULL}
};

db_index dtype_idx[] = {
   {DATA_TYPE_ID, "DATA_TYPE_ID", dtype_rec, NULL, &target_schema[23], &dtype_idx[1]},
   {DATA_TYPE_NAME, "DATA_TYPE_NAME", &dtype_rec[3], NULL, &target_schema[23], NULL}
};

/* CONSTANT table */
struct constant cn;
db_field const_rec[4] = {
   {CONSTANT_ID,"id", TYPE_ULONG, 1, CONSTANT_ID, 0, 0, 
      "", &const_rec[1]},
   {CONSTANT_NAME,"name", TYPE_CHAR, 32, CONSTANT_NAME, 0, OFFSET(cn,name),
      "", &const_rec[2]},
   {VALUE,"value", TYPE_LONG, 1, VALUE, 0, OFFSET(cn,value),
      "", &const_rec[3]},
   {GROUP,"group", TYPE_LONG, 1, CONSTANT_GROUP_VALUE, CONSTANT_GROUP, OFFSET(cn,group),
      "", NULL}
};

db_index const_idx[] = {
   {CONSTANT_ID, "CONSTANT_ID", const_rec, NULL, &target_schema[24], &const_idx[1]},
   {CONSTANT_NAME, "CONSTANT_NAME", &const_rec[1], NULL, &target_schema[24], &const_idx[2]},
   {VALUE, "VALUE", &const_rec[2], NULL, &target_schema[24], &const_idx[3]},
   {CONSTANT_GROUP_VALUE, "CONSTANT_GROUP_VALUE", &const_rec[2], &const_rec[3], &target_schema[24], NULL}
};

/* CONSTANT_GROUP table */
struct constant_group cg;
db_field constgrp_rec[2] = {
   {CONSTANT_GROUP_ID,"id", TYPE_ULONG, 1, CONSTANT_GROUP_ID, 0, 0, 
      "", &constgrp_rec[1]},
   {CONSTANT_GROUP_NAME,"name", TYPE_CHAR, 32, CONSTANT_GROUP_NAME, 0, OFFSET(cg,name),
      "", NULL}
};

db_index constgrp_idx[] = {
   {CONSTANT_GROUP_ID, "CONSTANT_GROUP_ID", constgrp_rec, NULL, &target_schema[25], &constgrp_idx[1]},
   {CONSTANT_GROUP_NAME, "CONSTANT_GROUP_NAME", &constgrp_rec[1], NULL, &target_schema[25], NULL}
};

/* BC_MACRO table */
struct bc_macro m;
db_field macro_rec[4] = {
   {BC_MACRO_ID,"id", TYPE_ULONG, 1, BC_MACRO_ID, 0, 0, 
      "", &macro_rec[1]},
   {BC_MACRO_TYPE,"type", TYPE_ULONG, 1, 0, 0, OFFSET(m,type), 
      "", &macro_rec[2]},
   {BC_MACRO_NAME,"name", TYPE_CHAR, 32,BC_MACRO_NAME , 0, OFFSET(m,name),
      "", &macro_rec[3]},
   {MACRO,"macro", TYPE_CHAR, 2048, 0, 0, OFFSET(m,macro), 
      "", NULL}
};

db_index macro_idx[] = {
   {BC_MACRO_ID, "BC_MACRO_ID", macro_rec, NULL, &target_schema[26], &macro_idx[1]},
   {BC_MACRO_NAME, "BC_MACRO_NAME", &macro_rec[2], NULL, &target_schema[26], NULL}
};


/* TARGET SCHEMA */
db_table target_schema[27] = {
   { ADDRESS, "ADDRESS", sizeof(struct address), 
     address_rec, address_idx, &target_schema[1] }, 
   { SECTION, "SECTION", sizeof(struct section), 
     section_rec, section_idx, &target_schema[2] },
   { XREF, "XREF", sizeof(struct xref), 
     xref_rec, xref_idx, &target_schema[3] },
   { CODE, "CODE", sizeof(struct code), 
     code_rec, code_idx, &target_schema[4] },
   { ADDR_EXP, "ADDR_EXP", sizeof(struct addr_exp), 
     addrexp_rec, addrexp_idx, &target_schema[5] },
   { CODE_EFFECT, "CODE_EFFECT", sizeof(struct code_effect), 
     ceffect_rec, ceffect_idx, &target_schema[6] },
   { REG_STATE, "REG_STATE", sizeof(struct reg_state), 
     regstate_rec, regstate_idx, &target_schema[7] },
   { SYSREF, "SYSREF", sizeof(struct sysref), 
     sysref_rec, sysref_idx, &target_schema[8] },
   { INT_CODE, "INT_CODE", sizeof(struct int_code), 
     intcode_rec, intcode_idx, &target_schema[9] },
   { FIN_CODE, "FIN_CODE", sizeof(struct fin_code), 
     fincode_rec, fincode_idx, &target_schema[10] },
   { EXPORT_ADDR, "EXPORT_ADDR", sizeof(struct export_addr), 
     export_rec, export_idx, &target_schema[11] },
   { IMPORT_ADDR, "IMPORT_ADDR", sizeof(struct import_addr), 
     import_rec, import_idx, &target_schema[12] },
   { LIB, "LIB", sizeof(struct lib), 
     lib_rec, lib_idx, &target_schema[13] },
   { STRING, "STRING", sizeof(struct string), 
     string_rec, string_idx, &target_schema[14] },
   { NAME, "NAME", sizeof(struct name), 
     name_rec, name_idx, &target_schema[15] },
   { COMMENT, "COMMENT", sizeof(struct comment), 
     comment_rec, comment_idx, &target_schema[16] },
   { FUNCTION, "FUNCTION", sizeof(struct function), 
     func_rec, func_idx, &target_schema[17] },
   { FUNC_PARAM, "FUNC_PARAM", sizeof(struct func_param), 
     fparam_rec, fparam_idx, &target_schema[18] },
   { FUNC_LOCAL, "FUNC_LOCAL", sizeof(struct func_local), 
     flocal_rec, flocal_idx, &target_schema[19] },
   { FUNC_EFFECT, "FUNC_EFFECT", sizeof(struct func_effect), 
     feffect_rec, feffect_idx, &target_schema[20] },
   { F_INLINE, "F_INLINE", sizeof(struct f_inline), 
     finline_rec, finline_idx, &target_schema[21] },
   { STRUCTURE, "STRUCTURE", sizeof(struct structure), 
     struct_rec, struct_idx, &target_schema[22] },
   { STRUCT_MEMBER, "STRUCT_MEMBER", sizeof(struct struct_member), 
     structmem_rec, structmem_idx, &target_schema[23] },
   { DATA_TYPE, "DATA_TYPE", sizeof(struct data_type), 
     dtype_rec, dtype_idx, &target_schema[24] },
   { CONSTANT, "CONSTANT", sizeof(struct constant), 
     const_rec, const_idx, &target_schema[25] },
   { CONSTANT_GROUP, "CONSTANT_GROUP", sizeof(struct constant_group), 
     constgrp_rec, constgrp_idx, &target_schema[26] },
   { BC_MACRO, "BC_MACRO", sizeof(struct bc_macro), 
     macro_rec, macro_idx, NULL }
};

db_schema all_schemas[] = {
   { 0, "TARGET", target_schema, &all_schemas[1] },
   { 1, "GRAPH", NULL, NULL}
};
