#ifndef BASTARD_DB_QUERY_H
#define BASTARD_DB_QUERY_H

/* data types */
#define TYPE_CHAR    0x01
#define TYPE_SHORT   0x02
#define TYPE_INT     0x03
#define TYPE_LONG    0x04

#define TYPE_UCHAR   0x05
#define TYPE_USHORT  0x06
#define TYPE_UINT    0x07
#define TYPE_ULONG   0x08

#define TYPE_POINTER 0x09 
#define TYPE_TABLEREF 0x0A 
#define TYPE_COLREF  0x0B 
#define TYPE_DBTABLE 0x0C
#define TYPE_STRINGREF  0x0D

#define DB_TYPE_ISSIGNED( x )  \
	x == TYPE_CHAR || x == TYPE_SHORT || x == TYPE_INT || x == TYPE_LONG


/*    F I E L D     */
typedef struct db_field {
   int id;           /* typhoon db ID of field */
   char  *name;      /* name of field */
   int type;         /* data type */
   int size;         /* # of "type" elements: >1 == array of type */
   int index;        /* ID of index for this field; NULL = not indexed */
   int table;        /* ID of table this field references; NULL = not ID */
   int offset;       /* offset from start of record structure */
   char *help;       /* description of field */
   struct db_field *next;
} db_field;


/*    I N D E X     */
typedef struct db_index {
   int id;           /* typhoon ID of index */
   char *name;       /* ASCII name of index */
   db_field *key1;   /* primary key in index (req) */
   db_field *key2;   /* secondary key in index (opt) */
   void *table;      /* pointer to db_table for this index */
   struct db_index *next;
} db_index;


/*    T A B L E     */
typedef struct db_table {
   int id;           /* typhoon ID of table */
   char *name;       /* ASCII name of table */
   int size;         /* size of record structure */
   db_field *fields; /* linked list of fields */
   db_index *index;  /* linked list of indexes */
   struct db_table *next;   
} db_table;


/*    S C H E M  A  */
typedef struct db_schema{
   int id;           /* bastard ID for db */
   char *name;       /* ASCII name of schema, e.g. "target" */
   db_table *tables; /* linked list of tables in schema */
   struct db_schema *next;
} db_schema;


#define REL_NOT      0x01  /* set by user */
#define REL_EQUAL    0x02
#define REL_GREATER  0x04
#define REL_LESS     0x08

#define QUERY_FIRST  0x01  /* set by search function */
#define QUERY_LAST   0x02
#define QUERY_MIN    0x03
#define QUERY_MAX    0x04
#define QUERY_LIST   0x05

typedef struct db_query {
   db_table *table;
   db_index *index;        /* index to use -- optional */
   db_field *field;
   void *value;            /* field must match this value */
   short rel;              /* relation */
   short flag;             /* first, last, min, max, list */
   struct db_query *next;  /* for mutliple conditions */
} db_query;

typedef struct db_result {
   void *data;
   db_table *table;
   struct db_result *next;
} db_result;

db_schema * db_schema_by_name( char *name);
db_table  * db_table_by_name(db_schema *s, char *name);
db_table  * db_table_by_id(db_schema *s, int id);
db_index  * db_index_by_name(db_table *t, char *name);
db_index  * db_index_by_id(db_table *t, int id);
db_field  * db_field_by_name(db_table *t, char *name);
db_field  * db_field_by_id(db_table *t, int id);
int db_field_from_rec( db_field *f, char *rec, char *dest );
int db_set_field_in_rec( db_field *f, char *rec, void *value );
int db_table_head( db_table  *t, void *dest );
int db_table_foot( db_table  *t, void *dest );
int db_table_min( db_table *t, db_field  *f, void *dest );
int db_table_max( db_table *t, db_field  *f, void *dest );
int db_field_cmp(void *rec1, void *rec2, db_field *f);

db_result * db_table_get(db_table *table);
void db_result_free(db_result *r);
void * db_result_data(db_result *r);
int db_result_foreach(db_result *r, void *func, void *data);
int db_result_add(db_result *list, db_result *r);
db_result * db_result_next(db_result *r);
db_result * db_result_prev(db_result *r);
db_result * db_result_head(db_result *r);
db_result * db_result_tail(db_result *r);

int db_type_sizeof( int type );
long db_valtol( void *val, int type ) ;
unsigned long db_valtoul( void *val, int type );
int db_sprint_record(char *buf, int len, char delim, char *table, void *record);
int db_sprint_field(char *buf, int len, db_field *field, void *record);
/* diagnostic functions */
int db_print_record( char *table, void *record);
int db_desc_field(db_field *field);
int db_desc_index(db_index *index);
int db_desc_table(db_table *table);
int db_desc_db(db_schema *schema);

/* dump DB table to file; d_field == field delim, d_rec = record delimiter */
int db_table_dump( int id, char d_field, char d_rec, FILE *stream );

#endif
