/*  O S    E X T E N S I O N  */

#ifndef EXT_OS_H
#define EXT_OS_H

#include <extension.h>


/* OS types */
#define OS_MICROKERNEL	0x00001
#define OS_MONOLITHIC	0x00002
#define OS_REALTIME	0x00010
#define OS_MULTITASK	0x00020
#define OS_SINGLETASK	0x00030
#define OS_POSIX		0x00100	/* supports POSIX features */
#define OS_SYSV		0x00200	/* supports SysV UNIX features */
#define OS_BSD		0x00400	/* supports BSD UNIX features */
#define OS_BIOS		0x01000	/* supports BIOS interrupts */
#define OS_DOS		0x02000	/* supports DOS interrupts */
#define OS_WIN		0x04000	/* supports Win32 API */

#define OS_IS_CRAP( x ) ( x & 0x0000F000 ) /* obvious ;P */


/* SYSREF types */
#define     SYSREF_SYSCALL    1
#define     SYSREF_EXCEPTION  2
#define     SYSREF_TRAP       3
#define     SYSREF_DEVICE     4

#define SYSCALL_PARAM_STACK	1
#define SYSCALL_PARAM_REG	2

#define OS_DEVICE_ID_INT	1
#define OS_DEVICE_ID_STRING	2


/* System Devices */

/** filesystem devices */
#define DEVICE_FDD	0x0001	/* floppy drive */
#define DEVICE_HDD	0x0002	/* hard disk */
#define DEVICE_TAPE	0x0003	/* tape drive */
#define DEVICE_CDROM	0x0004	/* duh */
#define DEVICE_DISK	0x0005	/* other disk */
#define DEVICE_IS_FS( x ) ( x & 0x0F )

/* two-way devices */
#define DEVICE_LPT	0x0010	/* parallel port */
#define DEVICE_SERIAL	0x0020	/* serial port */
#define DEVICE_TTY	0x0030	/* terminal or modem */
#define DEVICE_NIC	0x0040	/* network card */
#define DEVICE_SOUND	0x0050	/* sound card */
#define DEVICE_TIMER	0x0060
#define DEVICE_SOCKET	0x0070
#define DEVICE_PIPE	0x0080
#define DEVICE_STREAM	0x0090
#define DEVICE_SEM	0x00A0	/* semaphore */
#define DEVICE_MSG	0x00B0	/* message */
#define DEVICE_IS_IO( x ) ( x & 0xF0 )

/* output-only */
#define DEVICE_CRT	0x0100	/* console */
#define DEVICE_FB		0x0200	/* video frame buffer */
#define DEVICE_SPKR	0x0300	/* speaker */
#define DEVICE_IS_INPUT( x ) ( x & 0x0F00 )

/* input-only */
#define DEVICE_KBD	0x1000	/* keyboard */
#define DEVICE_JOY	0x2000	/* joy buzzer */
#define DEVICE_MOUSE	0x3000	/* mouse */
#define DEVICE_IS_OUTPUT( x ) ( x & 0xF000 );


/* System Call Types */

/* systemy stuff */
#define SYSCALL_VERSION		0x0000
#define SYSCALL_EXIT		0x0001
#define SYSCALL_REBOOT		0x0002
#define SYSCALL_IDLE		0x0003
#define SYSCALL_ALARM		0x0004
#define SYSCALL_MOUNTFS		0x0005
#define SYSCALL_UNMOUNTFS	0x0006
#define SYSCALL_SYNC		0x0007
#define SYSCALL_CHROOT		0x0008
#define SYSCALL_GETTIME		0x0009
#define SYSCALL_SETTIME		0x000A
#define SYSCALL_SWAP		0x000B	/* swap on/off */
#define SYSCALL_LOG		0x000C
#define SYSCALL_PTRACE		0x000D
#define SYSCALL_LOADMODULE	0x000E
#define SYSCALL_UNLOADMODULE	0x000F

/* process stuff */
#define SYSCALL_FORK		0x0010
#define SYSCALL_EXEC		0x0020
#define SYSCALL_SLEEP		0x0030
#define SYSCALL_KILL		0x0040
#define SYSCALL_NICE		0x0050
#define SYSCALL_GETCWD		0x0060
#define SYSCALL_GETPID		0x0070
#define SYSCALL_WAIT		0x0080
#define SYSCALL_SETUID		0x0090
#define SYSCALL_SETGID		0x00A0
#define SYSCALL_GETUID		0x00B0
#define SYSCALL_GETGID		0x00C0
#define SYSCALL_CREATETHREAD	0x00D0
#define SYSCALL_EXITTHREAD	0x00E0
#define SYSCALL_SIGNAL		0x00F0
#define SYSCALL_SIGMASK		0x0100
#define SYSCALL_PTIMES		0x0200
#define SYSCALL_SETLIMIT	0x0300
#define SYSCALL_GETLIMIT	0x0400
#define SYSCALL_SETSID		0x0500 /* set session id */
#define SYSCALL_GETSID		0x0600
#define SYSCALL_TIMER		0x0700
#define SYSCALL_TERMINAL	0x0800	/* terminal settings */
/* file stuff */
#define SYSCALL_READ		0x01000
#define SYSCALL_WRITE		0x02000
#define SYSCALL_OPEN		0x03000
#define SYSCALL_CLOSE		0x04000
#define SYSCALL_DUP		0x05000
#define SYSCALL_LSEEK		0x06000
#define SYSCALL_STAT		0x07000
#define SYSCALL_CHMOD		0x08000
#define SYSCALL_CHOWN		0x09000
#define SYSCALL_LINK		0x0A000
#define SYSCALL_UNLINK		0x0B000
#define SYSCALL_MKDIR		0x0C000
#define SYSCALL_CHDIR		0x0D000
#define SYSCALL_RMDIR		0x0E000
#define SYSCALL_READDIR		0x0F000
#define SYSCALL_FCNTL		0x10000
#define SYSCALL_PIPE		0x20000
#define SYSCALL_MKNOD		0x30000
#define SYSCALL_IOCTL		0x40000
#define SYSCALL_IOPERM		0x50000
#define SYSCALL_POLL		0x60000
#define SYSCALL_SELECT		0x70000
#define SYSCALL_FTIME		0x80000 	/* change access/mod times */
#define SYSCALL_ACCESS		0x90000	/* check user's file access rights */
#define SYSCALL_FLOCK		0xA0000	/* file lock */
/* mem stuff */
#define SYSCALL_BRK		0x100000
#define SYSCALL_MEMMAP		0x200000
#define SYSCALL_MEMUNMAP	0x300000
#define SYSCALL_MEMPROTECT	0x400000
#define SYSCALL_MEMSYNC		0x500000
#define SYSCALL_MEMLOCK		0x600000
#define SYSCALL_MEMUNLOCK	0x700000
/* net stuff */
#define SYSCALL_SOCKET		0x1000000
#define SYSCALL_SOCKACCEPT	0x2000000
#define SYSCALL_SOCKBIND	0x3000000
#define SYSCALL_SOCKCONNECT	0x4000000
#define SYSCALL_SOCKLISTEN	0x5000000
#define SYSCALL_SOCKRECV	0x6000000
#define SYSCALL_SOCKSEND	0x7000000
#define SYSCALL_SOCKSHUTDOWN	0x8000000
#define SYSCALL_IPC		0x9000000

#define SYSCALL_UNKNOWN		0xFFFFFFFE
#define SYSCALL_INVALID		0xFFFFFFFF


/* Exception Types */
#define EXCEP_DIVBYZERO	0x00
#define EXCEP_TRAP	0x01	/* debug */
#define EXCEP_NMI		0x02	/* non-maskable INT */
#define EXCEP_OFLOW	0x03	/* overflow */
#define EXCEP_BOUNDS	0x04
#define EXCEP_INVALID	0x05	/* invalid opcode */
#define EXCEP_DEVICE	0x06	/* device not available */
#define EXCEP_DOUBLE	0x07	/* double fault */
#define EXCEP_FPU		0x08	/* FPU fault */
#define EXCEP_TSS		0x09	/* invalid TSS */
#define EXCEP_SEG		0x0A	/* segment not present */
#define EXCEP_PAGE	0x0B	/* page not present */
#define EXCEP_STACK	0x0C	/* stack overrun */
#define EXCEP_GPF		0x0D	/* protection fault */
#define EXCEP_MACH	0x0E	/* machine check */
#define EXCEP_ALIGN	0x0F	/* data not aligned */

#define EXCEP_SYSCALL	0xF0	/* system call vector */



typedef int (*sysref_gen_fn)( struct code *, struct sysref * );
typedef int (*sysref_name_fn)( struct sysref *, char *, int );

struct EXT__OS {					/* target OS */
  	 struct EXTENSION ext;
   	/* data items */
	unsigned int type;			/* type of OS, per constants above */
	unsigned int syscall_param_type;	/* reg? stack? */
	unsigned int syscall_max_params;	/* number of params */
	unsigned int device_id_type;		/* int? string? */
	/* exported routines */
	sysref_gen_fn fn_sysref_gen;		/* Generate SYSREF from CODE */
	sysref_name_fn  fn_sysref_name;		/* Return name of sysref */
} ;

extern struct EXT__OS *ext_os;

/* Private Parts ;)  */
	#ifndef INCLUDED_FROM_BASTARD_H

	#endif

#endif
