#include <stdio.h>
#include <stdlib.h>

#include <bastard.h>
#include <extension.h>
#include <vm.h>



struct EXT__ARCH *settings;	/* might come in handy */

void ext_arch_init(void *param)
{
	settings = (struct EXT__ARCH *) param;

	if (!settings)
		return;

	/* sys_init register info */
	settings->sz_regtable = 1;
	settings->reg_table = calloc(sizeof (struct REGTBL_ENTRY), 1);
	settings->reg_storage = calloc(32, 1);
	vm_add_regtbl_entry(0, "reg0", 4, 0);

	/* set CPU specific information */
	settings->sz_addr = 0;
	settings->sz_oper = 0;
	settings->SP = 0;
	settings->IP = 0;
	settings->sz_inst = 0;
	settings->sz_byte = 0;
	settings->sz_word = 0;
	settings->sz_dword = 0;
	settings->endian = LITTLE_ENDIAN_ORD;
	return;
}

void ext_arch_cleanup(void)
{
	if (settings->reg_table)
		free(settings->reg_table);
	if (settings->sz_regtable)
		settings->sz_regtable = 0;
	if (settings->reg_storage)
		free(settings->reg_storage);
	return;
}

/* --- Exported Information Routines -------------------------------------*/
/* These are used to pass information about the platform to the higher-level
 * disassembler  -- there will probably be more added when additional CPUs
 * are supported */
int get_prologue(struct code **table)
{
	return (0);
}

int get_epilogue(struct code **table)
{
	return (0);
}


/* get the effects on registers of a specified instruction */
int get_code_effect(char *mnemonic, struct code_effect *e)
{
	/* the mnemonic is used to determine the effects of instructions
	 * which are predetermined, e.g. a call or a push affecting the 
	 * stack pointer. All effects dependent on operands are managed
	 * by the calling program */
	return (0);
}
/* generate intermediate code for a function */
int gen_int(int func_id)
{
	return (0);
}
/* ------------ Disassembly Routines ----------------------------------- */

/* this function is called by the controlling disassembler, so its name and
 * calling convention cannot be changed */
int disasm_addr(char *buf, char tbl, struct code *c, long rva)
{
	/*   buf points to the loc of the current opcode (start of the 
	   *        intruction) in the instruction stream. The instruction stream
	   *        is assumed to be a buffer ob bytes read directly from the file
	   *        for the purpose of disassembly; a mmapped file is ideal for 
	   *        this.
	   *    tbl indicates which table to lookup this opcode in; 0 is the main
	   *        opcode table and is the only table that should be referenced by
	   *        a non-recursive call.
	   *    c   points to a code structure which will be filled by InstDecode
	   *    rva is the virtual address of the current instruction
	   *    returns the size of the decoded instruction in bytes */
	int size = 0;

	/* decode instruction here and return size */

	return (size);
}
