#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "i386.h"


extern struct EXT__ARCH *settings;	/* might come in handy */

/* In defining these patterns, we use the RVA field to denote what 'pattern
 * number' we are in/termiknating; an RVA of 0 indicates the end of the 
 * table.
 * The fields used in these code structs are:
    {id, unused, mnemonic, dest, src, aux, mnemType, destType, srcType, auxType}
 * If any of these fields (excepting rva and 'unused') is non-zero, the 
 * equivalent field in any prospective-match code structs must equal the 
 * contents of the fiels for the pattern to match */
struct code prologue_patterns[] = {
	/* prolog1:  push esp
	 *           mov  ebp, esp
	 *           sub  esp, ??? */
	{1, 0, "push", 5 + REG_DWORD_OFFSET, 0},
	{1, 0, "mov", 5 + REG_DWORD_OFFSET, 4 + REG_DWORD_OFFSET, 0},
	{1, 0, "sub", 4 + REG_DWORD_OFFSET, 0},
	{1, 0},			/* Terminator for prologue 1 */
	/* prolog2: enter */
	{2, 0, "enter", 0},
	{2, 0},			/* Terminator for prologue 2 */
	{0}			/* NULL 'rva' terminates array */
};

struct code epilogue_patterns[] = {
	/* epilog1:  ret */
	{1, 0, "ret", 0},
	{1, 0},			/* Terminator for prologue 1 */
	/* epilog2: retf */
	{2, 0, "retf", 0},
	{2, 0},			/* Terminator for prologue 1 */
	/* epilog3: iret */
	{3, 0, "iret", 0},
	{3, 0},			/* Terminator for prologue 1 */
	{0}			/* NULL 'rva' terminates array */
};


int compare_code_with_pattern(unsigned long rva, struct code *table, int index)
{
	struct code c;
	int x;

	bdb_index_find(CODE_RVA, &rva, &c);
	for (x = index; table[x].rva == table[index].rva; x++) {

		if (table[x].mnemonic[0]
		    && strcmp(c.mnemonic, table[x].mnemonic)) return (0);
		if (table[x].dest && table[x].dest != c.dest)
			return (0);
		if (table[x].src && table[x].src != c.src)
			return (0);
		if (table[x].aux && table[x].aux != c.aux)
			return (0);
		if (table[x].mnemType && table[x].mnemType != c.mnemType)
			return (0);
		if (table[x].destType && table[x].destType != c.destType)
			return (0);
		if (table[x].srcType && table[x].srcType != c.srcType)
			return (0);
		if (table[x].auxType && table[x].auxType != c.auxType)
			return (0);

		/* ok, we matched this line,  get next CODE and try next line */
		bdb_index_next(CODE_RVA, &c);
	}
	return (1);
}

int test_for_code_pattern(unsigned long rva, int pattern)
{
	struct code *patterns;
	int x, pat = 0;

	switch (pattern) {
	case FUNCTION_PROLOGUE:
		patterns = prologue_patterns;
		break;
	case FUNCTION_EPILOGUE:
		patterns = epilogue_patterns;
		break;
	default:
		return (0);
	}

	/* check to see if current RVA matches pattern */
	for (x = 0; patterns[x].rva; x++) {
		if (patterns[x].rva > pat) {
			pat++;
			if (compare_code_with_pattern(rva, patterns, x)) {
				return (1);	/* we have a match */
			}
		}		/* else skip past it */
	}

	/* no pattern match */
	return (0);
}

