#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "i386.h"

struct EXT__ARCH *settings;	/* might come in handy */


/* get the side effects of a specified instruction */
int gen_code_effect(struct code *c, struct code_effect *e)
{
	/* the instr type is used to determine the effects of instructions
	 * which are predetermined, e.g. a call or a push affecting the 
	 * stack pointer. All effects dependent on operands are managed
	 * by the calling program */
	e->rva = c->rva;
	e->type = OP_REG;		/* register side effect */
	e->amount = 0;		/* unknown amount */
	switch ( c->mnemType & INS_TYPE_MASK ) {
		case INS_PUSH:
			e->loc = settings->SP;
			e->change = CEFFECT_SUB;
			e->amount = settings->sz_addr;
			break;
		case INS_POP:
			e->loc = settings->SP;
			e->change = CEFFECT_ADD;
			e->amount = settings->sz_addr;
			break;
		case INS_LOOP:
			e->loc = settings->reg_gen + 1; /* ECX */
			e->change = CEFFECT_KILL;
			break;
		case INS_STRLOAD:
		case INS_XLAT:
			e->loc = settings->reg_gen; /* EAX */
			e->change = CEFFECT_KILL;
			break;
	}

	/* Thus will have to be more complete... */
	/* if (! rv) ...do  by c->mnemonic */
	/* todo : div, idiv, imul, mul, rep, movsb, stosb, daa, aaa, das, aas */
	/*        enter, leave, cwd, cdq, cbw, aam, aad */

	if ( e->change ) return(1);
	
	return (0);
}

