#include <stdlib.h>
#include <string.h>
#include <bastard.h>
#include <extension.h>


/* Sample format strings for ASM output */
#define NORM    "\033[0m"
#define RED     "\033[31m"
#define GREEN   "\033[32m"
#define BROWN   "\033[33m"
#define BLUE    "\033[34m"
#define MAGENTA "\033[35m"
#define CYAN    "\033[36m"
#define WHITE   "\033[1m"

char asmColor[] = WHITE "%n" NORM "%:%^"
    RED "%a " MAGENTA "%8b\t"
    GREEN "%m\t" CYAN "%d" NORM "%, " CYAN "%s" NORM "%, " BLUE "%t"
    NORM " %;" BROWN "%c %x" NORM;
char asmMono[] = "%n%:%^%a %8b\t%m\t%d%, %s %;%c %x";
char dataColor[] = WHITE "%n" NORM "%:%^%a " BLUE "%8b\t"
    NORM "%;" BROWN "%c %x" NORM;
char dataMono[] = "%n%:%^%a %8b\t%;%c %x";


/* misc assembler-specific strings used by asmsprintf() */
char comment_prefix[] = ";",
    reg_prefix[] = "", imm_prefix[] = "", local_prefix[] = "@@";



struct EXT__ASM *settings;
/* ---------------------------------------------------- EXT_ASM init() */
void ext_asm_init(void *param)
{
	settings = (struct EXT__ASM *) param;

	if (!settings)
		return;
	/* set Language-Specific information */
	settings->asm_ttyColor = asmColor;	/* so I'm cheating, big deal... */
	settings->asm_ttyMono = asmMono;
	settings->asm_file = asmMono;
	settings->asm_lpr = asmMono;

	settings->data_ttyColor = dataColor;
	settings->data_ttyMono = dataMono;
	settings->data_file = dataMono;
	settings->data_lpr = dataMono;

	settings->comment = comment_prefix;
	settings->reg_pre = reg_prefix;
	settings->imm_pre = imm_prefix;
	settings->local_pre = local_prefix;

	return;
}

/* ---------------------------------------------------- EXT_ASM cleanup() */
void ext_asm_cleanup(void)
{
	return;
}


/* Print address rva as either code or data according to 'output' format */
int sprint_code(long rva, char *line, int len, int output)
{
	return (0);
}

/* Print start-of-function declaration to buffer str */
int sprint_asm_func_start(char *str, int len, int func_id)
{
	return (0);
}

/* Print end-of-function declaration to buffer str */
int sprint_asm_func_end(char *str, int len, int func_id)
{
	return (0);
}

/* format and print a structure to buffer str of length len */
int sprint_asm_struct(char *str, int len, long rva)
{
	/* rva will supply struct ID, etc */
	return (0);
}


/* Print start-of-section declaration */
int sprint_section_start(char *str, int len, char *name)
{
	return (0);
}

/* Print end-of-section declaration */
int sprint_section_end(char *str, int len, char *name)
{
	return (0);
}




/* Format and print an address expression to buffer str of length len  */
int sprint_addrexp(char *str, int len, char *scale, char *index, char *base,
		   char *disp, int sign)
{		
	char idx[16] = { 0 };
	char tmp[32] = {0};
		
	str[0] = '\0';
		
	if (disp[0]) {
		if (sign & 0x0001) strncat( str, "-", 1);
		strncat(str, disp, len - strlen(str));
	}
		
	if (base[0]) {
		strncat(tmp, base, 32 - strlen(tmp));
	}
	if (index[0]) {
		strncat(tmp, ", ", 32 - strlen(tmp));
		strncat(tmp, index, 32 - strlen(tmp));
	} else if (scale[0]) {
		strncat(tmp, ",", 32 - strlen(tmp));
	}
	if (scale[0]) {
		strncat(tmp, ",", 32 - strlen(tmp));
		strncat(tmp, scale, len - strlen(tmp));
	}
	if (tmp[0]) {
		strncat(str, "(", len - strlen(str));
		strncat(str, tmp, len - strlen(str));
		strncat(str, ")", len - strlen(str));
	}
	return (0);
}

/* Generate a .asm file called "path" */
int gen_asm_file(char *path)
{
	return (1);
}
