#include <stdio.h>
#include <bastard.h>

/* usage: bdbdump bdb_file [table] */

/*	id	ID of table or index to dump
	d_field	field delimiter	[ default = ',' ]
	d_rec		record delimiter	[ default = '\n' ]
	fd		file descriptor to write to [ 0 == STDOUT ]
*/
int print_usage()
{
	printf("bdbdump bdb_file [table] ...\n");
	return (1);
}

int db_table_header(char *name)
{
	printf("\n[%s]\n", name);
	return (1);
}

int main(int argc, char **argv)
{
	struct db_schema *schema;
	struct db_table *table;
	char home[PATH_MAX];
	int x;

	if (argc < 2)
		return (print_usage());

	/* init bastard */
	if (!sys_find_home(home, PATH_MAX, argv))
		return (-1);

	sys_init(home);
	env_set_option( "QUIET" );

	/* get bdb filename */
	target_load_bdb(argv[1]);
	schema = db_schema_by_name("TARGET");

	if (argc > 2) {
		/* dump only tables requested */
		for (x = 2; x < argc; x++) {
			db_table_header(argv[x]);
			table = db_table_by_name(schema, argv[x]);
			db_table_dump(table->id, ',', '\n', stdout);
		}
	} else {
		table = schema->tables;
		while (table) {
			db_table_header(table->name);
			db_table_dump(table->id, ',', '\n', stdout);
			table = table->next;
		}
	}

	/* close bastard */
	target_close_db();
	sys_quit();
	return (0);
}
