#ifndef BSQLTREE_H
#define BSQLTREE_H

#include "db_bsql.h"

struct TREENODE ;
typedef void * (*TREENODE_FN)( struct TREENODE *n, void *data );

struct TREENODE {
	TREENODE_FN op;
	struct TREENODE *p, *lc, *rc;
};

struct TREELEAF {
	TREENODE_FN op;
	struct TREENODE *p;
	int type;
	union {
		char c;
		unsigned char uc;
		short s;
		unsigned short us;
		int i;
		unsigned int ui;
		long l;
		unsigned long ul;
		char *str;
		struct BSQL_COL *col;		/* ref to a BSQL column */
		struct db_table *db_table;		/* ref to a Typhoon Table */
		struct BSQL_TMPTBL *table;	
	}u;
};

/* =============================================== POINTLESS CODE */
/* generic tree node operator: in case 'op' doesn't get initialized */
char * bsql_tree_gennodeop ( struct TREENODE *n, void *data ) ;


/* =============================================== TOP-LEVEL TREE NODES */
char * bsql_select_nodeop( struct TREENODE *n, void *data );
int bsql_insert_nodeop( struct TREENODE *n, void *data );
int bsql_update_nodeop( struct TREENODE *n, void *data );
int bsql_delete_nodeop( struct TREENODE *n, void *data );

/* ====================================================== SECONDARY NODES */
struct BSQL_TMPTBL * bsql_insertasgn_nodeop( struct TREENODE *n, void *data ) ;
struct BSQL_TMPTBL * bsql_updateasgn_nodeop( struct TREENODE *n, void *data ) ;
struct BSQL_TMPTBL * bsql_subsel_nodeop( struct TREENODE *n, char *data ) ;
struct BSQL_TMPTBL * bsql_tablesel_nodeop( struct TREENODE *n, char *data ) ;
struct BSQL_TMPTBL * bsql_join_nodeop( struct TREENODE *n, void *data ) ;


/* ====================================================== TERTIARY NODES */
#define IS_TMPTBL_NODE(x) ( x->op == bsql_subsel_nodeop || \
		x->op == bsql_tablesel_nodeop || \
		x->op == bsql_join_nodeop || \
		x->op == bsql_tablecpy_nodeop  )

struct BSQL_TMPTBL * bsql_tablecpy_nodeop( struct TREENODE *n, void *data ) ;
struct BSQL_TMPTBL * bsql_tbllst_nodeop( struct TREENODE *n, void *data ) ;
struct BSQL_COL * bsql_collst_nodeop( struct TREENODE *n, void *data ) ;
struct BSQL_VALLIST * bsql_vallst_nodeop( struct TREENODE *n, char *data ) ;
struct BSQL_TMPTBL * bsql_asgn_nodeop( struct TREENODE *n, 
							struct BSQL_TMPTBL *table ) ;
struct BSQL_TMPTBL * bsql_staticrow_nodeop( struct TREENODE *n, char *data ) ;

/* ==================================================== BOOLEAN NODES */
#define IS_BOOL_NODE(x) ( x->op == bsql_booland_nodeop || \
		x->op == bsql_boolor_nodeop || \
		x->op == bsql_boolnot_nodeop )

int bsql_booland_nodeop( struct TREENODE *n, struct BSQL_TABLEEXPR_ARG *data ) ;
int bsql_boolor_nodeop( struct TREENODE *n, struct BSQL_TABLEEXPR_ARG *data ) ;
int bsql_boolnot_nodeop( struct TREENODE *n, struct BSQL_TABLEEXPR_ARG *data ) ;

/* ==================================================== COMPARISON NODES */
#define IS_COND_NODE(x) ( x->op == bsql_cmpgen_nodeop ||  \
		x->op == bsql_cmplt_nodeop || \
		x->op == bsql_cmple_nodeop || \
		x->op == bsql_cmpeq_nodeop || \
		x->op == bsql_cmpge_nodeop || \
		x->op == bsql_cmpgt_nodeop || \
		x->op == bsql_cmpne_nodeop  )

int bsql_cmpgen_nodeop( struct BSQL_VALREF *v1, struct BSQL_VALREF *v2 ) ;
int bsql_cmplt_nodeop( struct TREENODE *n, struct BSQL_TABLEEXPR_ARG *data ) ;
int bsql_cmple_nodeop( struct TREENODE *n, struct BSQL_TABLEEXPR_ARG *data ) ;
int bsql_cmpeq_nodeop( struct TREENODE *n, struct BSQL_TABLEEXPR_ARG *data ) ;
int bsql_cmpge_nodeop( struct TREENODE *n, struct BSQL_TABLEEXPR_ARG *data ) ;
int bsql_cmpgt_nodeop( struct TREENODE *n, struct BSQL_TABLEEXPR_ARG *data ) ;
int bsql_cmpne_nodeop( struct TREENODE *n, struct BSQL_TABLEEXPR_ARG *data ) ;

/* ==================================================== MATHOP NODES */
typedef unsigned long (*BSQL_MATHOP_FN)(unsigned long, unsigned long);

unsigned long bsql_mathop_add( unsigned long l1, unsigned long l2 ) ;
unsigned long bsql_mathop_sub( unsigned long l1, unsigned long l2 ) ;
unsigned long bsql_mathop_mul( unsigned long l1, unsigned long l2 ) ;
unsigned long bsql_mathop_div( unsigned long l1, unsigned long l2 ) ;
unsigned long bsql_mathop_and( unsigned long l1, unsigned long l2 ) ;
unsigned long bsql_mathop_or( unsigned long l1, unsigned long l2 ) ;
unsigned long bsql_mathop_xor( unsigned long l1, unsigned long l2 ) ;

struct BSQL_VALREF * bsql_mathgen_nodeop( struct BSQL_VALREF *v1, 
					struct BSQL_VALREF *v2, BSQL_MATHOP_FN fn ) ;

#define IS_MATHOP_NODE(x) ( x->op == bsql_mathadd_nodeop || \
		x->op == bsql_mathsub_nodeop || \
		x->op == bsql_mathdiv_nodeop || \
		x->op == bsql_mathmul_nodeop || \
		x->op == bsql_mathand_nodeop || \
		x->op == bsql_mathor_nodeop || \
		x->op == bsql_mathxor_nodeop )

struct BSQL_VALREF * bsql_mathadd_nodeop( struct TREENODE *n, 
							 struct BSQL_TABLEEXPR_ARG *data ) ;
struct BSQL_VALREF * bsql_mathsub_nodeop( struct TREENODE *n, 
							 struct BSQL_TABLEEXPR_ARG *data ) ;
struct BSQL_VALREF * bsql_mathdiv_nodeop( struct TREENODE *n, 
							 struct BSQL_TABLEEXPR_ARG *data ) ;
struct BSQL_VALREF * bsql_mathmul_nodeop( struct TREENODE *n, 
							 struct BSQL_TABLEEXPR_ARG *data ) ;
struct BSQL_VALREF * bsql_mathand_nodeop( struct TREENODE *n, 
							 struct BSQL_TABLEEXPR_ARG *data ) ;
struct BSQL_VALREF * bsql_mathor_nodeop( struct TREENODE *n, 
							 struct BSQL_TABLEEXPR_ARG *data ) ;
struct BSQL_VALREF * bsql_mathxor_nodeop( struct TREENODE *n, 
							 struct BSQL_TABLEEXPR_ARG *data ) ;


/* =================================================== LEAF NODE */
struct BSQL_VALREF * bsql_valref_nodeop( struct TREENODE *n, 
							 struct BSQL_TABLEEXPR_ARG *data ) ;



/* ===================================================== TREE NODE Creation */

void bsql_newnode_setchildren( struct TREENODE *n, void *l, void *r ) ;


/* primary nodes */
struct TREENODE * bsql_new_insert( struct TREENODE *asgn, 
							struct TREELEAF *db ) ;
struct TREENODE * bsql_new_update( struct TREENODE *asgn, 
							struct TREELEAF *db ) ;
struct TREENODE * bsql_new_delete( struct TREENODE *items, 
							struct TREELEAF *db ) ;
struct TREENODE * bsql_new_select( struct TREENODE *tblexpr ) ;

/* secondary nodes */
struct TREENODE * bsql_new_insertasgn( struct TREENODE *expr, 
							struct TREENODE *asgn ) ;
struct TREENODE * bsql_new_updateasgn( struct TREENODE *expr, 
							struct TREENODE *asgn ) ;
struct TREENODE * bsql_new_subsel( struct TREENODE *tblexpr, 
							struct TREENODE *collst ) ;
struct TREENODE * bsql_new_tablesel( struct TREENODE *tmptbl, 
							struct TREENODE *cond ) ;
struct TREENODE * bsql_new_join( struct TREENODE *t1, struct TREENODE *t2, 
							struct TREENODE *cond ) ;

/* tertiary nodes */
struct TREENODE * bsql_new_tablecpy( struct TREELEAF *table ) ;
struct TREENODE * bsql_new_tbllst( struct TREENODE *list, 
							struct TREENODE *table ) ;
struct TREENODE * bsql_new_collst( struct TREENODE *list, 
							struct TREELEAF *col ) ;
struct TREENODE * bsql_new_vallst( struct TREENODE *list, 
							struct TREELEAF *val ) ;
struct TREENODE * bsql_new_asgn( struct TREENODE *asgn, 
							struct TREENODE *cols ) ;
struct TREENODE * bsql_new_staticrow( struct TREENODE *vals ) ; 

/* boolean nodes */
struct TREENODE * bsql_new_bool( struct TREENODE *left, 
					struct TREENODE *right, int type ) ;

/* comparison nodes */
struct TREENODE * bsql_new_cmp( struct TREENODE *left, 
					struct TREENODE *right, int type ) ;

/* mathop nodes */
struct TREENODE * bsql_new_mathop( struct TREENODE *left, 
					struct TREENODE *right, int type ) ;

/* =========================================== New LeafNodes */
struct TREELEAF * bsql_new_dbtable( int id ) ;
struct TREELEAF * bsql_new_colref( struct BSQL_COL *col ) ;
struct TREELEAF * bsql_new_tableref( struct BSQL_TMPTBL *t ) ;
struct TREELEAF * bsql_new_string( char *str ) ;
struct TREELEAF * bsql_new_lvalue( unsigned long val ) ;

#endif

