/* Configuration Database for BASTARD */

database config {
   data  file  "profile_env.db"  contains profile_env;
   key   file  "profile_env.ix1" contains profile_env.user;
   data  file  "profile_pref.db"  contains profile_pref;
   key   file  "profile_pref.ix1" contains profile_pref.user;
   data  file  "profile_asm.db"  contains profile_asm;
   key   file  "profile_asm.ix1" contains profile_asm.name;
   data  file  "profile_arch.db"  contains profile_arch;
   key   file  "profile_arch.ix1" contains profile_arch.name;
   data  file  "hist_macro.db"  contains hist_macro;
   key   file  "hist_macro.ix1" contains hist_macro.name;
   data  file  "hist_cmd.db"  contains hist_cmd;
   key   file  "hist_cmd.ix1" contains hist_cmd.id;
   data  file  "profile_target.db"  contains profile_target;
   key   file  "profile_target.ix1" contains profile_target.name;
   key   file  "profile_target.ix2" contains profile_target.dbname;

record profile_env {
   char user[32];
   char home[256];
   char p1[16];
   char p2[16];
   char p3[16];
   char p4[16];
   char dbpath[256];
   int output;

   primary key user;
}

record profile_pref {
   char user[32];
   
   char arch[32];
   char asmblr[32];
   char format[32];
   char lang[32];

   char pager[256];
   char editor[256];
   char debugger[256];

   int options;

   primary key user;
}

record profile_asm {
   char name[32];

   char asm_ttyColor[128];
   char data_ttyColor[128];
   char asm_ttyMono[128];
   char data_ttyMono[128];
   char asm_file[128];
   char data_file[128];
   char asm_lpr[128];
   char data_lpr[128];

   primary key name;
}

record profile_arch {
   char name[32];
   int options;

   primary key name;
}

record hist_macro {
   int type;
   char name[32];
   char macro_text[2048];

   primary key name;
}

record hist_cmd {
   int id;
   char cmd[256];

   primary key id;
}

record profile_target {
   char name[64];
   char path[256];
   char dbname[256];
   int size;
   long entry;
   char arch[32];
   char asmblr[32];
   char format[32];
   char lang[32];

   primary key name;
   alternate key dbname;
}

}
