#include <cli/bastard_main.h>
#include <readline/readline.h>
#include <readline/history.h>
#include <config.h>

extern int binfromstdin, runbatch;	/* from bastard.c, used in QUIT */
extern FILE *batch_file;

/* --------------------------------------------------------------------- */

void cmdSET(int argc, char **argv, struct COMMAND *c)
{
	/* set internal ENV variables */
	char *opt, msg[64];
	int rv;

	if (!argc || !argv[0])
		opt = NULL;
	else
		opt = argv[0];

	if (env_set_option(opt) > 0 && (rv = env_get_option(opt)) > -1) {
		if (rv > 0)
			sprintf(msg, "%s = ON\n", opt);
		else
			sprintf(msg, "%s = OFF\n", opt);
		sys_msg(msg);
	}
	return;
}

void cmdSHOW(int argc, char **argv, struct COMMAND *c)
{
	/* show internal ENV variables */
	char *opt, msg[64];
	int rv;

	if (!argc || !argv[0])
		opt = NULL;
	else
		opt = argv[0];

	if ((rv = env_get_option(opt)) > -1) {
		if (rv > 0)
			sprintf(msg, "%s = ON\n", opt);
		else
			sprintf(msg, "%s = OFF\n", opt);
		sys_msg(msg);
	}
	return;
}

void cmdDB(int argc, char **argv, struct COMMAND *c)
{
	sys_msg("Seek HELP\n");
	return;
}

void cmdLOAD(int argc, char **argv, struct COMMAND *c)
{
	/* generic file load/disassembler. Assumes a.out, ELF, i386 */
	struct DISASM_ENV *disasm_env = env_get_env();
	struct DISASM_TGT *target = env_get_target();
	char cmd_buf[PATH_MAX], db_buf[PATH_MAX];
	char buf[PATH_MAX];
	unsigned char y;
	int err = 0;

	/* wrapper for multiple API routines */
	if (disasm_env->flags & DB_LOADED)
		target_close_db();	//duplicated in db_load but nec.

	if ( argc && argv[0][0] ) { 
		strncpy( buf, argv[0], PATH_MAX );
	} else if ( target->info.name ) {
		snprintf( buf, PATH_MAX, "%s/%s", target->info.path, 
				target->info.name );
	} else  {
		sys_msg("Please specify a target name\n");
		return;
	}

	if (target->status < DISASM_TGT_LOADED && ! target_load(buf)) {
		err = sys_get_lasterr();
		/* Note that dbname has been set already by target_load() */
		if ( env_get_opt_flag(ANNOY_USER) && err == 4501 ) {
			sprintf(db_buf, "%s/%s", disasm_env->dbpath, target->info.dbname);
			sys_msg( "Found previous .bdb ... use it? (y/n)\n");
			y = getc(stdin);
			getc(stdin);	/* strip CR */
			err = 0;
			if ( y == 'Y' || y == 'y' ) {
				if (! target_load_bdb( db_buf ) )
					err = sys_get_lasterr();
			} else {
				/* move and load target */
				sprintf(cmd_buf, "%s/%s.old", disasm_env->dbpath, target->info.dbname);
				rename( db_buf, cmd_buf );
				if ( ! target_load(buf) )
					err = sys_get_lasterr();
			}
		} else if ( env_get_opt_flag(ANNOY_USER) && err == 4502 ) {
			sprintf(db_buf, "%s/.%s", disasm_env->dbpath, target->info.dbname);
			sys_msg( "Found .bdb dir from previous load ... recover (y/n)?\n");
			y = getc(stdin);
			getc(stdin);
			err = 0;
			if ( y == 'Y' || y == 'y' ) {
				if (! target_load_bdb( db_buf ) )
					err = sys_get_lasterr();
			} else {
				/* delete and load target */
				sprintf(cmd_buf, "rm -rf %s", db_buf);
				pclose( popen(buf, "r") );
				if ( ! target_load(buf) )
					err = sys_get_lasterr();
			}
		} 
		if ( err ) {
			DEBUG_Print("target_load Failed!\n");
			sys_print_errmsg(sys_get_lasterr());
			return;
		}
	}

	/* target has now been loaded with default extensions */
	if (argc > 1 && argv[1][0])
		strncpy(target->format.name, argv[1], 15);
	if (argc > 2 && argv[2][0])
		strncpy(target->arch.name, argv[2], 31);
	if (argc > 3 && argv[2][0])
		strncpy(target->os.name, argv[2], 31);
	if (argc > 4 && argv[3][0])
		strncpy(target->assembler.name, argv[3], 31);
	if (argc > 5 && argv[2][0])
		strncpy(target->comp.name, argv[2], 31);
	if (argc > 6 && argv[4][0])
		strncpy(target->lang.name, argv[4], 31);

	if (target->status < DISASM_TGT_FORMAT_SET &&
	    !target_set_format(target->format.name, 0)) {
		DEBUG_Print("target_set_format Failed!\n");
		err = sys_get_lasterr();
	} else if (target->status < DISASM_TGT_ARCH_SET &&
		   !target_set_arch(target->arch.name, 0)) {
		DEBUG_Print("target_set_arch Failed!\n");
		err = sys_get_lasterr();
	} else if (target->status < DISASM_TGT_OS_SET &&
		   !target_set_os(target->os.name, 0)) {
		DEBUG_Print("SetTargetOS Failed!\n");
		err = sys_get_lasterr();
	} else if (target->status < DISASM_TGT_ASM_SET &&
		   !target_set_asm(target->assembler.name, 0)) {
		DEBUG_Print("SetTargetAsm Failed!\n");
		err = sys_get_lasterr();
	} else if (target->status < DISASM_TGT_COMP_SET &&
		   !target_set_comp(target->comp.name, 0)) {
		DEBUG_Print("SetTargetComp Failed!\n");
		err = sys_get_lasterr();
	} else if (target->status < DISASM_TGT_LANG_SET &&
		   !target_set_lang(target->lang.name, 0)) {
		DEBUG_Print("SetTargetLang Failed!\n");
		err = sys_get_lasterr();
	} else if (target->status < DISASM_TGT_DISASM &&
		   !disasm_target("full", NULL)) {
		DEBUG_Print("disasm_target Failed!\n");
		err = sys_get_lasterr();
	}

	if (err)
		sys_print_errmsg(err);

	return;
}

void cmdEXEC(int argc, char **argv, struct COMMAND *c)
{
	int x, len;
	char cline[256] = { 0 };
	struct DISASM_ENV *disasm_env = env_get_env();

	if (!(disasm_env->flags & DISABLE_EXEC)) {
		if (argc && argv[0]) {
			sprintf(cline, "/bin/sh -c");
			for (x = 0; x < argc; x++) {
				len = 256 - strlen(cline);
				len = (len > 0) ? len : 0;
				strncat(cline, " ", len);
				strncat(cline, argv[x], --len);

			}
		} else {
			strcpy(cline, "/bin/sh -ri");
		}
		system(cline);
	}
	return;
}

void cmdDEBUG(int argc, char **argv, struct COMMAND *c)
{
	/* debug the target executable */
	/* maps to API routine */
	sys_debug();
	return;
}

void cmdQUIT(int argc, char **argv, struct COMMAND *c)
{
	/* leave the app */
	int x;
	FILE *f;
	char buf[PATH_MAX];
	HIST_ENTRY *hist;

	struct DISASM_ENV *disasm_env = env_get_env();
	struct DISASM_PREFS *disasm_prefs = env_get_prefs();
	struct DISASM_TGT *target = env_get_target();
	x = disasm_prefs->num_hist;

	sprintf(buf, "%s/.bastard/cmd_history", getenv("HOME"));
	if (f = fopen(buf, "w")) {
		while (x >= 0 && (hist = previous_history())) {
			if (hist->line[0] != '\n')
				fprintf(f, "%s\n", hist->line);
			x--;
		}
	}
	/* get history for saving in config db */
	/*while( x >= 0 && ( hist = previous_history() ) ){
	   AddHistCmd(x, hist->line);
	   x--;
	   } */
	sys_quit();
	env_set_flag(QUIT_NOW);
	/* why is this neceaary ?? */
	disasm_env->flags |= QUIT_NOW;

	return;
}

void cmdHEADER(int argc, char **argv, struct COMMAND *c)
{
	printf("%s\n", target_header());
	return;
}

void cmdSECTION(int argc, char **argv, struct COMMAND *c)
{
	char *tmp, name[32], secStr[128];
	struct section sec;
	struct address addr;
	int cont;

	if (!argc || !argv[0]) {
		sys_msg
		    ("Specify a section name when using 'SECTION'. Names:\n");
		cont = bdb_index_first(SECTION_NAME, &sec);
		while (cont) {
			sprintf(secStr, "%s\trva: %08X\tsize: %8X\n", sec.name,
				sec.rva, sec.size);
			sys_msg(secStr);
			cont = bdb_index_next(SECTION_NAME, &sec);
		}
	} else {
		if (!bdb_index_find(SECTION_NAME, argv[0], &sec))
			return;
		if (!(cont = bdb_index_find(ADDRESS_RVA, &sec.rva, &addr)))
			return;
		while (cont && addr.rva < (sec.rva + sec.size)) {
			addr_print(addr.rva);
			bdb_index_next(ADDRESS_RVA, &addr);
		}
	}
	return;
}

void cmdRANGE(int argc, char **argv, struct COMMAND *c)
{
	long start_rva, end_rva;
	char *s1 = NULL, *s2 = NULL;
	struct address addr;
	int cont, *state;

	if (argc < 2) {
		sys_msg("Specify a starting and ending address!\n");
		return;
	}
	/* get starting and ending address */
	start_rva = strtol(argv[0], NULL, 16);
	end_rva = strtol(argv[1], NULL, 16);
	if ((s1 && s1[0]) || (s2 && s2[0])) {
		sys_msg("Specify starting and ending addresses in hex!\n");
		return;
	}
	/* find closest addr (start_addr) */
	cont = bdb_find_closest_next(ADDRESS_RVA, &start_rva, &addr);

	/* while (addr< end_addr) addr = get_addr_from_db() */
	while (cont && addr.rva <= end_rva) {
		state = db_save_state();
		addr_print(addr.rva);
		db_restore_state(state);
		cont = bdb_index_next(ADDRESS_RVA, &addr);
	}

	return;
}

void cmdBDB(int argc, char **argv, struct COMMAND *c)
{
	if (!argc || !argv[0][0]) {
		sys_msg("Please specify a .bdb file to load!");
		return;
	}
	target_load_bdb(argv[0]);

	return;
}

void cmdINT(int argc, char **argv, struct COMMAND *c)
{
	int cont, block, *state;
	struct function f;
	struct int_code i;
	char buf[256] = {0};
	FILE *oldSTDOUT, *fd = NULL;

	if (argc && argv[0][0]) {
		oldSTDOUT = stdout;
		stdout = fd = fopen(argv[0], "w");
	}
	/* foreach function */
	cont = bdb_index_first(FUNCTION_ID, &f);
	while (cont) {
		state = db_save_state();
		/* print out int_code lines */
		//cont = bdb_index_find( FN_ORDER, &f.id, &i );
		cont = bdb_index_first( FN_ORDER, &i );
		while ( cont  ) {
			if ( f.id == i.func ) {
				if ( intcode_sprint( &i, buf, 256 ) )
					printf("%s\n",buf);
			} 
			cont = bdb_index_next(FN_ORDER, &i);
		}
		printf("\n\n");
		db_restore_state(state);
		cont = bdb_index_next(FUNCTION_ID, &f);
	}
	if (fd) {
		stdout = oldSTDOUT;
		fclose(fd);
	}
	return;
}

void cmdDISASM(int argc, char **argv, struct COMMAND *c)
{
	struct address addr;
	struct section sec;
	int cont, *state;
	FILE *oldSTDOUT, *fd = NULL;

	if (argc && argv[0][0]) {
		oldSTDOUT = stdout;
		stdout = fd = fopen(argv[0], "w");
	}
	cont = bdb_index_first(SECTION_RVA, &sec);
	while (cont) {

		if ((cont = bdb_find_closest_next(ADDRESS_RVA, &sec.rva, &addr))) {
			printf
			    ("Section: %s\tStart Address: %08X\tEnd Address: %08X\n",
			     sec.name, sec.rva, sec.rva + sec.size);
			printf
			    ("--------------------------------------------------------------"
			     "-----------\n");
			while (cont && addr.rva < sec.rva + sec.size) {
				state = db_save_state();
				addr_print(addr.rva);
				db_restore_state(state);
				cont = bdb_index_next(ADDRESS_RVA, &addr);
			}
			printf("\n\n");
		}
		cont = bdb_index_next(SECTION_RVA, &sec);
	}
	if (fd) {
		stdout = oldSTDOUT;
		fclose(fd);
	}
	return;
}

void cmdDUMP(int argc, char **argv, struct COMMAND *cmd)
{
	int x, y;
	unsigned char hex[48 + 4], ascii[16 + 4], c;
	struct DISASM_TGT *target = env_get_target();

	for (x = 0; x < target->info.size; x += y) {
		memset(hex, 0, 52);
		memset(ascii, 0, 20);
		for (y = 0; x + y < target->info.size && y < 16; y++) {
			c = ((char *) target->image)[x + y];
			sprintf(hex, "%s%02X ", hex, c);
			if (isprint(c))
				ascii[y] = c;
			else
				ascii[y] = '.';
		}
		/* pad last line if < 16 bytes */
		if (y < 15)
			for (; y < 16; y++)
				sprintf(hex, "%s   ", hex);
		printf("%08X : %s\t%s\n", x, hex, ascii);
	}
}

void cmdSTRINGS(int argc, char **argv, struct COMMAND *c)
{
	str_print();
	return;
}

void cmdViewDocFile(char *filename)
{
	char cline[PATH_MAX];
	struct DISASM_ENV *disasm_env = env_get_env();
	struct DISASM_PREFS *disasm_prefs = env_get_prefs();

	snprintf(cline, PATH_MAX, "/bin/sh -c \'%s %s/doc/%s\'",
		 disasm_prefs->pager, disasm_env->home, filename);

	system(cline);
	return;
}
void cmdMAN(int argc, char **argv, struct COMMAND *c)
{
	cmdViewDocFile("bastard.txt");
	return;
}
void cmdAPI(int argc, char **argv, struct COMMAND *c)
{
	cmdViewDocFile("API.txt");
	return;
}
void cmdHOWTO(int argc, char **argv, struct COMMAND *c)
{
	cmdViewDocFile("Disasm-HOWTO.txt");
	return;
}


void cmdMACRO(int argc, char **argv, struct COMMAND *c)
{
	/* write a BC script */
	/* maps to API routine */
	struct DISASM_ENV *disasm_env = env_get_env();
	char *line, *script = NULL;
	int cont = 1;

	while (cont) {
		line = (char *) readline(disasm_env->p3);
		if (!istrncmp(line, "ENDMACRO", 8))
			cont = 0;
		else {
			script = realloc(script, strlen(line));
			strcat(script, line);
		}
	}
	if (strlen(script) < 2048) {
		/* macro_new( name, script); */
	} else {
		sys_msg("Macro is too large to save in database.\n"
			"Enter a filename for the macro:");
		/* ** name will be .bdb/macros/$name.sc */
		/* gets, fopen, fwrite, fclose */
		/* id = macro_new( name, script ); */
		/* SetMacroType( id, MACOR_FILE ); */
	}

	return;
}

void cmdENDMACRO(int argc, char **argv, struct COMMAND *c)
{
	sys_msg("ENDMACRO is only valid in the context of a MACRO block!\n");
	return;
}

void cmdRECORD(int argc, char **argv, struct COMMAND *c)
{
	/* record commandline actions ... may be useless */
	/* maps to API routine */
	sys_msg("Not yet implemented\n");
	return;
}

void cmdSTOP(int argc, char **argv, struct COMMAND *c)
{
	sys_msg("Not yet implemented\n");
	return;
}

void cmdRUN(int argc, char **argv, struct COMMAND *c)
{
	/* Run Macro */
	if (argc && argv[0][0])
		script_file_exec(argv[0]);
	return;
}

void cmdBRACE(int argc, char **argv, struct COMMAND *c)
{
	char *line, path[512];
	int x, cont = 1;
	FILE *f;
	struct DISASM_ENV *disasm_env = env_get_env();

	snprintf(path, 512, "%s/.tmp_macro", disasm_env->dbpath);
	f = fopen(path, "w");
	if (!f) {
		sys_print_errmsg(3020);
		return;
	}
	fputs("#include <string.h>\n", f);
	fputs("#include <unistd.h>\n", f);
	fputs("#include <stdlib.h>\n", f);
	fputs("int main(void) {\n", f);
	
	if ( runbatch ) line = calloc( PATH_MAX, 1 );
	if (! line) {
		fclose(f);
		return;
	}
	while (cont) {
		if ( runbatch ) {
			fgets( line, PATH_MAX -1, batch_file);
		} else {
			line = (char *) readline(disasm_env->p3);
		}
		if (!strncmp(line, "}}", 2))
			cont = 0;
		else {
			fprintf(f, "%s\n", line);
		}
		if (line && ! runbatch)
			free(line);
	}
	if (runbatch) free(line);

	fputs("return(0);\n}", f);
	fclose(f);

	sys_exec_script(path, 0, NULL);
	return;
}
