#define IAMNOTEIC
#include <eic.h>
#ifndef PATH_MAX
	#define PATH_MAX 4096
#endif
#include <bastard.h>
#include <vm.h>


/* wrapper functions */
static val_t eic_db_save_state(void)
{
	val_t v;
	v.p.sp = v.p.p = db_save_state();
	v.p.ep = (char *) v.p.p + (sizeof (int));
	/* ret: void * args:  */
	return (v);
}
static val_t eic_db_restore_state(void)
{
	val_t v;
	v.ival = db_restore_state(arg(0, getargs(), void *));
	/* ret: int args: void *state */
	return (v);
}
static val_t eic_bdb_index_first(void)
{
	val_t v;
	v.ival =
	    bdb_index_first(arg(0, getargs(), int), arg(1, getargs(), void *));
	/* ret: int args: int index, void *dest */
	return (v);
}
static val_t eic_bdb_index_next(void)
{
	val_t v;
	v.ival =
	    bdb_index_next(arg(0, getargs(), int), arg(1, getargs(), void *));
	/* ret: int args: int index, void *dest */
	return (v);
}
static val_t eic_bdb_index_prev(void)
{
	val_t v;
	v.ival =
	    bdb_index_prev(arg(0, getargs(), int), arg(1, getargs(), void *));
	/* ret: int args: int index, void *dest */
	return (v);
}
static val_t eic_bdb_index_last(void)
{
	val_t v;
	v.ival =
	    bdb_index_last(arg(0, getargs(), int), arg(1, getargs(), void *));
	/* ret: int args: int index, void *dest */
	return (v);
}
static val_t eic_bdb_index_find(void)
{
	val_t v;
	v.ival =
	    bdb_index_find(arg(0, getargs(), int), arg(1, getargs(), void *),
			  arg(2, getargs(), void *));
	/* ret: int args: int index, void *value, void *dest */
	return (v);
}
static val_t eic_bdb_table_first(void)
{
	val_t v;
	v.ival =
	    bdb_table_first(arg(0, getargs(), int), arg(1, getargs(), void *));
	/* ret: int args: int table, void *dest */
	return (v);
}
static val_t eic_bdb_table_next(void)
{
	val_t v;
	v.ival =
	    bdb_table_next(arg(0, getargs(), int), arg(1, getargs(), void *));
	/* ret: int args: int table, void *dest */
	return (v);
}
static val_t eic_bdb_table_prev(void)
{
	val_t v;
	v.ival =
	    bdb_table_prev(arg(0, getargs(), int), arg(1, getargs(), void *));
	/* ret: int args: int table, void *dest */
	return (v);
}
static val_t eic_bdb_table_last(void)
{
	val_t v;
	v.ival =
	    bdb_table_last(arg(0, getargs(), int), arg(1, getargs(), void *));
	/* ret: int args: int table, void *dest */
	return (v);
}
static val_t eic_bdb_table_count(void)
{
	val_t v;
	v.ival =
	    bdb_table_count(arg(0, getargs(), int));
	return (v);
}
static val_t eic_bdb_record_insert(void)
{
	val_t v;
	v.ival =
	    bdb_record_insert(arg(0, getargs(), int), arg(1, getargs(), void *));
	/* ret: int args: int table, void *src */
	return (v);
}
static val_t eic_bdb_record_update(void)
{
	val_t v;
	v.ival =
	    bdb_record_update(arg(0, getargs(), int), arg(1, getargs(), void *),
			     arg(2, getargs(), void *));
	/* ret: int args: int index, void *value, void *src */
	return (v);
}
static val_t eic_bdb_record_delete(void)
{
	val_t v;
	v.ival =
	    bdb_record_delete(arg(0, getargs(), int), arg(1, getargs(), void *));
	/* ret: int args: int index, void *value */
	return (v);
}
static val_t eic_bdb_find_closest_prev(void)
{
	val_t v;
	v.ival =
	    bdb_find_closest_prev(arg(0, getargs(), int),
				 arg(1, getargs(), void *), arg(2, getargs(),
								void *));
	/* ret: int args: int index, void *value, void *dest */
	return (v);
}
static val_t eic_bdb_find_closest_next(void)
{
	val_t v;
	v.ival =
	    bdb_find_closest_next(arg(0, getargs(), int),
				 arg(1, getargs(), void *), arg(2, getargs(),
								void *));
	/* ret: int args: int index, void *value, void *dest */
	return (v);
}
static val_t eic_GetAddressObject(void)
{
	val_t v;
	v.up = GetAddressObject(arg(0, getargs(), long));
	/* ret: struct address * args: long rva */
	return (v);
}
static val_t eic_GetCodeObject(void)
{
	val_t v;
	v.up = GetCodeObject(arg(0, getargs(), long));
	/* ret: struct code * args: long rva */
	return (v);
}
static val_t eic_GetAddrExpObject(void)
{
	val_t v;
	v.up = GetAddrExpObject(arg(0, getargs(), int));
	/* ret: struct code * args: long rva */
	return (v);
}
static val_t eic_GetCodeEffectObject(void)
{
	val_t v;
	v.up = GetCodeEffectObject(arg(0, getargs(), int));
	/* ret: struct code * args: long rva */
	return (v);
}
static val_t eic_GetSectionObject(void)
{
	val_t v;
	v.up = GetSectionObject(arg(0, getargs(), void *));
	/* ret: struct section * args: char *name */
	return (v);
}
static val_t eic_GetXrefObject(void)
{
	val_t v;
	v.up = GetXrefObject(arg(0, getargs(), int));
	/* ret: struct xref * args: int id */
	return (v);
}
static val_t eic_GetIntCodeObject(void)
{
	val_t v;
	v.up = GetIntCodeObject(arg(0, getargs(), int));
	/* ret: struct int_code * args: int id */
	return (v);
}
static val_t eic_GetFinCodeObject(void)
{
	val_t v;
	v.up = GetFinCodeObject(arg(0, getargs(), int));
	/* ret: struct fin_code * args: int id */
	return (v);
}
static val_t eic_GetExportObject(void)
{
	val_t v;
	v.up = GetExportObject(arg(0, getargs(), long));
	/* ret: struct export * args: long rva */
	return (v);
}
static val_t eic_GetImportObject(void)
{
	val_t v;
	v.up = GetImportObject(arg(0, getargs(), long));
	/* ret: struct import * args: long rva */
	return (v);
}
static val_t eic_GetStringObject(void)
{
	val_t v;
	v.up = GetStringObject(arg(0, getargs(), long));
	/* ret: struct string * args: long rva */
	return (v);
}
static val_t eic_GetNameObject(void)
{
	val_t v;
	v.up = GetNameObject(arg(0, getargs(), long));
	/* ret: struct name * args: long rva */
	return (v);
}
static val_t eic_GetCommentObject(void)
{
	val_t v;
	v.up = GetCommentObject(arg(0, getargs(), int));
	/* ret: struct comment * args: int id */
	return (v);
}
static val_t eic_GetFunctionObject(void)
{
	val_t v;
	v.up = GetFunctionObject(arg(0, getargs(), int));
	/* ret: struct function * args: int id */
	return (v);
}
static val_t eic_GetFuncParamObject(void)
{
	val_t v;
	v.up = GetFuncParamObject(arg(0, getargs(), int));
	/* ret: struct func_param * args: int id */
	return (v);
}
static val_t eic_GetFuncLocalObject(void)
{
	val_t v;
	v.up = GetFuncLocalObject(arg(0, getargs(), int));
	/* ret: struct func_local * args: int id */
	return (v);
}
static val_t eic_GetFuncEffectObject(void)
{
	val_t v;
	v.up = GetFuncEffectObject(arg(0, getargs(), int));
	/* ret: struct code * args: long rva */
	return (v);
}
static val_t eic_GetFInlineObject(void)
{
	val_t v;
	v.up = GetFInlineObject(arg(0, getargs(), int));
	/* ret: struct f_inline * args: int id */
	return (v);
}
static val_t eic_GetStructureObject(void)
{
	val_t v;
	v.up = GetStructureObject(arg(0, getargs(), int));
	/* ret: struct structure * args: int id */
	return (v);
}
static val_t eic_GetStructMemberObject(void)
{
	val_t v;
	v.up = GetStructMemberObject(arg(0, getargs(), int));
	/* ret: struct struct_member * args: int id */
	return (v);
}
static val_t eic_GetDataTypeObject(void)
{
	val_t v;
	v.up = GetDataTypeObject(arg(0, getargs(), int));
	/* ret: struct data_type * args: int id */
	return (v);
}
static val_t eic_GetConstantObject(void)
{
	val_t v;
	v.up = GetConstantObject(arg(0, getargs(), int));
	/* ret: struct constant * args: int id */
	return (v);
}
static val_t eic_GetBCMacroObject(void)
{
	val_t v;
	v.up = GetBCMacroObject(arg(0, getargs(), int));
	/* ret: struct seer_macro * args: int id */
	return (v);
}
static val_t eic_func_gen_args(void)
{
	val_t v;
	v.ival = func_gen_args(arg(0, getargs(), void *));
	return (v);
}
static val_t eic_func_gen_effect(void)
{
	val_t v;
	v.ival = func_gen_effect(arg(0, getargs(), void *));
	return (v);
}
static val_t eic_func_gen_locals(void)
{
	val_t v;
	v.ival = func_gen_locals(arg(0, getargs(), void *));
	return (v);
}
static val_t eic_func_gen_proto(void)
{
	val_t v;
	v.ival = func_gen_proto( arg(0, getargs(), void *),
			arg(1, getargs(), char *), 
			arg(2, getargs(), int) );
	return (v);
}
static val_t eic_target_load(void)
{
	val_t v;
	v.ival = target_load(arg(0, getargs(), void *));
	/* ret: int args:  char *target  */
	return (v);
}
static val_t eic_target_load_bdb(void)
{
	val_t v;
	v.ival = target_load_bdb(arg(0, getargs(), void *));
	/* ret: int args:  char *dbname  */
	return (v);
}
static val_t eic_target_set_format(void)
{
	val_t v;
	v.ival = target_set_format(arg(0, getargs(), void *),
				   arg(1, getargs(), int));
	/* ret: int args:  char *file_format  */
	return (v);
}
static val_t eic_target_apply_format(void)
{
	val_t v;
	v.ival = target_apply_format();
	/* ret: int args:  char *file_format  */
	return (v);
}
static val_t eic_target_set_arch(void)
{
	val_t v;
	v.ival = target_set_arch(arg(0, getargs(), void *),
				 arg(1, getargs(), int));
	/* ret: int args:  char *file_arch  */
	return (v);
}
static val_t eic_target_set_asm(void)
{
	val_t v;
	v.ival = target_set_asm(arg(0, getargs(), void *),
				arg(1, getargs(), int));
	/* ret: int args:  char *asm_output  */
	return (v);
}
static val_t eic_target_set_lang(void)
{
	val_t v;
	v.ival = target_set_lang(arg(0, getargs(), void *),
				 arg(1, getargs(), int));
	/* ret: int args:  char *language  */
	return (v);
}
static val_t eic_target_set_os(void)
{
	val_t v;
	v.ival = target_set_os(arg(0, getargs(), void *),
			       arg(1, getargs(), int));
	/* ret: int args:  char *os  */
	return (v);
}
static val_t eic_target_set_comp(void)
{
	val_t v;
	v.ival = target_set_comp(arg(0, getargs(), void *),
				 arg(1, getargs(), int));
	/* ret: int args:  char *compiler  */
	return (v);
}
static val_t eic_target_set_ext(void)
{
	val_t v;
	v.ival = target_set_ext(arg(0, getargs(), void *),
									arg(1, getargs(), void *),			
									arg(2, getargs(), void *),
									arg(3, getargs(), void *),
									arg(4, getargs(), void *),
									arg(5, getargs(), void *) );
	/* ret: int args:  char *compiler  */
	return (v);
}
static val_t eic_target_output_as(void)
{
	val_t v;
	v.ival = target_output_as(arg(0, getargs(), char *),
					arg(1, getargs(), char *));
	/* ret: int args:  char *plugin  */
	return (v);
}
static val_t eic_plugin_load(void)
{
	val_t v;
	v.ival = plugin_load(arg(0, getargs(), char *));
	/* ret: int args:  char *plugin  */
	return (v);
}
static val_t eic_plugin_exec(void)
{
	val_t v;
	v.ival = plugin_exec(arg(0, getargs(), void *));
	return (v);
}
static val_t eic_plugin_unload(void)
{
	val_t v;
	v.ival = plugin_unload();
	return (v);
}
static val_t eic_target_save_db(void)
{
	val_t v;
	target_save_db();
	/* ret: void args:   */
	return (v);
}
static val_t eic_target_save_bak(void)
{
	val_t v;
	target_save_bak();
	/* ret: void args:   */
	return (v);
}
static val_t eic_target_close_db(void)
{
	val_t v;
	target_close_db();
	/* ret: void args:   */
	return (v);
}
static val_t eic_target_save_db_as(void)
{
	val_t v;
	target_save_db_as(arg(0, getargs(), void *));
	/* ret: void args:  char *filename  */
	return (v);
}
static val_t eic_target_save_asm(void)
{
	val_t v;
	v.ival = target_save_asm(arg(0, getargs(), void *));
	/* ret: int args:  char *filename  */
	return (v);
}
static val_t eic_target_save_hll(void)
{
	val_t v;
	v.ival = target_save_hll(arg(0, getargs(), void *));
	/* ret: int args:  char *filename  */
	return (v);
}
static val_t eic_target_save_lst(void)
{
	val_t v;
	v.ival = target_save_lst(arg(0, getargs(), void *));
	/* ret: int args:  char *filename  */
	return (v);
}
static val_t eic_target_save_hex(void)
{
	val_t v;
	v.ival = target_save_hex(arg(0, getargs(), void *));
	/* ret: int args:  char *filename  */
	return (v);
}
static val_t eic_target_save_diff(void)
{
	val_t v;
	v.ival = target_save_diff(arg(0, getargs(), void *));
	/* ret: int args:  char *filename  */
	return (v);
}
static val_t eic_target_save_binary(void)
{
	val_t v;
	v.ival = target_save_binary(arg(0, getargs(), void *));
	/* ret: int args:  char *filename  */
	return (v);
}
static val_t eic_sec_new(void)
{
	val_t v;
	v.ival = sec_new(arg(0, getargs(), void *),
			 arg(1, getargs(), long),
			 arg(2, getargs(), int),
			 arg(3, getargs(), long), arg(4, getargs(), int));
	/* ret: int args:  char *name, long start, int size, long pa, int type  */
	return (v);
}
static val_t eic_sec_del(void)
{
	val_t v;
	v.ival = sec_del(arg(0, getargs(), void *));
	/* ret: int args:  char *name  */
	return (v);
}
static val_t eic_sec_get(void)
{
	val_t v;
	v.ival = sec_get(arg(0, getargs(), long), arg(1, getargs(), void *));
	/* ret: int args:  long rva, struct section *s */
	return (v);
}
static val_t eic_sec_get_start(void)
{
	val_t v;
	v.lval = sec_get_start(arg(0, getargs(), void *));
	/* ret: long args:  char *name  */
	return (v);
}
static val_t eic_sec_get_end(void)
{
	val_t v;
	v.lval = sec_get_end(arg(0, getargs(), void *));
	/* ret: long args:  char *name  */
	return (v);
}
static val_t eic_sec_get_by_rva(void)
{
	val_t v;
	v.ival = sec_get_by_rva(arg(0, getargs(), long),
				arg(1, getargs(), void *));
	/* ret: int  args:  long rva, char* buf  */
	return (v);
}
static val_t eic_sec_flags(void)
{
	val_t v;
	v.ival = sec_flags(arg(0, getargs(), void *));
	/* ret: int  args:  char *name  */
	return (v);
}
static val_t eic_sec_set_start(void)
{
	val_t v;
	v.ival = sec_set_start(arg(0, getargs(), void *),
			       arg(1, getargs(), long));
	/* ret: int  args:  char *name, long start  */
	return (v);
}
static val_t eic_sec_set_end(void)
{
	val_t v;
	v.ival = sec_set_end(arg(0, getargs(), void *),
			     arg(1, getargs(), long));
	/* ret: int  args:  char *name, long end  */
	return (v);
}
static val_t eic_sec_rename(void)
{
	val_t v;
	v.ival = sec_rename(arg(0, getargs(), void *),
			    arg(1, getargs(), void *));
	/* ret: int  args:  char *name, char *new_name  */
	return (v);
}
static val_t eic_sec_set_flags(void)
{
	val_t v;
	v.ival = sec_set_flags(arg(0, getargs(), void *),
			       arg(1, getargs(), int));
	/* ret: int  args:  char *name, int flags  */
	return (v);
}
static val_t eic_target_set_header(void)
{
	val_t v;
	v.ival = target_set_header(arg(0, getargs(), void *));
	/* ret: int args:  char *header  */
	return (v);
}
static val_t eic_target_header(void)
{
	val_t v;
	v.up = target_header();
	/* ret: void args:   */
	return (v);
}
static val_t eic_disasm_target(void)
{
	val_t v;
	v.ival = disasm_target(arg(0, getargs(), char *),
			       arg(1, getargs(), void *));
	/* ret: int args:  char *name  */
	return (v);
}
static val_t eic_disasm_address(void)
{
	val_t v;
	v.ival = disasm_address(arg(0, getargs(), long),
			       arg(1, getargs(), struct code *),
			       arg(2, getargs(), long));
	return (v);
}
static val_t eic_disasm_section(void)
{
	val_t v;
	v.ival = disasm_section(arg(0, getargs(), void *));
	/* ret: int args:  char *name  */
	return (v);
}
static val_t eic_disasm_range(void)
{
	val_t v;
	v.ival = disasm_range(arg(0, getargs(), long), arg(1, getargs(), int));
	/* ret: int args:  long rva, int size  */
	return (v);
}
static val_t eic_disasm_forward(void)
{
	val_t v;
	v.ival = disasm_forward(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_addr_is_valid(void)
{
	val_t v;
	v.ival = addr_is_valid(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_addr_is_valid_code(void)
{
	val_t v;
	v.ival = addr_is_valid_code(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_addr_exists(void)
{
	val_t v;
	v.ival = addr_exists(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_addr_find_closest(void)
{
	val_t v;
	v.lval = addr_find_closest(arg(0, getargs(), long));
	/* ret: long args:  long rva  */
	return (v);
}
static val_t eic_addr_new(void)
{
	val_t v;
	v.ival = addr_new(arg(0, getargs(), long),
			arg(1, getargs(), int), 
			arg(2, getargs(), long), 
			arg(3, getargs(), int)   );
	/* ret: int args:  long rva, int size, long pa, int flags  */
	return (v);
}
static val_t eic_addr_del(void)
{
	val_t v;
	v.ival = addr_del(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_asmsprintf(void)
{
	val_t v;
	v.ival = asmsprintf(arg(0, getargs(), void *),
			    arg(1, getargs(), void *),
			    arg(2, getargs(), void *));
	/* ret: int args: char *buf, char *format, struct address *addr */
	return (v);
}
static val_t eic_addr_print(void)
{
	val_t v;
	v.ival = addr_print(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_addr_make_code(void)
{
	val_t v;
	v.ival = addr_make_code(arg(0, getargs(), long));
	/* ret: int args:  long addr  */
	return (v);
}
static val_t eic_addr_make_data(void)
{
	val_t v;
	v.ival = addr_make_data(arg(0, getargs(), long));
	/* ret: int args:  long addr  */
	return (v);
}
static val_t eic_addr_pa(void)
{
	val_t v;
	v.lval = addr_pa(arg(0, getargs(), long));
	/* ret: long args:  long rva  */
	return (v);
}
static val_t eic_addr_rva(void)
{
	val_t v;
	v.lval = addr_rva(arg(0, getargs(), long));
	/* ret: long args:  long pa  */
	return (v);
}
static val_t eic_addr_type(void)
{
	val_t v;
	v.ival = addr_type(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_addr_size(void)
{
	val_t v;
	v.ival = addr_size(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_addr_flags(void)
{
	val_t v;
	v.ival = addr_flags(arg(0, getargs(), long));
	/* ret: int args:  long addr  */
	return (v);
}
static val_t eic_addr_bytes(void)
{
	val_t v;
	v.ival = addr_bytes(arg(0, getargs(), long), arg(1, getargs(), void *));
	/* ret: int args:  long rva, char *buf  */
	return (v);
}
static val_t eic_addr_next(void)
{
	val_t v;
	v.lval = addr_next(arg(0, getargs(), long));
	/* ret: long args:  long rva  */
	return (v);
}
static val_t eic_addr_prev(void)
{
	val_t v;
	v.lval = addr_prev(arg(0, getargs(), long));
	/* ret: long args:  long rva  */
	return (v);
}
static val_t eic_addr_set_flags(void)
{
	val_t v;
	v.ival = addr_set_flags(arg(0, getargs(), long),
				arg(1, getargs(), int));
	/* ret: int args:  long rva, int flags  */
	return (v);
}
static val_t eic_name_new(void)
{
	val_t v;
	v.ival = name_new(arg(0, getargs(), long),
			  arg(1, getargs(), void *), arg(2, getargs(), int));
	/* ret: int args:  long rva, char* name, int type  */
	return (v);
}
static val_t eic_name_new_default(void)
{
	val_t v;
	v.ival = name_new_default(arg(0,getargs(),long), arg(1,getargs(),int));
	return (v);
}
static val_t eic_name_get(void)
{
	val_t v;
	v.ival = name_get(arg(0, getargs(), long), arg(1, getargs(), void *));
	/* ret: int args:  long rva, char* buffer  */
	return (v);
}
static val_t eic_name_get_type(void)
{
	val_t v;
	v.ival = name_get_type(arg(0, getargs(), long));
	/* ret: int args: long addr */
	return (v);
}
static val_t eic_addr_get_by_name(void)
{
	val_t v;
	v.lval = addr_get_by_name(arg(0, getargs(), void *));
	/* ret: long args:  char *name  */
	return (v);
}
static val_t eic_addr_add_comment(void)
{
	val_t v;
	v.ival = addr_add_comment(arg(0, getargs(), long),
				  arg(1, getargs(), void *));
	/* ret: int args:  long rva, char *buf  */
	return (v);
}
static val_t eic_addr_comment(void)
{
	val_t v;
	v.ival = addr_comment(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_addr_set_comment(void)
{
	val_t v;
	v.ival = addr_set_comment(arg(0, getargs(), long),
				  arg(1, getargs(), int));
	/* ret: int args:  long rva, int id  */
	return (v);
}
static val_t eic_comment_get(void)
{
	val_t v;
	v.ival = comment_get(arg(0, getargs(), int), arg(1, getargs(), void *));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_comment_new(void)
{
	val_t v;
	v.ival = comment_new(arg(0, getargs(), void *), arg(1, getargs(), int));
	/* ret: int args:  char *buf, int type  */
	return (v);
}
static val_t eic_comment_change(void)
{
	val_t v;
	v.ival = comment_change(arg(0, getargs(), int),
				arg(1, getargs(), void *));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_dtype_new(void)
{
	val_t v;
	v.ival = dtype_new(arg(0, getargs(), char *),
			   arg(1, getargs(), int), arg(2, getargs(), int));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_dtype_del(void)
{
	val_t v;
	v.ival = dtype_del(arg(0, getargs(), char *));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_dtype_get(void)
{
	val_t v;
	v.ival = dtype_get(arg(0, getargs(), char *));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_struct_new(void)
{
	val_t v;
	v.ival = struct_new(arg(0, getargs(), char *),
			    arg(1, getargs(), short));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_struct_add_member(void)
{
	val_t v;
	v.ival = struct_add_member(arg(0, getargs(), int),
				   arg(1, getargs(), long),
				   arg(2, getargs(), int),
				   arg(3, getargs(), int),
				   arg(4, getargs(), char *));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_struct_get(void)
{
	val_t v;
	v.ival = struct_get(arg(0, getargs(), long), arg(1, getargs(), void *));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_struct_get_id(void)
{
	val_t v;
	v.ival = struct_get_id(arg(0, getargs(), char *));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_struct_get_member(void)
{
	val_t v;
	v.ival = struct_get_member(arg(0, getargs(), int),
				   arg(1, getargs(), int),
				   arg(2, getargs(), void *));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_struct_apply(void)
{
	val_t v;
	v.ival = struct_apply(arg(0, getargs(), long),
			      arg(1, getargs(), unsigned long));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_struct_del(void)
{
	val_t v;
	v.ival = struct_del(arg(0, getargs(), int));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_struct_member_del(void)
{
	val_t v;
	v.ival = struct_member_del(arg(0, getargs(), int));
	/* ret: int args:  int id, char *buf  */
	return (v);
}
static val_t eic_addr_constant(void)
{
	val_t v;
	v.ival = addr_constant(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_addr_struct(void)
{
	val_t v;
	v.ival = addr_struct(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_addr_set_constant(void)
{
	val_t v;
	v.ival = addr_set_constant(arg(0, getargs(), long),
				   arg(1, getargs(), int));
	/* ret: int args:  long rva, int id  */
	return (v);
}
static val_t eic_addr_set_struct(void)
{
	val_t v;
	v.ival = addr_set_struct(arg(0, getargs(), long),
				 arg(1, getargs(), int));
	/* ret: int args:  long rva, int id  */
	return (v);
}
static val_t eic_const_new(void)
{
	val_t v;
	v.ival = const_new(arg(0, getargs(), void *), arg(1, getargs(), int),
				arg(2, getargs(), unsigned long));
	/* ret: int args:  char *name, int value */
	return (v);
}
static val_t eic_const_get_by_val(void)
{
	val_t v;
	v.ival = const_get_by_val(arg(0, getargs(), int),
				  arg(1, getargs(), char *), arg(2, getargs(), int));
	/* ret: int args: int value, char buf[32] */
	return (v);
}
static val_t eic_const_get_name(void)
{
	val_t v;
	v.ival = const_get_name(arg(0, getargs(), long),
				arg(1, getargs(), char *), arg(2, getargs(), int));
	/* ret: int args:  unsigned long id, char buf[32] */
	return (v);
}
static val_t eic_const_get_by_name(void)
{
	val_t v;
	v.lval = const_get_by_name(arg(0, getargs(), char *));
	/* ret: unsigned long args:  char *name */
	return (v);
}
static val_t eic_const_del(void)
{
	val_t v;
	v.ival = const_del(arg(0, getargs(), long));
	/* ret: int args:  unsigned long id */
	return (v);
}
static val_t eic_const_apply(void)
{
	val_t v;
	v.ival = const_apply( arg(0, getargs(), long),
								arg(1, getargs(), long) );
	return (v);
}
static val_t eic_code_new(void)
{
	val_t v;
	v.ival = code_new(arg(0, getargs(), long), arg(1, getargs(), void *));
	/* ret: int args: long rva, struct code *c */
	return (v);
}
static val_t eic_code_del(void)
{
	val_t v;
	v.ival = code_del(arg(0, getargs(), long));
	/* ret: int args: long rva */
	return (v);
}
static val_t eic_addr_next_code(void)
{
	val_t v;
	v.lval = addr_next_code(arg(0, getargs(), long));
	/* ret: long args:  long rva  */
	return (v);
}
static val_t eic_addr_next_data(void)
{
	val_t v;
	v.lval = addr_next_data(arg(0, getargs(), long));
	/* ret: long args:  long rva  */
	return (v);
}
static val_t eic_code_opcmp(void)
{
	val_t v;
	v.ival = code_opcmp(arg(0, getargs(), long),
			    arg(1, getargs(), int),
			    arg(2, getargs(), long), arg(3, getargs(), int));
	/* ret: int args:  long rva, char *buf  */
	return (v);
}
static val_t eic_str_get(void)
{
	val_t v;
	v.ival = str_get(arg(0, getargs(), long),
			 arg(1, getargs(), void *), arg(2, getargs(), int));
	/* ret: int args:  long rva, char *buf, int len  */
	return (v);
}
static val_t eic_str_get_raw(void)
{
	val_t v;
	v.ival = str_get_raw(arg(0, getargs(), long),
			     arg(1, getargs(), void *));
	/* ret: int args: long rva, char **buf */
	return (v);
}
static val_t eic_str_new(void)
{
	val_t v;
	v.ival = str_new(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_str_print(void)
{
	val_t v;
	v.ival = str_print();
	/* ret: int args:   */
	return (v);
}
static val_t eic_str_find_in_range(void)
{
	val_t v;
	v.ival = str_find_in_range(arg(0, getargs(), long),
				   arg(1, getargs(), int),
				   arg(2, getargs(), int));
	/* ret: int args: long rva, int size, int type */
	return (v);
}
static val_t eic_imp_new(void)
{
	val_t v;
	v.ival = imp_new(arg(0, getargs(), long),
			 arg(1, getargs(), void *),
			 arg(2, getargs(), void *), arg(3, getargs(), int));
	/* ret: int args:  long rva, char *lib, char* name, int type  */
	return (v);
}
static val_t eic_imp_get_name(void)
{
	val_t v;
	v.ival = imp_get_name(arg(0, getargs(), long),
			      arg(1, getargs(), void *));
	/* ret: int args:  long rva, char *buf  */
	return (v);
}
static val_t eic_imp_get_lib(void)
{
	val_t v;
	v.ival = imp_get_lib(arg(0, getargs(), long),
			     arg(1, getargs(), void *));
	/* ret: int args:  long rva, char *buf  */
	return (v);
}
static val_t eic_imp_type(void)
{
	val_t v;
	v.ival = imp_type(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_imp_print(void)
{
	val_t v;
	v.ival = imp_print();
	/* ret: int args:   */
	return (v);
}
static val_t eic_lib_new(void)
{
	val_t v;
	v.ival = lib_new(arg(0, getargs(), void *),
			 arg(1, getargs(), int), arg(2, getargs(), int));
	/* ret: int args:  char *name, int v_hi, int v_lo  */
	return (v);
}
static val_t eic_lib_print(void)
{
	val_t v;
	v.ival = lib_print();
	/* ret: int args:   */
	return (v);
}
static val_t eic_exp_new(void)
{
	val_t v;
	v.ival = exp_new(arg(0, getargs(), long), arg(1, getargs(), void *));
	/* ret: int args:  long rva, char *name  */
	return (v);
}
static val_t eic_exp_get(void)
{
	val_t v;
	v.ival = exp_get(arg(0, getargs(), void *));
	/* ret: int args:  char *name  */
	return (v);
}
static val_t eic_exp_print(void)
{
	val_t v;
	v.ival = exp_print();
	/* ret: int args:   */
	return (v);
}
static val_t eic_xref_new(void)
{
	val_t v;
	v.ival = xref_new(arg(0, getargs(), long),
			  arg(1, getargs(), long), arg(2, getargs(), int));
	/* ret: int args:  long from, long to, int type  */
	return (v);
}
static val_t eic_func_new(void)
{
	val_t v;
	v.ival = func_new(arg(0, getargs(), long),
			  arg(1, getargs(), void *),
			  arg(2, getargs(), int), arg(3, getargs(), int));
	/* ret: int args:  long rva, char * name, int size  */
	return (v);
}
static val_t eic_func_get_name(void)
{
	val_t v;
	v.ival = func_get_name(arg(0, getargs(), long),
			       arg(1, getargs(), void *));
	/* ret: int args:  long rva, char *buf  */
	return (v);
}
static val_t eic_func_get_start(void)
{
	val_t v;
	v.ival = func_get_start(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_func_get_end(void)
{
	val_t v;
	v.ival = func_get_end(arg(0, getargs(), long));
	/* ret: int args:  long rva  */
	return (v);
}
static val_t eic_func_get_by_name(void)
{
	val_t v;
	v.ival = func_get_by_name(arg(0, getargs(), void *));
	/* ret: int args:  char *name  */
	return (v);
}
static val_t eic_func_set_name(void)
{
	val_t v;
	v.ival = func_set_name(arg(0, getargs(), long),
			       arg(1, getargs(), void *));
	/* ret: int args:  long rva, char *name  */
	return (v);
}
static val_t eic_func_set_size(void)
{
	val_t v;
	v.ival = func_set_size(arg(0, getargs(), long), arg(1, getargs(), int));
	/* ret: int args:  long rva, int size  */
	return (v);
}
static val_t eic_script_file_exec(void)
{
	val_t v;
	v.ival = script_file_exec(arg(0, getargs(), void *));
	/* ret: int args:  char *name  */
	return (v);
}
static val_t eic_script_text_exec(void)
{
	val_t v;
	v.ival = script_text_exec(arg(0, getargs(), void *));
	/* ret: int args:  char *script  */
	return (v);
}
static val_t eic_script_compiled_exec(void)
{
	val_t v;
	v.ival = script_compiled_exec(arg(0, getargs(), void *));
	/* ret: int args: char *name */
	return (v);
}
static val_t eic_script_compile(void)
{
	val_t v;
	v.ival = script_compile(arg(0, getargs(), void *));
	/* ret: int args: char *name */
	return (v);
}
static val_t eic_macro_new(void)
{
	val_t v;
	v.ival = macro_new(arg(0, getargs(), void *),
			   arg(1, getargs(), void *));
	/* ret: int args:  char *name, char *macro  */
	return (v);
}
static val_t eic_macro_del(void)
{
	val_t v;
	v.ival = macro_del(arg(0, getargs(), void *));
	/* ret: int args:  char *name  */
	return (v);
}
static val_t eic_macro_exec(void)
{
	val_t v;
	v.ival = macro_exec(arg(0, getargs(), void *));
	/* ret: int args:  char *name  */
	return (v);
}
static val_t eic_macro_record(void)
{
	val_t v;
	v.ival = macro_record(arg(0, getargs(), void *));
	/* ret: int args:  char *name  */
	return (v);
}
static val_t eic_find_bytes(void)
{
	val_t v;
	v.ival = find_bytes(arg(0, getargs(), void *),
			    arg(1, getargs(), int), arg(2, getargs(), void *));
	/* ret: int args:  unsigned char *bytes, int len, int **search */
	return (v);
}
static val_t eic_find_operand(void)
{
	val_t v;
	v.ival = find_operand(arg(0, getargs(), void *),
			      arg(1, getargs(), void *));
	/* ret: int args:  char *str, int **search */
	return (v);
}
static val_t eic_find_mnemonic(void)
{
	val_t v;
	v.ival = find_mnemonic(arg(0, getargs(), void *),
			       arg(1, getargs(), void *));
	/* ret: int args:  char *str, int **search */
	return (v);
}
static val_t eic_find_constant(void)
{
	val_t v;
	v.ival = find_constant(arg(0, getargs(), long),
			       arg(1, getargs(), void *));
	/* ret: int args:  long value, int **search */
	return (v);
}
static val_t eic_find_free_handle(void)
{
	val_t v;
	v.ival = find_free_handle(arg(0, getargs(), void *));
	/* ret: int args:  int **search  */
	return (v);
}
static val_t eic_find_next_op_r(void)
{
	val_t v;
	v.lval = find_next_op_r(arg(0, getargs(), void *),
				arg(1, getargs(), long),
				arg(2, getargs(), int));
	/* ret: long args:  char *operand, long rva, int ttl  */
	return (v);
}
static val_t eic_find_prev_op_r(void)
{
	val_t v;
	v.lval = find_prev_op_r(arg(0, getargs(), void *),
				arg(1, getargs(), long),
				arg(2, getargs(), int));
	/* ret: long args:  char *operand, long rva, int ttl  */
	return (v);
}
static val_t eic_find_next_op_w(void)
{
	val_t v;
	v.lval = find_next_op_w(arg(0, getargs(), void *),
				arg(1, getargs(), long),
				arg(2, getargs(), int));
	/* ret: long args:  char *operand, long rva, int ttl  */
	return (v);
}
static val_t eic_find_prev_op_w(void)
{
	val_t v;
	v.lval = find_prev_op_w(arg(0, getargs(), void *),
				arg(1, getargs(), long),
				arg(2, getargs(), int));
	/* ret: long args:  char *operand, long rva, int ttl  */
	return (v);
}
static val_t eic_find_next_opsys_x(void)
{
	val_t v;
	v.lval = find_next_opsys_x(arg(0, getargs(), void *),
				   arg(1, getargs(), long),
				   arg(2, getargs(), int));
	/* ret: long args:  char *operand, long rva, int ttl  */
	return (v);
}
static val_t eic_find_prev_opsys_x(void)
{
	val_t v;
	v.lval = find_prev_opsys_x(arg(0, getargs(), void *),
				   arg(1, getargs(), long),
				   arg(2, getargs(), int));
	/* ret: long args:  char *operand, long rva, int ttl  */
	return (v);
}
static val_t eic_env_set_pager(void)
{
	val_t v;
	v.ival = env_set_pager(arg(0, getargs(), void *));
	/* ret: int args: char *name */
	return (v);
}
static val_t eic_env_set_editor(void)
{
	val_t v;
	v.ival = env_set_editor(arg(0, getargs(), void *));
	/* ret: int args: char *name */
	return (v);
}
static val_t eic_env_set_debugger(void)
{
	val_t v;
	v.ival = env_set_debugger(arg(0, getargs(), void *));
	/* ret: int args: char *name */
	return (v);
}
static val_t eic_env_get_flag(void)
{
	val_t v;
	v.ival = env_get_flag(arg(0, getargs(), int));
	/* ret: int args:  int flag  */
	return (v);
}
static val_t eic_env_set_flag(void)
{
	val_t v;
	v.ival = env_set_flag(arg(0, getargs(), int));
	/* ret: int args:  int flag  */
	return (v);
}
static val_t eic_env_clear_flag(void)
{
	val_t v;
	v.ival = env_clear_flag(arg(0, getargs(), int));
	/* ret: int args:  int flag  */
	return (v);
}
static val_t eic_env_tty_asm(void)
{
	val_t v;
	env_tty_asm(arg(0, getargs(), void *));
	/* ret: void args:  char *fmt  */
	return (v);
}
static val_t eic_env_tty_data(void)
{
	val_t v;
	env_tty_data(arg(0, getargs(), void *));
	/* ret: void args:  char *fmt  */
	return (v);
}
static val_t eic_env_file_asm(void)
{
	val_t v;
	env_file_asm(arg(0, getargs(), void *));
	/* ret: void args:  char *fmt  */
	return (v);
}
static val_t eic_env_file_data(void)
{
	val_t v;
	env_file_data(arg(0, getargs(), void *));
	/* ret: void args:  char *fmt  */
	return (v);
}
static val_t eic_env_lpr_asm(void)
{
	val_t v;
	env_lpr_asm(arg(0, getargs(), void *));
	/* ret: void args:  char *fmt  */
	return (v);
}
static val_t eic_env_lpr_data(void)
{
	val_t v;
	env_lpr_data(arg(0, getargs(), void *));
	/* ret: void args:  char *fmt  */
	return (v);
}
static val_t eic_sys_exec(void)
{
	val_t v;
	v.ival = sys_exec(arg(0, getargs(), void *));
	/* ret: int args:  char *args  */
	return (v);
}
static val_t eic_sys_debug(void)
{
	val_t v;
	v.ival = sys_debug();
	/* ret: int args:   */
	return (v);
}
static val_t eic_sys_set_lasterr(void)
{
	val_t v;
	v.ival = sys_set_lasterr(arg(0, getargs(), int));
	/* ret: int args:  int errnum  */
	return (v);
}
static val_t eic_sys_get_lasterr(void)
{
	val_t v;
	v.ival = sys_get_lasterr();
	/* ret: int args:   */
	return (v);
}
static val_t eic_sys_lasterr_str(void)
{
	val_t v;
	v.up = sys_lasterr_str(arg(0, getargs(), void *));
	/* ret: char* args:   */
	return (v);
}
static val_t eic_sys_print_errmsg(void)
{
	val_t v;
	sys_print_errmsg(arg(0, getargs(), int));
	/* ret: void args: int errnum */
	return (v);
}
static val_t eic_sys_sprint_errmsg(void)
{
	val_t v;
	sys_sprint_errmsg(arg(0, getargs(), void *), arg(1, getargs(), int));
	/* ret: void args: char *buf, int errnum */
	return (v);
}



/* oops-es and additions -- i.e. out of order with bastard.h */
static val_t eic_env_clear(void)
{
	val_t v;
	v.ival = env_clear();
	/* ret: int args:  */
	return (v);
}
static val_t eic_env_clear_target(void)
{
	val_t v;
	v.ival = env_clear_target();
	/* ret: int args:  */
	return (v);
}
static val_t eic_comment_del(void)
{
	val_t v;
	v.ival = comment_del(arg(0, getargs(), int));
	/* ret: int args:  int id  */
	return (v);
}

static val_t eic_disasm_find_pat_in_range(void)
{
	val_t v;
	v.lval = disasm_find_pat_in_range(arg(0, getargs(), long),
					  arg(1, getargs(), int),
					  arg(2, getargs(), int));
	return (v);
}

static val_t eic_disasm_find_func_in_range(void)
{
	val_t v;
	v.lval = disasm_find_func_in_range(arg(0, getargs(), long),
					   arg(1, getargs(), int));
	return (v);
}

static val_t eic_disasm_find_func_end(void)
{
	val_t v;
	v.lval = disasm_find_func_end(arg(0, getargs(), long));
	return (v);
}

static val_t eic_disasm_addr_size(void)
{
	val_t v;
	v.ival = disasm_addr_size();
	/* ret: int args:  */
	return (v);
}
static val_t eic_disasm_byte_order(void)
{
	val_t v;
	v.ival = disasm_byte_order();
	/* ret: int args:  */
	return (v);
}
static val_t eic_disasm_byte_size(void)
{
	val_t v;
	v.ival = disasm_byte_size();
	/* ret: int args:  */
	return (v);
}
static val_t eic_disasm_dword_size(void)
{
	val_t v;
	v.ival = disasm_dword_size();
	/* ret: int args:  */
	return (v);
}
static val_t eic_disasm_get_ip(void)
{
	val_t v;
	v.ival = disasm_get_ip();
	/* ret: char* args:  */
	return (v);
}
static val_t eic_disasm_get_sp(void)
{
	val_t v;
	v.ival = disasm_get_sp();
	/* ret: char* args:  */
	return (v);
}
static val_t eic_disasm_word_size(void)
{
	val_t v;
	v.ival = disasm_word_size();
	/* ret: int args:  */
	return (v);
}
static val_t eic_sys_errmsg(void)
{
	val_t v;
	sys_errmsg(arg(0, getargs(), int), arg(1, getargs(), void *));
	/* ret: void args:  int num, const char *str  */
	return (v);
}
static val_t eic_code_sprintf(void)
{
	val_t v;
	v.ival = code_sprintf(arg(0, getargs(), void *),
			     arg(1, getargs(), void *),
			     arg(2, getargs(), long));
	/* ret: int args:  char *buf, char *fmt, long rva  */
	return (v);
}
static val_t eic_code_sprint_op(void)
{
	val_t v;
	v.ival = code_sprint_op( arg(0, getargs(), long), 
					arg(1, getargs(), unsigned int),
					arg(2, getargs(), char *),
					arg(3, getargs(), int)  );

	/* ret: int args:  char *buf, char *fmt, long rva  */
	return (v);
}
static val_t eic_intcode_gen(void)
{
	val_t v;
	v.ival = intcode_gen(arg(0, getargs(), void *),
					arg(1, getargs(), int) );
	return (v);
}
static val_t eic_intcode_sprint(void)
{
	val_t v;
	v.ival = intcode_sprint(arg(0, getargs(), void *),
			     arg(1, getargs(), char *),
			     arg(2, getargs(), int));
	return (v);
}
static val_t eic_intcode_sprintf(void)
{
	val_t v;
	v.ival = intcode_sprintf(arg(0, getargs(), char *),
			     arg(1, getargs(), char *),
			     arg(2, getargs(), void *));
	return (v);
}
static val_t eic_env_get_debugger(void)
{
	val_t v;
	v.up = env_get_debugger();
	/* ret: char * args:  */
	return (v);
}
static val_t eic_env_get_env(void)
{
	val_t v;
	v.up = env_get_env();
	return (v);
}
static val_t eic_env_set_home(void)
{
	val_t v;
	v.ival = env_set_home(arg(0, getargs(), char *));
	/* ret: char * args:  */
	return (v);
}
static val_t eic_env_get_home(void)
{
	val_t v;
	v.up = env_get_home();
	/* ret: char * args:  */
	return (v);
}
static val_t eic_env_get_prefs(void)
{
	val_t v;
	v.up = env_get_prefs();
	/* ret: struct DISASM_PREFS * args:  */
	return (v);
}
static val_t eic_env_get_target(void)
{
	val_t v;
	v.up = env_get_target();
	/* ret: struct DISASM_TGT   * args:  */
	return (v);
}
static val_t eic_env_get_editor(void)
{
	val_t v;
	v.up = env_get_editor();
	/* ret: char * args:  */
	return (v);
}
static val_t eic_xref_from_next(void)
{
	val_t v;
	v.lval = xref_from_next(arg(0, getargs(), int));
	/* ret: long args:  int type  */
	return (v);
}
static val_t eic_xref_to_next(void)
{
	val_t v;
	v.lval = xref_to_next(arg(0, getargs(), int));
	/* ret: long args:  int type  */
	return (v);
}
static val_t eic_env_get_pager(void)
{
	val_t v;
	v.up = env_get_pager();
	/* ret: char * args:  */
	return (v);
}
static val_t eic_xref_from(void)
{
	val_t v;
	v.lval = xref_from(arg(0, getargs(), long), arg(1, getargs(), int));
	/* ret: long args:  long rva, int type  */
	return (v);
}
static val_t eic_xref_to(void)
{
	val_t v;
	v.lval = xref_to(arg(0, getargs(), long), arg(1, getargs(), int));
	/* ret: long args:  long rva, int type  */
	return (v);
}
static val_t eic_target_fd(void)
{
	val_t v;
	v.ival = target_fd();
	/* ret: int args:  */
	return (v);
}
static val_t eic_target_image(void)
{
	val_t v;
	v.up = target_image();
	/* ret: char * args:  */
	return (v);
}
static val_t eic_target_size(void)
{
	val_t v;
	v.ival = target_size();
	/* ret: int args:  */
	return (v);
}
static val_t eic_target_entry(void)
{
	val_t v;
	v.lval = target_entry();
	/* ret: int args:  */
	return (v);
}
static val_t eic_sys_msg(void)
{
	val_t v;
	sys_msg(arg(0, getargs(), void *));
	/* ret: void args:  const char *str  */
	return (v);
}
static val_t eic_sys_quit(void)
{
	val_t v;
	sys_quit();
	/* ret: void args:   */
	return (v);
}
static val_t eic_env_defaults(void)
{
	val_t v;
	v.ival = env_defaults();
	/* ret: int args:  */
	return (v);
}
static val_t eic_env_pref_defaults(void)
{
	val_t v;
	v.ival = env_pref_defaults();
	/* ret: int args:  */
	return (v);
}
static val_t eic_env_target_defaults(void)
{
	val_t v;
	v.ival = env_target_defaults();
	/* ret: int args:  */
	return (v);
}

static val_t eic_vm_add_regtbl_entry(void)
{
	val_t v;
	v.ival = vm_add_regtbl_entry(arg(0, getargs(), int),
				     arg(1, getargs(), char *),
				     arg(2, getargs(), int),
				     arg(3, getargs(), int));
	return (v);
}

static val_t eic_vm_get_reg_name(void)
{
	val_t v;
	v.up = vm_get_reg_name(arg(0, getargs(), int));
	return (v);
}

static val_t eic_vm_get_reg_byname(void)
{
	val_t v;
	v.ival = vm_get_reg_byname(arg(0, getargs(), char *));
	return (v);
}

static val_t eic_vm_get_reg_size(void)
{
	val_t v;
	v.ival = vm_get_reg_size(arg(0, getargs(), int));
	return (v);
}

static val_t eic_vm_get_reg_type(void)
{
	val_t v;
	v.ival = vm_get_reg_type(arg(0, getargs(), int));
	return (v);
}

static val_t eic_vm_get_num_regs(void)
{
	val_t v;
	v.ival = vm_get_num_regs();
	return (v);
}

static val_t eic_vm_do_reg_op(void)
{
	val_t v;
	v.up = vm_do_reg_op(arg(0, getargs(), int),
			    arg(1, getargs(), int), 
			    arg(2, getargs(), void *));
	return (v);
}

static val_t eic_addr_foreach_xref(void)
{
	val_t v;
	v.ival = addr_foreach_xref(arg(0, getargs(), void *),
				   arg(1, getargs(), void *),
				   arg(2, getargs(), void *));
	return (v);
}

static val_t eic_sec_foreach(void)
{
	val_t v;
	v.ival = sec_foreach(arg(0, getargs(), void *),
				  arg(1, getargs(), void *) );
	return (v);
}

static val_t eic_sec_foreach_addr(void)
{
	val_t v;
	v.ival = sec_foreach_addr(arg(0, getargs(), void *),
				  arg(1, getargs(), void *),
				  arg(2, getargs(), void *));
	return (v);
}
static val_t eic_func_foreach_addr(void)
{
	val_t v;
	v.ival = func_foreach_addr(arg(0, getargs(), void *),
				   arg(1, getargs(), void *),
				   arg(2, getargs(), void *));
	return (v);
}

static val_t eic_func_foreach_code(void)
{
	val_t v;
	v.ival = func_foreach_code(arg(0, getargs(), void *),
				   arg(1, getargs(), void *),
				   arg(2, getargs(), void *));
	return (v);
}

static val_t eic_bdb_index_foreach(void)
{
	val_t v;
	v.ival = 0;
	bdb_index_foreach(arg(0, getargs(), int),
			 arg(1, getargs(), void *), arg(2, getargs(), void *));
	return (v);
}
static val_t eic_db_schema_by_name(void)
{
	val_t v;
	v.up = db_schema_by_name( arg(0, getargs(), char *) );
	return (v);
}
static val_t eic_db_table_by_name(void)
{
	val_t v;
	v.up = db_table_by_name( arg(0, getargs(), void *), 
					arg(1, getargs(), char *) );
	return (v);
}
static val_t eic_db_table_by_id(void)
{
	val_t v;
	v.up = db_table_by_id( arg(0, getargs(), void *),
					arg(1, getargs(), int) );
	return (v);
}
static val_t eic_db_index_by_name(void)
{
	val_t v;
	v.up = db_index_by_name( arg(0, getargs(), void *),
					arg(1, getargs(), char *) );
	return (v);
}
static val_t eic_db_index_by_id(void)
{
	val_t v;
	v.up = db_index_by_id( arg(0, getargs(), void *),
					arg(1, getargs(), int) );
	return (v);
}
static val_t eic_db_field_by_name(void)
{
	val_t v;
	v.up = db_field_by_name( arg(0, getargs(), void *),
					arg(1, getargs(), char *));
	return (v);
}
static val_t eic_db_field_by_id(void)
{
	val_t v;
	v.up = db_field_by_id( arg(0, getargs(), void *),
					arg(1, getargs(), int) );
	return (v);
}
static val_t eic_db_field_from_rec(void)
{
	val_t v;
	v.ival = db_field_from_rec( arg(0, getargs(), void *),
					arg(1, getargs(), char *),
					arg(2, getargs(), char *) );
	return (v);
}
static val_t eic_db_set_field_in_rec(void)
{
	val_t v;
	v.ival = db_set_field_in_rec( arg(0, getargs(), void *), 
					arg(1, getargs(), char *),
					arg(2, getargs(), void *) );
	return (v);
}
static val_t eic_db_table_head(void)
{
	val_t v;
	v.ival = db_table_head( arg(0, getargs(), void *),
					arg(1, getargs(), void *) );
	return (v);
}
static val_t eic_db_table_foot(void)
{
	val_t v;
	v.ival = db_table_foot( arg(0, getargs(), void *),
					arg(1, getargs(), void *) );
	return (v);
}
static val_t eic_db_table_min(void)
{
	val_t v;
	v.ival = db_table_min(  arg(0, getargs(), void *),
					arg(1, getargs(), void *),
					arg(2, getargs(), void *) );
	return (v);
}
static val_t eic_db_table_max(void)
{
	val_t v;
	v.ival = db_table_max(  arg(0, getargs(), void *),
					arg(1, getargs(), void *),
					arg(2, getargs(), void *) );
	return (v);
}
static val_t eic_db_field_cmp(void)
{
	val_t v;
	v.ival = db_field_cmp( arg(0, getargs(), void *),
					arg(1, getargs(), void *),
					arg(2, getargs(), void *) );
	return (v);
}
static val_t eic_db_type_sizeof(void)
{
	val_t v;
	v.ival = db_type_sizeof( arg(0, getargs(), int) );
	return (v);
}
static val_t eic_db_valtol(void)
{
	val_t v;
	v.lval = db_valtol( arg(0, getargs(), void *),
					arg(1, getargs(), int) );
	return (v);
}
static val_t eic_db_valtoul(void)
{
	val_t v;
	v.lval = db_valtoul( arg(0, getargs(), void *),
					arg(1, getargs(), int) );
	return (v);
}
static val_t eic_db_sprint_record(void)
{
	val_t v;
	v.ival = db_sprint_record( arg(0, getargs(), char *),
						arg(1, getargs(), int),
						arg(2, getargs(), char),
						arg(3, getargs(), char *),
						arg(4, getargs(), void *) );
	return (v);
}
static val_t eic_db_sprint_field(void)
{
	val_t v;

	v.ival = db_sprint_field( arg(0, getargs(), char *),
						arg(1, getargs(), int),
						arg(2, getargs(), void *),
						arg(3, getargs(), void *) );
	return (v);
}
static val_t eic_db_print_record(void)
{
	val_t v;
	v.ival = db_print_record( arg(0, getargs(), char *),
						arg(1, getargs(), void *) );
	return (v);
}
static val_t eic_db_desc_field(void)
{
	val_t v;
	v.ival = db_desc_field( arg(0, getargs(), void *) );
	return (v);
}
static val_t eic_db_desc_index(void)
{
	val_t v;
	v.ival = db_desc_index( arg(0, getargs(), void *) );
	return (v);
}
static val_t eic_db_desc_table(void)
{
	val_t v;
	v.ival = db_desc_table( arg(0, getargs(), void *) );
	return (v);
}
static val_t eic_db_desc_db(void)
{
	val_t v;
	v.ival = db_desc_db( arg(0, getargs(), void *) );
	return (v);
}
static val_t eic_db_table_dump(void)
{
	val_t v;
	v.ival = db_table_dump(  arg(0, getargs(), int),
					arg(1, getargs(), char),
					arg(2, getargs(), char),
					arg(3, getargs(), void *) );
	return (v);
}

struct EIC_WRAPPER_TBL {
	char *name;
	void *func;
} eic_wrappers[] = {
	{
	"db_save_state", eic_db_save_state}, {
	"db_restore_state", eic_db_restore_state}, {
	/* BDB manipulation routines */
	"bdb_index_first", eic_bdb_index_first}, {
	"bdb_index_next", eic_bdb_index_next}, {
	"bdb_index_prev", eic_bdb_index_prev}, {
	"bdb_index_last", eic_bdb_index_last}, {
	"bdb_index_find", eic_bdb_index_find}, {
	"bdb_table_first", eic_bdb_table_first}, {
	"bdb_table_next", eic_bdb_table_next}, {
	"bdb_table_prev", eic_bdb_table_prev}, {
	"bdb_table_last", eic_bdb_table_last}, {
	"bdb_table_count", eic_bdb_table_count}, {
	"bdb_record_insert", eic_bdb_record_insert}, {
	"bdb_record_update", eic_bdb_record_update}, {
	"bdb_record_delete", eic_bdb_record_delete}, {
	"bdb_find_closest_prev", eic_bdb_find_closest_prev}, {
	"bdb_find_closest_next", eic_bdb_find_closest_next}, {
	"bdb_index_foreach", eic_bdb_index_foreach}, {
	/* obsolete DB functions */
	"GetAddressObject", eic_GetAddressObject}, {
	"GetCodeObject", eic_GetCodeObject}, {
	"GetAddrExpObject", eic_GetAddrExpObject}, {
	"GetCodeEffectObject", eic_GetCodeEffectObject}, {
	"GetSectionObject", eic_GetSectionObject}, {
	"GetXrefObject", eic_GetXrefObject}, {
	"GetIntCodeObject", eic_GetIntCodeObject}, {
	"GetFinCodeObject", eic_GetFinCodeObject}, {
	"GetExportObject", eic_GetExportObject}, {
	"GetImportObject", eic_GetImportObject}, {
	"GetStringObject", eic_GetStringObject}, {
	"GetNameObject", eic_GetNameObject}, {
	"GetCommentObject", eic_GetCommentObject}, {
	"GetFunctionObject", eic_GetFunctionObject}, {
	"GetFuncParamObject", eic_GetFuncParamObject}, {
	"GetFuncLocalObject", eic_GetFuncLocalObject}, {
	"GetFuncEffectObject", eic_GetFuncEffectObject}, {
	"GetFInlineObject", eic_GetFInlineObject}, {
	"GetStructureObject", eic_GetStructureObject}, {
	"GetStructMemberObject", eic_GetStructMemberObject}, {
	"GetDataTypeObject", eic_GetDataTypeObject}, {
	"GetConstantObject", eic_GetConstantObject}, {
	"GetBCMacroObject", eic_GetBCMacroObject}, {
	/* bastard API */
	"target_load", eic_target_load}, {
	"target_load_bdb", eic_target_load_bdb}, {
	"target_set_format", eic_target_set_format}, {
	"target_apply_format", eic_target_apply_format}, {
	"target_set_arch", eic_target_set_arch}, {
	"target_set_asm", eic_target_set_asm}, {
	"target_set_lang", eic_target_set_lang}, {
	"target_set_os", eic_target_set_os}, {
	"target_set_comp", eic_target_set_comp}, {
	"target_set_ext", eic_target_set_ext}, {
	"target_output_as", eic_target_output_as}, {
	"plugin_load", eic_plugin_load}, {
	"plugin_exec", eic_plugin_exec}, {
	"plugin_unload", eic_plugin_unload}, {
	"target_save_db", eic_target_save_db}, {
	"target_save_bak", eic_target_save_bak}, {
	"target_close_db", eic_target_close_db}, {
	"target_save_db_as", eic_target_save_db_as}, {
	"target_save_asm", eic_target_save_asm}, {
	"target_save_hll", eic_target_save_hll}, {
	"target_save_lst", eic_target_save_lst}, {
	"target_save_hex", eic_target_save_hex}, {
	"target_save_diff", eic_target_save_diff}, {
	"target_save_binary", eic_target_save_binary}, {
	"sec_new", eic_sec_new}, {
	"sec_del", eic_sec_del}, {
	"sec_get", eic_sec_get}, {
	"sec_get_start", eic_sec_get_start}, {
	"sec_get_end", eic_sec_get_end}, {
	"sec_get_by_rva", eic_sec_get_by_rva}, {
	"sec_flags", eic_sec_flags}, {
	"sec_set_start", eic_sec_set_start}, {
	"sec_set_end", eic_sec_get_end}, {
	"sec_rename", eic_sec_rename}, {
	"sec_set_flags", eic_sec_set_flags}, {
	"target_set_header", eic_target_set_header}, {
	"target_header", eic_target_header}, {
	"disasm_target", eic_disasm_target}, {
	"disasm_address", eic_disasm_address}, {
	"disasm_section", eic_disasm_section}, {
	"disasm_range", eic_disasm_range}, {
	"disasm_forward", eic_disasm_forward}, {
	"addr_is_valid", eic_addr_is_valid}, {
	"addr_is_valid_code", eic_addr_is_valid_code}, {
	"addr_exists", eic_addr_exists}, {
	"addr_find_closest", eic_addr_find_closest}, {
	"addr_new", eic_addr_new}, {
	"addr_del", eic_addr_del}, {
	"asmsprintf", eic_asmsprintf}, {
	"addr_print", eic_addr_print}, {
	"addr_make_code", eic_addr_make_code}, {
	"addr_make_data", eic_addr_make_data}, {
	"addr_pa", eic_addr_pa}, {
	"addr_rva", eic_addr_rva}, {
	"addr_type", eic_addr_type}, {
	"addr_size", eic_addr_size}, {
	"addr_flags", eic_addr_flags}, {
	"addr_bytes", eic_addr_bytes}, {
	"addr_next", eic_addr_next}, {
	"addr_prev", eic_addr_prev}, {
	"addr_set_flags", eic_addr_set_flags}, {
	"name_new", eic_name_new}, {
	"name_new_default", eic_name_new_default}, {
	"name_get", eic_name_get}, {
	"name_get_type", eic_name_get_type}, {
	"addr_get_by_name", eic_addr_get_by_name}, {
	"addr_add_comment", eic_addr_add_comment}, {
	"addr_comment", eic_addr_comment}, {
	"addr_set_comment", eic_addr_set_comment}, {
	"comment_get", eic_comment_get}, {
	"comment_new", eic_comment_new}, {
	"comment_change", eic_comment_change}, {
	"addr_constant", eic_addr_constant}, {
	"addr_struct", eic_addr_struct}, {
	"addr_set_constant", eic_addr_set_constant}, {
	"addr_set_struct", eic_addr_set_struct}, {
	"dtype_new", eic_dtype_new}, {
	"dtype_del", eic_dtype_del}, {
	"dtype_get", eic_dtype_get}, {
	"struct_new", eic_struct_new}, {
	"struct_add_member", eic_struct_add_member}, {
	"struct_get", eic_struct_get}, {
	"struct_get_id", eic_struct_get_id}, {
	"struct_get_member", eic_struct_get_member}, {
	"struct_apply", eic_struct_apply}, {
	"struct_del", eic_struct_del}, {
	"struct_member_del", eic_struct_member_del}, {
	"const_new", eic_const_new}, {
	"const_get_by_val", eic_const_get_by_val}, {
	"const_get_name", eic_const_get_name}, {
	"const_get_by_name", eic_const_get_by_name}, {
	"const_del", eic_const_del}, {
	"const_apply", eic_const_apply}, {
	"code_new", eic_code_new}, {
	"code_del", eic_code_del}, {
	"addr_next_code", eic_addr_next_code}, {
	"addr_next_data", eic_addr_next_data}, {
	"code_opcmp", eic_code_opcmp}, {
	"str_get", eic_str_get}, {
	"str_get_raw", eic_str_get_raw}, {
	"str_new", eic_str_new}, {
	"str_print", eic_str_print}, {
	"str_find_in_range", eic_str_find_in_range}, {
	"imp_new", eic_imp_new}, {
	"imp_get_name", eic_imp_get_name}, {
	"imp_get_lib", eic_imp_get_lib}, {
	"imp_type", eic_imp_type}, {
	"imp_print", eic_imp_print}, {
	"lib_new", eic_lib_new}, {
	"lib_print", eic_lib_print}, {
	"exp_new", eic_exp_new}, {
	"exp_get", eic_exp_get}, {
	"exp_print", eic_exp_print}, {
	"xref_new", eic_xref_new}, {
	"func_new", eic_func_new}, {
	"func_get_name", eic_func_get_name}, {
	"func_get_start", eic_func_get_start}, {
	"func_get_end", eic_func_get_end}, {
	"func_get_by_name", eic_func_get_by_name}, {
	"func_set_name", eic_func_set_name}, {
	"func_set_size", eic_func_set_size}, {
	"script_file_exec", eic_script_file_exec}, {
	"script_text_exec", eic_script_text_exec}, {
	"script_compiled_exec", eic_script_compiled_exec}, {
	"script_compile", eic_script_compile}, {
	"macro_new", eic_macro_new}, {
	"macro_del", eic_macro_del}, {
	"macro_exec", eic_macro_exec}, {
	"macro_record", eic_macro_record}, {
	"find_bytes", eic_find_bytes}, {
	"find_operand", eic_find_operand}, {
	"find_mnemonic", eic_find_mnemonic}, {
	"find_constant", eic_find_constant}, {
	"find_free_handle", eic_find_free_handle}, {
	"find_next_op_r", eic_find_next_op_r}, {
	"find_prev_op_r", eic_find_prev_op_r}, {
	"find_next_op_w", eic_find_next_op_w}, {
	"find_prev_op_w", eic_find_prev_op_w}, {
	"find_next_opsys_x", eic_find_next_opsys_x}, {
	"find_prev_opsys_x", eic_find_prev_opsys_x}, {
	"env_set_pager", eic_env_set_pager}, {
	"env_set_editor", eic_env_set_editor}, {
	"env_set_debugger", eic_env_set_debugger}, {
	"env_get_flag", eic_env_get_flag}, {
	"env_set_flag", eic_env_set_flag}, {
	"env_clear_flag", eic_env_clear_flag}, {
	"env_tty_asm", eic_env_tty_asm}, {
	"env_tty_data", eic_env_tty_data}, {
	"env_file_asm", eic_env_file_asm}, {
	"env_file_data", eic_env_file_data}, {
	"env_lpr_asm", eic_env_lpr_asm}, {
	"env_lpr_data", eic_env_lpr_data}, {
	"sys_exec", eic_sys_exec}, {
	"sys_debug", eic_sys_debug}, {
	"sys_set_lasterr", eic_sys_set_lasterr}, {
	"sys_get_lasterr", eic_sys_get_lasterr}, {
	"sys_lasterr_str", eic_sys_lasterr_str}, {
	"sys_print_errmsg", eic_sys_print_errmsg}, {
	"sys_sprint_errmsg", eic_sys_sprint_errmsg}, {
	"env_clear_target", eic_env_clear_target}, {
	"comment_del", eic_comment_del}, {
	"disasm_addr_size", eic_disasm_addr_size}, {
	"disasm_find_pat_in_range", eic_disasm_find_pat_in_range}, {
	"disasm_find_func_in_range", eic_disasm_find_func_in_range}, {
	"disasm_find_func_end", eic_disasm_find_func_end}, {
	"disasm_byte_order", eic_disasm_byte_order}, {
	"disasm_byte_size", eic_disasm_byte_size}, {
	"disasm_dword_size", eic_disasm_dword_size}, {
	"disasm_get_ip", eic_disasm_get_ip}, {
	"disasm_get_sp", eic_disasm_get_sp}, {
	"disasm_word_size", eic_disasm_word_size}, {
	"sys_errmsg", eic_sys_errmsg}, {
	"code_sprintf", eic_code_sprintf}, {
	"code_sprint_op", eic_code_sprint_op}, {
	"intcode_gen", eic_intcode_gen}, {
	"intcode_sprint", eic_intcode_sprint}, {
	"intcode_sprintf", eic_intcode_sprintf}, {
	"env_get_debugger", eic_env_get_debugger}, {
	"env_get_env", eic_env_get_env}, {
	"env_set_home", eic_env_set_home}, {
	"env_get_home", eic_env_get_home}, {
	"env_get_prefs", eic_env_get_prefs}, {
	"env_get_target", eic_env_get_target}, {
	"env_get_editor", eic_env_get_editor}, {
	"xref_from_next", eic_xref_from_next}, {
	"xref_to_next", eic_xref_to_next}, {
	"env_get_pager", eic_env_get_pager}, {
	"xref_from", eic_xref_from}, {
	"xref_to", eic_xref_to}, {
	"target_fd", eic_target_fd}, {
	"target_image", eic_target_image}, {
	"target_size", eic_target_size}, {
	"target_entry", eic_target_entry}, {
	"sys_msg", eic_sys_msg}, {
	"sys_quit", eic_sys_quit}, {
	"env_defaults", eic_env_defaults}, {
	"env_pref_defaults", eic_env_pref_defaults}, {
	"env_target_defaults", eic_env_target_defaults}, {
	"vm_add_regtbl_entry", eic_vm_add_regtbl_entry}, {
	"vm_get_reg_name", eic_vm_get_reg_name}, {
	"vm_get_reg_byname", eic_vm_get_reg_byname}, {
	"vm_get_reg_size", eic_vm_get_reg_size}, {
	"vm_get_reg_type", eic_vm_get_reg_type}, {
	"vm_get_num_regs", eic_vm_get_num_regs}, {
	"vm_do_reg_op", eic_vm_do_reg_op}, {
	"addr_foreach_xref", eic_addr_foreach_xref}, {
	"sec_foreach", eic_sec_foreach}, {
	"sec_foreach_addr", eic_sec_foreach_addr}, {
	"func_foreach_addr", eic_func_foreach_addr}, {
	"func_foreach_code", eic_func_foreach_code}, {
	"func_gen_args", eic_func_gen_args}, {
	"func_gen_effect", eic_func_gen_effect}, {
	"func_gen_locals", eic_func_gen_locals}, {
	"func_gen_proto", eic_func_gen_proto}, {
	/* DB abstraction layer */
	"db_schema_by_name", eic_db_schema_by_name}, {
	"db_table_by_name", eic_db_table_by_name}, {
	"db_table_by_id", eic_db_table_by_id}, {
	"db_index_by_name", eic_db_index_by_name}, {
	"db_index_by_id", eic_db_index_by_id}, {
	"db_field_by_name", eic_db_field_by_name}, {
	"db_field_by_id", eic_db_field_by_id}, {
	"db_field_from_rec", eic_db_field_from_rec}, {
	"db_set_field_in_rec", eic_db_set_field_in_rec}, {
	"db_table_head", eic_db_table_head}, {
	"db_table_foot", eic_db_table_foot}, {
	"db_table_min", eic_db_table_min}, {
	"db_table_max", eic_db_table_max}, {
	"db_field_cmp", eic_db_field_cmp}, {
	"db_type_sizeof", eic_db_type_sizeof}, {
	"db_valtol", eic_db_valtol}, {
	"db_valtoul", eic_db_valtoul}, {
	"db_sprint_record", eic_db_sprint_record}, {
	"db_sprint_field", eic_db_sprint_field}, {
	"db_print_record", eic_db_print_record}, {
	"db_desc_field", eic_db_desc_field}, {
	"db_desc_index", eic_db_desc_index}, {
	"db_desc_table", eic_db_desc_table}, {
	"db_desc_db", eic_db_desc_db}, {
	"db_table_dump", eic_db_table_dump}, {
	NULL, NULL}
};


int sys_eicload_api()
{
	int x;

	for (x = 0; eic_wrappers[x].name != NULL; x++) {
		EiC_add_builtinfunc(eic_wrappers[x].name, eic_wrappers[x].func);
	}
	return (x);
}
