struct MZ_HEADER {
	
char id[2];		/* 'MZ' or 'ZM' */
	
 unsigned short last_pg_size;	/* number of bytes in last 512-byte page */
	
 unsigned short num_pages;	/* number of 512-byte pages */
	
 unsigned short num_reloc;	/* number of relocation entries */
	
 unsigned short hdr_size;	/* size of header in 16-byte paragraphs */
	
 unsigned short min_alloc;	/* minimum # of paragraphs alloc'ed */
	
 unsigned short man_alloc;	/* maximum # of paragraphs alloc'ed */
	
 unsigned short start_ss;	/* initial SS */
	
 unsigned short start_sp;	/* initial SP */
	
 unsigned short checksum;
	
 unsigned long cs_ip;	/* offset of initial CS:IP: entry point */
	
 unsigned short reloc_table;	/* offset of relocation table */
	
 unsigned short overlay;	/* overlay number */

 
};


struct MZ_RELOC {
	
unsigned short offset;	/* offset of relocation within segment */
	
 unsigned short segment;	/* segment of relocation */

};


/* Start of Load Module within file: */ 
/* 	MZ_IMAGE_ADDR( struct MZ_HEADER *h )  */ 
#define MZ_IMAGE_ADDR(x) ( x->hdr_size * 16 )
    
/* Size of Load Module: */ 
/*	MZ_IMAGE_SIZE( struct MZ_HEADER *h )  */ 
#define MZ_IMAGE_SIZE(x) ( x->num_pages * 512 - MZ_IMAGE_ADDR(x) - \
    (512 - x->last_pg_size)) 
/* Offset in file of a relocation entry: */ 
/* 	MZ_RELOC_OFFSET( struct MZ_HEADER *h, struct MZ_RELOC *r ) */ 
#define MZ_RELOC_OFFSET(x, y) ( y->segment * 16 + y->offset + MZ_IMAGE_ADDR(x) )
    
/* Startup state of the MZ executable:
	AX		# of chars in command tail, or 0
	BX:CX 	Load Module memory size [32-bit]
	DX		0
	SS:SP		h->SS:h->SP or CS:FFFF
	DS		segment address of MZ header
	ES		same
	CS:IP		program entry point
*/ 
    
/* expansions from ralph brown: offsets are from start of file: */ 
    
struct MZ_NE {		/* new executable */
	
char pad[4];		/* ???? */
	
unsigned short behavior;	/* "behaviour bits */
	
char reserved[26];
	
unsigned long ne_header;	/* offset of NE header */

};

#define IS_MZ_NE( x ) 1 == 2
    
struct MZ_TLINK {
	
char sig[2];		/* 0x0100 */
	
char id;		/* 0xFB */
	
char ver;		/* TLink version, hi nibble = major */
	
char pad[2];

};

#define IS_MZ_TLINK( x ) x->u.tlink.id == 0xFB && x->u.tlink.sig[0] == 0x01
    
struct MZ_ARJ {		/* ARJ compressed */
	
char id[4];		/* 'RJSX' */

};

#define IS_MZ_ARJ( x ) ! strncmp( x->u.arj.id, "RJSX", 4 )
    
struct MZ_LZ {		/* LZEXE compressed */
	
char id[2];		/* 'LZ' */
	
char ver[2];		/* '09' == .90, '91' == .91 */

};

#define IS_MZ_LZ( x ) ! strncmp( x->u.lz.id, "LZ", 2 )
    
struct MZ_PK {		/* PKLITE compressed */
	
char ver_lo;
	
char ver_hi;		/* Bits 0-3 major, 4 extra comp, 5 multi seg */
	
char id[6];		/* 'PKLITE' */

};

#define IS_MZ_PK( x ) ! strncmp( x->u.pk.id, "PKLITE", 6 )
    
struct MZ_LHARC {		/* LHarc compressed */
	
char pad[4];
	
char jmp[3];		/* jump to start of extraction code */
	
char unk[2];
	
char id[12];		/* 'LHarc's SFX ' */

};

#define IS_MZ_LHARC( x ) ! strncmp( x->u.lharc.id, "LHarc's SFX", 11 )
    
struct MZ_LHA {		/* LHA compressed */
	
char pad[8];
	
char id[10];		/* 'LHa's SFX 'or 'LHA's SFX ' */

};

#define IS_MZ_LHA( x ) ! strncmp( x->u.lha.id, "LHa's SFX", 9 ) || \
    !strncmp(x->u.lha.id, "LHA's SFX", 9) 
 
struct MZ_LH {	/* LHA compressed */
	
char pad[8];
	
char id[8];		/* 'LH's SFX' */

};

#define IS_MZ_LH( x ) ! strncmp( x->u.lh.id, "LH's SFX", 8 )
    
struct MZ_PKARC {		/* PKARC compressed */
	
unsigned long sig;	/* 0x00020001 */
	
unsigned short id;	/* 0x0700 */

};

#define IS_MZ_PKARC( x ) x->u.pkarc.sig == 0x20001 && x->u.pkarc.id == 0x700
    
struct MZ_LARC {		/* LARC compressed */
	
char pad[4];
	
char id[11];		/*'SFX by LARC ' */

};

#define IS_MZ_LARC( x )  ! strncmp( x->u.larc.id, "SFX by LARC", 11 )
    
struct MZ_BSA {		/* BSA compressed */
	
char id[3];		/* 0x0F 0x00 0xA7 */

};

#define IS_MZ_BSA( x ) x->u.bsa.id[0] == 0x0F && x->u.bsa.id[1] == 0x00 && \
    x->u.bsa.id[2] == 0xA7 
 
struct MZ_EXPANSION {
	
union {
		
struct MZ_NE ne;
		
struct MZ_TLINK tlink;
		
struct MZ_ARJ arj;
		
struct MZ_LZ lz;
		
struct MZ_PK pk;
		
struct MZ_LHARC lharc;
		
struct MZ_LHA lha;
		
struct MZ_LH lh;
		
struct MZ_PKARC pkarc;
		
struct MZ_LARC larc;
		
struct MZ_BSA bsa;
	
} u;

};


