%{
#include <db/bsql.h>
#include <string.h>

int lineno = 1;
void yyerror(char *s);
%}

%%
[aA][lL][lL]	{ return ALL; }
[aA][nN][dD]	{ return AND; }
{ return AVG; }
{ return MIN; }
{ return MAX; }
{ return SUM; }
{ return COUNT; }
{ return ANY; }
{ return AS; }
{ return BETWEEN; }
{ return BY; }
{ return CLOSE; }
{ return CONTINUE; }
{ return CURRENT; }
{ return CURSOR; }
{ return DECIMAL; }
{ return DECLARE; }
{ return DELETE; }
{ return DESC; }
{ return DISTINCT; }
{ return ESCAPE; }
{ return EXISTS; }
{ return FETCH; }
{ return FOR; }
{ return FOUND; }
{ return FROM; }
{ return HAVING; }
{ return IN; }
{ return INSERT; }
{ return INTO; }
{ return IS; }
{ return LIKE; }
{ return NOT; }
[nN][uU][lL][lL]	{ return NULLX; }
{ return NUMERIC; }
{ return OF; }
{ return ON; }
{ return OPEN; }
{ return OR; }
{ return ORDER; }
{ return REFERENCES; }
{ return SELECT; }
{ return SET; }
{ return SOME; }
{ return TABLE; }
{ return TO; }
{ return UNION; }
{ return UNIQUE; }
{ return UPDATE; }
{ return VALUES; }
{ return VIEW; }
{ return WHERE; }
{ return WITH; }
{ return WORK; }

"=" 	| 
"<>" 	| 
"<" 	| 
">" 	| 
"<=" 	| 
">="						{ return COMPARISON; }
/* != ?? */

[-+*/:(),.;]				{ return yytext[0]; }
[A-Za-z][A-Za-z0-9_]*			{ return NAME; }
/* numbers : hex? oct? bin? */
[0-9]+		|
[0-9]+"."[0-9]+ 	|
"."[0-9]+					{ return INTNUM; }

[0-9]+[eE][+-]?[0-9]+ |
[0-9]+"."[0-9]+[eE][+-]?[0-9]+ |
"."[0-9]+[eE][+-]?[0-9]+		{ return APPROXNUM; }

0[xX][0-9A-Fa-f]+				{ return HEXNUM; }
0[bB][01]+					{ return BINNUM; }
'[^'\n]*'					{ 	int c = input();
							unput(c);
							if ( c != '\"' ) return STRING;
							else yymore();
						}
'[^'\n]*$					{ yyerror("Unterminated string"); }
\n						lineno++;
[ \t\r]					;
"--".*					;	/* SQL comment */
.						yyerror("invalid character");
%%

void yyerror( char *s ) {
	printf( "%d: %s at %s\n", lineno, s, yytext );
}

main( int argc, char **argv ) {
	/* deal with yyin */
	if (! yyparse() ) {
		/* deal with err */
	}
}
