#include "db_bsql.h"


int bsql_vallist_free( struct BSQL_VALLIST *list ) {
	struct BSQL_VALLIST *v;

	while ( list ) {
		v = list;
		list = list->next;
		free( v );
	}
	return(1);
}

struct BSQL_VALREF * bsql_val_getfromarg( struct BSQL_COL *col, 
							struct BSQL_TABLEEXPR_ARG *arg ){
	struct BSQL_VALREF *v;
	struct BSQL_TABLEEXPR_ARG *a;
	int size;

	if (! col || ! arg) return(NULL);
	v = calloc( sizeof(struct BSQL_VALREF), 1);
	if (! v) return(NULL);

	v->size = col->size;
	v->type = col->type;
	size = col->size * db_type_sizeof( col->type );
	a = arg;

	while ( a ) {
		if ( col->table == a->table ) {
			if ( v->size > 0 ) {
				v->ul = *(long *)&a->row[col->offset];
			} else
				memcpy( &v->u.ul, a->row[col->offset], size );
			break;
		}
		a = a->next;
	}

	return(v);
}
