#include <extensions/os.h>

#define SYSCALL_MAX 226

struct FUNC_ID_INFO syscall_table[] = {
	{0, "invalid"}, /* 0 */
	{SYSCALL_EXIT, "exit"}, /* 1 */
	{SYSCALL_FORK, "fork"}, /* 2 */
	{SYSCALL_READ, "read"}, /* 3 */
	{SYSCALL_WRITE, "write"}, /* 4 */
	{SYSCALL_OPEN, "open"}, /* 5 */
	{SYSCALL_CLOSE, "close"}, /* 6 */
	{SYSCALL_WAIT, "waitpid"}, /* 7 */
	{SYSCALL_OPEN, "creat"}, /* 8 */
	{SYSCALL_LINK, "link"}, /* 9 */
	{SYSCALL_UNLINK, "unlink"}, /* 10 */
	{SYSCALL_EXEC, "execve"}, /* 11 */
	{SYSCALL_CHDIR, "chdir"}, /* 12 */
	{SYSCALL_GETTIME, "time"}, /* 13 */
	{SYSCALL_MKNOD, "mknod"}, /* 14 */
	{SYSCALL_CHOWN, "chmod"}, /* 15 */
	{SYSCALL_CHOWN, "lchown"}, /* 16 */
	{SYSCALL_EXIT, "break"}, /* 17 */
	{SYSCALL_STAT, "oldstat"}, /* 18 */
	{SYSCALL_LSEEK, "lseek"}, /* 19 */
	{SYSCALL_GETPID, "getpid"}, /* 20 */
	{SYSCALL_MOUNTFS, "mount"}, /* 21 */
	{SYSCALL_UNMOUNTFS, "umount"}, /* 22 */
	{SYSCALL_SETUID, "setuid"}, /* 23 */
	{SYSCALL_SETGID, "getuid"}, /* 24 */
	{SYSCALL_SETTIME, "stime"}, /* 25 */
	{SYSCALL_PTRACE, "ptrace"}, /* 26 */
	{SYSCALL_ALARM, "alarm"}, /* 27 */
	{SYSCALL_STAT, "oldfstat"}, /* 28 */
	{SYSCALL_WAIT, "pause"}, /* 29 */
	{SYSCALL_FTIME, "utime"}, /* 30 */
	{SYSCALL_TERMINAL, "stty"}, /* 31 */
	{SYSCALL_TERMINAL, "gtty"}, /* 32 */
	{SYSCALL_ACCESS, "access"}, /* 33 */
	{SYSCALL_NICE, "nice"}, /* 34 */
	{SYSCALL_FTIME, "ftime"}, /* 35 */
	{SYSCALL_SYNC, "sync"}, /* 36 */
	{SYSCALL_KILL, "kill"}, /* 37 */
	{SYSCALL_LINK, "rename"}, /* 38 */
	{SYSCALL_MKDIR, "mkdir"}, /* 39 */
	{SYSCALL_RMDIR, "rmdir"}, /* 40 */
	{SYSCALL_DUP, "dup"}, /* 41 */
	{SYSCALL_PIPE, "pipe"}, /* 42 */
	{SYSCALL_PTIMES, "times"}, /* 43 */
	{SYSCALL_PTIMES, "prof"}, /* 44 */
	{SYSCALL_MEMMAP, "brk"}, /* 45 */
	{SYSCALL_SETGID, "setgid"}, /* 46 */
	{SYSCALL_GETGID, "getgid"}, /* 47 */
	{SYSCALL_SIGNAL, "signal"}, /* 48 */
	{SYSCALL_GETUID, "geteuid"}, /* 49 */
	{SYSCALL_GETGID, "getegid"}, /* 50 */
	{SYSCALL_SETLIMIT, "acct"}, /* 51 */
	{SYSCALL_UNMOUNTFS, "umount2"}, /* 52 */
	{SYSCALL_FLOCK, "lock"}, /* 53 */
	{SYSCALL_IOCTL, "ioctl"}, /* 54 */
	{SYSCALL_FCNTL, "fcntl"}, /* 55 */
	{SYSCALL_UNKNOWN, "mpx"}, /* 56 */
	{SYSCALL_SETGID, "setpgid"}, /* 57 */
	{SYSCALL_SETLIMIT, "ulimit"}, /* 58 */
	{SYSCALL_VERSION, "oldolduname"}, /* 59 */
	{SYSCALL_UNKNOWN, "umask"}, /* 60 */
	{SYSCALL_CHROOT, "chroot"}, /* 61 */
	{SYSCALL_STAT, "ustat"}, /* 62 */
	{SYSCALL_DUP, "dup2"}, /* 63 */
	{SYSCALL_GETPID, "getppid"}, /* 64 */
	{SYSCALL_GETPID, "getpgrp"}, /* 65 */
	{SYSCALL_SETSID, "setsid"}, /* 66 */
	{SYSCALL_SIGNAL, "sigaction"}, /* 67 */
	{SYSCALL_SIGMASK, "sgetmask"}, /* 68 */
	{SYSCALL_SIGMASK, "ssetmask"}, /* 69 */
	{SYSCALL_SETUID, "setreuid"}, /* 70 */
	{SYSCALL_SETGID, "setregid"}, /* 71 */
	{SYSCALL_SIGMASK, "sigsuspend"}, /* 72 */
	{SYSCALL_SIGMASK, "sigpending"}, /* 73 */
	{SYSCALL_UNKNOWN, "sethostname"}, /* 74 */
	{SYSCALL_SETLIMIT, "setrlimit"}, /* 75 */
	{SYSCALL_GETLIMIT, "getrlimit"}, /* 76 */	
	{SYSCALL_UNKNOWN, "getrusage"}, /* 77 */
	{SYSCALL_GETTIME, "gettimeofday"}, /* 78 */
	{SYSCALL_SETTIME, "settimeofday"}, /* 79 */
	{SYSCALL_UNKNOWN, "getgroups"}, /* 80 */
	{SYSCALL_UNKNOWN, "setgroups"}, /* 81 */
	{SYSCALL_SELECT, "select"}, /* 82 */
	{SYSCALL_LINK, "symlink"}, /* 83 */
	{SYSCALL_STAT, "oldlstat"}, /* 84 */
	{SYSCALL_OPEN, "readlink"}, /* 85 */
	{SYSCALL_UNKNOWN, "uselib"}, /* 86 */
	{SYSCALL_SWAP, "swapon"}, /* 87 */
	{SYSCALL_REBOOT, "reboot"}, /* 88 */
	{SYSCALL_READDIR, "readdir"}, /* 89 */
	{SYSCALL_MEMMAP, "mmap"}, /* 90 */
	{SYSCALL_MEMUNMAP, "munmap"}, /* 91 */
	{SYSCALL_OPEN, "truncate"}, /* 92 */
	{SYSCALL_OPEN, "ftruncate"}, /* 93 */
	{SYSCALL_CHMOD, "fchmod"}, /* 94 */
	{SYSCALL_CHOWN, "fchown"}, /* 95 */
	{SYSCALL_GETLIMIT, "getpriority"}, /* 96 */
	{SYSCALL_SETLIMIT, "setpriority"}, /* 97 */
	{SYSCALL_UNKNOWN, "profil"}, /* 98 */
	{SYSCALL_UNKNOWN, "statfs"}, /* 99 */
	{SYSCALL_UNKNOWN, "fstatfs"}, /* 100 */
	{SYSCALL_IOPERM, "ioperm"}, /* 101 */
	{SYSCALL_SOCKET, "socketcall"}, /* 102 */
	{SYSCALL_LOG, "syslog"}, /* 103 */
	{SYSCALL_TIMER, "setitimer"}, /* 104 */
	{SYSCALL_TIMER, "getitimer"}, /* 105 */
	{SYSCALL_STAT, "stat"}, /* 106 */
	{SYSCALL_STAT, "lstat"}, /* 107 */
	{SYSCALL_STAT, "fstat"}, /* 108 */
	{SYSCALL_VERSION, "olduname"}, /* 109 */
	{SYSCALL_IOPERM, "iopl"}, /* 110 */
	{SYSCALL_UNKNOWN, "vhangup"}, /* 111 */
	{SYSCALL_IDLE, "idle"}, /* 112 */
	{SYSCALL_UNKNOWN, "vm86old"}, /* 113 */
	{SYSCALL_WAIT, "wait4"}, /* 114 */
	{SYSCALL_SWAP, "swapoff"}, /* 115 */
	{SYSCALL_UNKNOWN, "sysinfo"}, /* 116 */
	{SYSCALL_IPC, "ipc"}, /* 117 */
	{SYSCALL_IOCTL, "fsync"}, /* 118 */
	{SYSCALL_SIGMASK, "sigreturn"}, /* 119 */
	{SYSCALL_FORK, "clone"}, /* 120 */
	{SYSCALL_UNKNOWN, "setdomainname"}, /* 121 */
	{SYSCALL_VERSION, "uname"}, /* 122 */
	{SYSCALL_UNKNOWN, "modify_ldt"}, /* 123 */
	{SYSCALL_UNKNOWN, "adjtimex"}, /* 124 */
	{SYSCALL_MEMPROTECT, "mprotect"}, /* 125 */
	{SYSCALL_SIGMASK, "sigprocmask"}, /* 126 */
	{SYSCALL_LOADMODULE, "create_module"}, /* 127 */
	{SYSCALL_LOADMODULE, "init_module"}, /* 128 */
	{SYSCALL_UNLOADMODULE, "delete_module"}, /* 129 */
	{SYSCALL_UNKNOWN, "get_kernel_syms"}, /* 130 */
	{SYSCALL_SETLIMIT, "quotactl"}, /* 131 */
	{SYSCALL_SETGID, "getpgid"}, /* 132 */
	{SYSCALL_CHDIR, "fchdir"}, /* 133 */
	{SYSCALL_SYNC, "bdflush"}, /* 134 */
	{SYSCALL_UNKNOWN, "sysfs"}, /* 135 */
	{SYSCALL_UNKNOWN, "personality"}, /* 136 */
	{SYSCALL_UNKNOWN, "afs_syscall"}, /* 137 */ 
	{SYSCALL_SETUID, "setfsuid"}, /* 138 */
	{SYSCALL_SETGID, "setfsgid"}, /* 139 */
	{SYSCALL_LSEEK, "_llseek"}, /* 140 */
	{SYSCALL_READDIR, "getdents"}, /* 141 */
	{SYSCALL_SELECT, "_newselect"}, /* 142 */
	{SYSCALL_FLOCK, "flock"}, /* 143 */
	{SYSCALL_MEMSYNC, "msync"}, /* 144 */
	{SYSCALL_READ, "readv"}, /* 145 */
	{SYSCALL_WRITE, "writev"}, /* 146 */
	{SYSCALL_GETSID, "getsid"}, /* 147 */
	{SYSCALL_IOCTL, "fdatasync"}, /* 148 */
	{SYSCALL_UNKNOWN, "_sysctl"}, /* 149 */
	{SYSCALL_MEMLOCK, "mlock"}, /* 150 */
	{SYSCALL_MEMUNLOCK, "munlock"}, /* 151 */
	{SYSCALL_MEMLOCK, "mlockall"}, /* 152 */
	{SYSCALL_MEMUNLOCK, "munlockall"}, /* 153 */
	{SYSCALL_UNKNOWN, "sched_setparam"}, /* 154 */
	{SYSCALL_UNKNOWN, "sched_getparam"}, /* 155 */
	{SYSCALL_UNKNOWN, "sched_setscheduler"}, /* 156 */
	{SYSCALL_UNKNOWN, "sched_getscheduler"}, /* 157 */
	{SYSCALL_SLEEP, "sched_yield"}, /* 158 */
	{SYSCALL_GETLIMIT, "sched_get_priority_max"}, /* 159 */
	{SYSCALL_GETLIMIT, "sched_get_priority_min"}, /* 160 */
	{SYSCALL_UNKNOWN, "sched_rr_get_interval"}, /* 161 */
	{SYSCALL_SLEEP, "nanosleep"}, /* 162 */
	{SYSCALL_MEMMAP, "mremap"}, /* 163 */
	{SYSCALL_SETUID, "setresuid"}, /* 164 */
	{SYSCALL_GETUID, "getresuid"}, /* 165 */
	{SYSCALL_UNKNOWN, "vm86"}, /* 166 */
	{SYSCALL_UNKNOWN, "query_module"}, /* 167 */
	{SYSCALL_POLL, "poll"}, /* 168 */
	{SYSCALL_UNKNOWN, "nfsservctl"}, /* 169 */
	{SYSCALL_SETGID, "setresgid"}, /* 170 */
	{SYSCALL_GETUID, "getresgid"}, /* 171 */
	{SYSCALL_UNKNOWN, "prctl"}, /* 172 */
	{SYSCALL_SIGMASK, "rt_sigreturn"}, /* 173 */
	{SYSCALL_SIGNAL, "rt_sigaction"}, /* 174 */
	{SYSCALL_SIGMASK, "rt_sigprocmask"}, /* 175 */
	{SYSCALL_SIGMASK, "rt_sigpending"}, /* 176 */
	{SYSCALL_SIGMASK, "rt_sigtimedwait"}, /* 177 */
	{SYSCALL_SIGMASK, "rt_sigqueueinfo"}, /* 178 */
	{SYSCALL_SIGMASK, "rt_sigsuspend"}, /* 179 */
	{SYSCALL_READ, "pread"}, /* 180 */
	{SYSCALL_WRITE, "pwrite"}, /* 181 */
	{SYSCALL_CHOWN, "chown"}, /* 182 */
	{SYSCALL_GETCWD, "getcwd"}, /* 183 */
	{SYSCALL_TERMINAL, "capget"}, /* 184 */
	{SYSCALL_TERMINAL, "capset"}, /* 185 */
	{SYSCALL_UNKNOWN, "sigaltstack"}, /* 186 */
	{SYSCALL_UNKNOWN, "sendfile"}, /* 187 */
	{SYSCALL_UNKNOWN, "getpmsg"}, /* 188 */	
	{SYSCALL_UNKNOWN, "putpmsg"}, /* 189 */	
	{SYSCALL_FORK, "vfork"}, /* 190 */
	{SYSCALL_GETLIMIT, "ugetrlimit"}, /* 191 */	
	{SYSCALL_MEMMAP, "mmap2"}, /* 192 */
	{SYSCALL_OPEN, "truncate64"}, /* 193 */
	{SYSCALL_OPEN, "ftruncate64"}, /* 194 */
	{SYSCALL_STAT, "stat64"}, /* 195 */
	{SYSCALL_STAT, "lstat64"}, /* 196 */
	{SYSCALL_STAT, "fstat64"}, /* 197 */
	{SYSCALL_CHOWN, "lchown32"}, /* 198 */
	{SYSCALL_GETUID, "getuid32"}, /* 199 */
	{SYSCALL_GETGID, "getgid32"}, /* 200 */
	{SYSCALL_GETUID, "geteuid32"}, /* 201 */
	{SYSCALL_GETGID, "getegid32"}, /* 202 */
	{SYSCALL_SETUID, "setreuid32"}, /* 203 */
	{SYSCALL_SETGID, "setregid32"}, /* 204 */
	{SYSCALL_UNKNOWN, "getgroups32"}, /* 205 */
	{SYSCALL_UNKNOWN, "setgroups32"}, /* 206 */
	{SYSCALL_CHOWN, "fchown32"}, /* 207 */
	{SYSCALL_SETUID, "setresuid32"}, /* 208 */
	{SYSCALL_GETUID, "getresuid32"}, /* 209 */
	{SYSCALL_SETGID, "setresgid32"}, /* 210 */
	{SYSCALL_GETGID, "getresgid32"}, /* 211 */
	{SYSCALL_CHOWN, "chown32"}, /* 212 */
	{SYSCALL_SETUID, "setuid32"}, /* 213 */
	{SYSCALL_SETGID, "setgid32"}, /* 214 */
	{SYSCALL_SETUID, "setfsuid32"}, /* 215 */
	{SYSCALL_SETGID, "setfsgid32"}, /* 216 */
	{SYSCALL_UNKNOWN, "pivot_root"}, /* 217 */
	{SYSCALL_UNKNOWN, "mincore"}, /* 218 */
	{SYSCALL_UNKNOWN, "madvise"}, /* 219 */
	{SYSCALL_UNKNOWN, "madvise1"}, /* 219 */	
	{SYSCALL_READDIR, "getdents64"}, /* 220 */
	{SYSCALL_FCNTL, "fcntl64"}, /* 221 */
	{SYSCALL_UNKNOWN, "security"}, /* 223 */	
	{SYSCALL_UNKNOWN, "gettid"}, /* 224 */
	{SYSCALL_UNKNOWN, "readahead"}, /* 225 */
	{0xFFFFFFFF, "invalid"}	/* SYSCALL_MAX */
};


