#include <bastard.h>
#include <bdb.h>
#include <extension.h>


int disasm_do_rest_of_code(){
	/* The purpose of this is to try disassembling all addresses in the code section
	 * that disasm_forward may have missed. This is not always the right thing to
	 * do... */
	int cont;
	struct section s;
	struct address a;
	struct code c;

	sys_msg("Disassembling remainder of code section. Sections:\n");
	cont = bdb_index_first( SECTION_RVA, &s);
	while( cont) {
		if ( (s.flags & SECTION_EXECUTE) || (s.flags & SECTION_TYPE_MASK) == SECTION_CODE ) {
			sys_visual("(");
			sys_visual(s.name);
			sys_visual(")");
			sys_visual("|");
			/* foreach address in section */
			cont = bdb_index_find(ADDRESS_RVA, &s.rva, &a);
			while ( cont && a.rva < s.rva + s.size ) {
				sys_visual("\b/");
				bdb_find_closest_next(CODE_RVA, &a.rva, &c );
				sys_visual("\b-");
				if ( c.rva > a.rva + 4) {	/* 4 is an arbitrary gap size :) */
					/* if there is no code record, try to disasm */
					disasm_forward( a.rva );
					//disasm_range( a.rva, c.rva - a.rva );
					sys_visual("\b\\");
				}
				sys_visual("\b|");
				bdb_index_find(ADDRESS_RVA, &a.rva, &a); /* restore state ;) */
				cont = bdb_index_next(ADDRESS_RVA, &a);
			}
			bdb_index_find(SECTION_RVA, &s.rva, &s); /* restore state */
		}
		sys_visual("-");
		cont = bdb_index_next( SECTION_RVA, &s );
	}
	sys_visual("\n");
}

int plugin_main(void *param)
{
	struct DISASM_TGT *target;
	struct function f;
	void *state;
	int cont;

	target = env_get_target();


	/* PREDISASM phase: parse the file header */
	if (target->status < DISASM_TGT_PREDISASM)
		if (!target_apply_format())
			return (sys_set_lasterr(4570));
	target->status = DISASM_TGT_PREDISASM;

	/* DISASM phase */
	/* Start by disassembling all functions recognized by the format parser */
	sys_msg("Disassembling named symbols. Instruction stack:\n");

	cont = bdb_index_first(FUNCTION_RVA, &f);
	while (cont) {
		state = db_save_state();
		disasm_forward(f.rva);
		db_restore_state( state );
		cont = bdb_index_next(FUNCTION_RVA, &f);
	}

	/* Then attack the entry point */
	if (target->info.entry == 0xFFFFFFFF) {
		sys_msg("Invalid entry point 0xFFFFFFFF\n");
		return (0);
	}

	sys_msg("Disassembling forward from entry point. Instruction stack:\n");
	disasm_forward(target->info.entry);

	disasm_do_rest_of_code();
	target->status = DISASM_TGT_DISASM;


	/* POSTDISASM Phase */
	/* create an export and a function for the entry point */
	exp_new(target->info.entry, "_start");
	func_new(target->info.entry, "_start", 1, 0);
	sys_msg("Performing post-disassembly passes\n");
	target->status = DISASM_TGT_POSTDISASM;

	/* OK, done, return to base */
	return (1);
}
