#include <bastard.h>
#include <bdb.h>
#include <extension.h>


/* OUTPUT HEX: Create hex dump of target */
int plugin_main(char *filename)
{
	FILE *dumpFile;
	unsigned int x, y;
	unsigned char hex[48 + 4], ascii[16 + 4], c;
	struct DISASM_TGT *target = env_get_target();

	if (!filename)
		return (sys_set_lasterr(9010));
	dumpFile = fopen(filename, "w");
	if (!dumpFile)
		return (sys_set_lasterr(9030));

	for (x = 0; x < target->info.size; x += y) {
		memset(hex, 0, 52);
		memset(ascii, 0, 20);
		for (y = 0; x + y < target->info.size && y < 16; y++) {
			c = ((char *) target->image)[x + y];
			sprintf(hex, "%s%02X ", hex, c);
			if (isprint(c))
				ascii[y] = c;
			else
				ascii[y] = '.';
		}
		/* pad last line if < 16 bytes */
		if (y < 15)
			for (; y < 16; y++)
				sprintf(hex, "%s   ", hex);

		fprintf(dumpFile, "%08X : %s\t%s\n", x, hex, ascii);
	}
	fclose(dumpFile);
	return (1);
}
