/*
 * sys_initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */
#include <ctype.h>
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <bastard.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "sob_ui.h"
int caught_sig_kill;

//______________________________________________________________user_kill()
void user_kill( int sig) {
   if (! caught_sig_kill ) {
      caught_sig_kill = 1;
      printf("GodDAMNIT! I can't do ANYTHING!\n");
      sys_quit();
      env_set_flag( QUIT_NOW );
   }
   printf("bastard! killed by signal %d\n", sig);
   exit(sig);
}
//______________________________________________________________ReadPrefs()
void ReadPrefs( char* filename ){
   /* to be written :P */
   FILE *f;
   char group[64] = {0}, name[256], buf[256];
   f = fopen(filename, "r");
   /* allow comments  and GROUP.NAME=VALUE lines */
   while ( fscanf(f, "%[# ]%[^\n]\n", name, buf) > 0 ||
         fscanf(f, "%[^.].%[^ =] = %s\n", group, name, buf) > 0){
      if (  group[0] &&
          ! env_set_setting(group, name, buf) &&
          ! env_set_option(name) ){
         printf("Invalid Option %s.%s = %s\n", group, name, buf);
      }
      group[0] = '\0';
   }
   fclose(f);
   return;
}

//___________________________________________________________________main()
int init_bastard(char **argv){
   struct DISASM_ENV *disasm_env;
   struct DISASM_PREFS *disasm_prefs;
   struct DISASM_TGT *target;

   /* set up rudimentary exception handling :P */
   caught_sig_kill = 0;

   /* prepare bastard-settings structure pointers */
   disasm_env = env_get_env();
   disasm_prefs = env_get_prefs();
   target = env_get_target();
   
	if (! sys_find_home(disasm_env->home, PATH_MAX, argv)) {
		printf("Error in bastard setup: cannot find $BASTARD_HOME!\n"
				 "\tForcing to /usr/local/bastard...\n");
		strcpy((char *)disasm_env->home, "/usr/local/bastard");
	}
   /* + Set some non-vital defaults */
   sys_init(disasm_env->home); /* set defaults, start DB && interpreter */
   env_set_option( "NO_VISUALS" );

   /* + Apply settings in RC scripts */
   /*if ( ! stat("/etc/bastard.rc", &tmpStat)) ReadPrefs("/etc/bastard.rc");
   sprintf(tmpBuf, "%s/.bastard/bastard.rc", getenv("HOME"));
   if ( ! stat(tmpBuf, &tmpStat)) ReadPrefs(tmpBuf);*/

   /* + Trap User Signals */
   signal( SIGKILL, user_kill);
   signal( SIGABRT, user_kill);
   signal( SIGINT, user_kill);
   signal( SIGTERM, user_kill);
   signal( SIGSEGV, user_kill);
   signal( SIGPIPE, SIG_IGN);

   return(0);
}

int
main (int argc, char *argv[])
{
  GtkWidget *sob_main_win;

  /* 1. init the bastard */
  init_bastard(argv);

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

  /*
   * Create all windows
   */
  	sob_main_win = create_sob_main_win();
	asm_win_popup = create_asm_win_popup();
	select_font_dlg = create_SelectFontDialog ();
	db_query_dlg = create_db_query_dlg ();
	settings_dlg = create_SettingsDlg ();
	color_dlg = create_ColorDlg ();
	saveas_dlg = create_SaveFileAsDlg ();
	mbox_dlg = create_mbox_dlg ();
	find_dlg = create_find_window ();
	mod_addr_dlg = create_modify_addr_win ();
	mod_inst_dlg = create_modify_inst_win ();
	tgt_dtype_val_dlg = create_data_types_values_win ();
	mod_int_dlg = create_mod_int_win ();
	mod_func_dlg = create_mod_func_win ();
	mod_struct_dlg = create_mod_struct_win ();
	new_dtype_dlg = create_new_dtype_win ();
	new_const_dlg = create_new_const_win ();
	tgt_struct_dlg = create_mod_sec_win ();
	tgt_struct_dlg = create_tgt_struct_win ();
	load_file_dlg.self = create_LoadFileDlg(); 
	
	init_ui_main(sob_main_win);
  	gtk_widget_show(sob_main_win);
	gtk_main();	

  return 0;
}


