#include <stdio.h>
#include <stdlib.h>
#include <bastard.h>
#include <bdb.h>

#include "sob_asm_win.h"
#include "sob_ui.h"
#include "sob_ui_prefs.h"
#include "support.h"


struct DISPLAY asm_display = { "AsmView", "AsmHScroll", "AsmVScroll", 
								cb_hscroll_asmwin, cb_vscroll_asmwin,
								ADDRESS_RVA, asm_display_addline, 
								asm_display_fill, asm_display_total,
								0		};
								
int asm_display_total( struct DISPLAY *d ){
	int size;
		
	size = bdb_table_count(ADDRESS_RVA) * 2;
	
	size += bdb_table_count( XREF ) * 2;	/* 2 lines per xref */
	size += bdb_table_count( CODE );
	size += bdb_table_count(FUNCTION);	/* one line per function */
	size += bdb_table_count(NAME);		/* one line per name */
	size += bdb_table_count(COMMENT);	/* one line per comment */
	size += bdb_table_count(SECTION);	/* one line per section */
	
	d->db_total = size; 
	return(size);
}
		

void asm_display_fill(struct DISPLAY *d, GtkText *t, struct DISP_LINE *line){
	/* print one line to text widget */
	struct ASMCODE_LINE *code;
	struct ASMXREF_LINE *xref;
	struct ASMDATA_LINE *data;
	struct ASMFUNC_LINE *func;
	struct ASMLABL_LINE *label;
	struct ASMCMNT_LINE *cmt;
	struct ASMSTR_LINE *str;
	struct ASMSEC_LINE *sec;
	int pos;
	char addr[] = "        ";
	GdkFont *a_font;
	GdkColor *fg, *bg;
	
	pos = gtk_text_get_point(t);
 
	/* first, print addr */
	if ( line->addr ) {
		disp_fill_to_pos( t, pos, line->addr_pos );
		sprintf(addr, "%08X", (unsigned long) line->addr );
	}
	gtk_text_insert( t, line->addr_font.font, line->addr_font.fgcolor, 
					line->addr_font.bgcolor, addr, -1 ); 	
	
	/* now deal with rest of line */
	switch ( line->type ) {
		case ASMCODE:
			code = &line->u.code;
		
			disp_fill_to_pos( t, pos, code->hex_pos );
			gtk_text_insert( t, CODE_FONT(hex_font), CODE_COLOR(hex_fg), 
							CODE_COLOR(hex_bg), code->hex, -1 );  
		
			disp_fill_to_pos( t, pos, code->mnem_pos );
			gtk_text_insert( t, CODE_FONT(mnem_font), CODE_COLOR(mnem_fg), 
							CODE_COLOR(mnem_bg), code->mnem, -1 );
			disp_fill_to_pos( t, pos, code->dest_pos );
			gtk_text_insert( t, code->dest_font.font, code->dest_font.fgcolor, 
							code->dest_font.bgcolor, code->dest, -1 );  
			if ( code->src_pos ) {
				gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), ", ", 2 );
				disp_fill_to_pos( t, pos, code->src_pos );
				gtk_text_insert( t, code->src_font.font, code->src_font.fgcolor, 
								code->src_font.bgcolor, code->src, -1 );
			}
			if ( code->aux_pos ) {
				gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), ", ", 2 );
				disp_fill_to_pos( t, pos, code->aux_pos );
				gtk_text_insert( t, code->aux_font.font, code->aux_font.fgcolor, 
								code->aux_font.bgcolor, code->aux, -1 );
			}
			break;
		
		case ASMDATA:
			data = &line->u.data;
			disp_fill_to_pos( t, pos, data->hex_pos );
			gtk_text_insert( t, DATA_FONT(d_hex_font), DATA_COLOR(d_hex_fg), 
							DATA_COLOR(d_hex_bg), data->hex, -1 );  
			disp_fill_to_pos( t, pos, data->ascii_pos );
			gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), " ", 1 );	
			gtk_text_insert( t, DATA_FONT(ascii_font), DATA_COLOR(ascii_fg), 
							DATA_COLOR(ascii_bg), data->ascii, -1 );
			break;
		
		case ASMFUNCTION:
			func = &line->u.func;
			disp_fill_to_pos( t, pos, func->pos );
			gtk_text_insert( t, NAME_FONT(n_sub_font), NAME_COLOR(n_sub_fg), 
							NAME_COLOR(n_sub_bg), func->desc, -1 ); 
			break;
		case ASMLABEL:
			label = &line->u.label;
			disp_fill_to_pos( t, pos, label->pos );
			gtk_text_insert( t, label->font.font, label->font.fgcolor, 
							label->font.bgcolor, label->name, -1 );
			gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), ":", 1 );		
			break;
		case ASMCOMMENT:			
			cmt = &line->u.cmt;
			disp_fill_to_pos( t, pos, cmt->pos );
			gtk_text_insert( t, cmt->font.font, cmt->font.fgcolor, 
							cmt->font.bgcolor, "; ", 2 );
			gtk_text_insert( t, cmt->font.font, cmt->font.fgcolor, 
							cmt->font.bgcolor, cmt->cmt, -1 ); 
			break;
		case ASMSECTION:
			sec = &line->u.sec;
			disp_fill_to_pos( t, pos, sec->pos );
			gtk_text_insert( t, NAME_FONT(n_sec_font), NAME_COLOR(n_sec_fg), 
							NAME_COLOR(n_sec_bg), sec->desc, -1 ); 
			break;
		case ASMSTRING:
			str = &line->u.str;
			disp_fill_to_pos( t, pos, str->pos );
			gtk_text_insert( t, DATA_FONT(string_font), DATA_COLOR(string_fg), 
							DATA_COLOR(string_bg), "\"", 1 ); 
			gtk_text_insert( t, DATA_FONT(string_font), DATA_COLOR(string_fg), 
							DATA_COLOR(string_bg), str->str, -1 ); 
			gtk_text_insert( t, DATA_FONT(string_font), DATA_COLOR(string_fg), 
							DATA_COLOR(string_bg), "\"", 1 ); 
			break;
		case ASMXREF:
			xref = &line->u.xref;
			disp_fill_to_pos( t, pos, xref->pos );
			gtk_text_insert( t, xref->font.font, xref->font.fgcolor, 
							xref->font.bgcolor, "; ", 2 );  
			gtk_text_insert( t, xref->font.font, xref->font.fgcolor, 
							xref->font.bgcolor, xref->text, -1 );  
			gtk_text_insert( t, xref->font.font, xref->font.fgcolor, 
							xref->font.bgcolor, xref->addr, -1 ); 
			break;
		case DISPLINE_EMPTY:
		default:
			//gtk_text_insert( t, NULL, NULL,NULL," ", -1);		
			break;
	}
	gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), "\n", -1 );
	return;
}

int asm_addlabelline( struct DISP_LINE *line, struct address *a, struct name *n ){
	struct ASMLABL_LINE *label;
	
	if (! line) return(0);
	label = &line->u.label;
	memset( label, 0, sizeof( struct ASMLABL_LINE ) );
		
	line->type = ASMLABEL;
	line->addr = a->rva;
	line->addr_pos = CODE_POS(addr_pos);
	
	line->addr_font.font = CODE_FONT(addr_font);
	line->addr_font.fgcolor = CODE_COLOR(addr_fg);
	line->addr_font.bgcolor = CODE_COLOR(addr_bg);
	
	if ( a->flags & ADDR_IMPORT ) {
		label->font.font = NAME_FONT(n_import_font);
		label->font.fgcolor = NAME_COLOR(n_import_fg);
		label->font.bgcolor = NAME_COLOR(n_import_bg);
	} else if ( a->flags & ADDR_EXPORT ) {
		label->font.font = NAME_FONT(n_export_font);
		label->font.fgcolor = NAME_COLOR(n_export_fg);
		label->font.bgcolor = NAME_COLOR(n_export_bg);
	} else if ( a->flags & ADDR_FUNCTION || n->type & NAME_SUB ) {
		label->font.font = NAME_FONT(n_sub_font);
		label->font.fgcolor = NAME_COLOR(n_sub_fg);
		label->font.bgcolor = NAME_COLOR(n_sub_bg);
	} else if ( a->flags & ADDR_SYMBOL || n->type & NAME_SYMBOL ) {
		label->font.font = NAME_FONT(n_symbol_font);
		label->font.fgcolor = NAME_COLOR(n_symbol_fg);
		label->font.bgcolor = NAME_COLOR(n_symbol_bg);
	/*} else if ( a->flags & ADDR_CODE ) {
		label->font.font = CODE_FONT(addr_font);
		label->font.fgcolor = CODE_COLOR(addr_fg);
		label->font.bgcolor = SOB_COLOR(f_bgcolor);
	} else if ( a->flags & ADDR_STRING ) {
		label->font.font = DATA_FONT(string_font);
		label->font.fgcolor = DATA_COLOR(string_fg);
		label->font.bgcolor = DATA_COLOR(string_bg);
	} else if ( a->flags & ADDR_SECTION ) {
		label->font.font = NAME_FONT(n_sec_font);
		label->font.fgcolor = NAME_COLOR(n_sec_fg);
		label->font.bgcolor = NAME_COLOR(n_sec_bg);*/
	} else if ( n->type & NAME_USER ){
		label->font.font = NAME_FONT(n_user_font);
		label->font.fgcolor = NAME_COLOR(n_user_fg);
		label->font.bgcolor = NAME_COLOR(n_user_bg);
	} else {
		label->font.font = NAME_FONT(n_auto_font);
		label->font.fgcolor = NAME_COLOR(n_auto_fg);
		label->font.bgcolor = NAME_COLOR(n_auto_bg);
	}
	
	label->pos = line->addr_pos + 10;
	strncpy( label->name, n->text, 63 );
	return(1);
}

int asm_addfuncline( struct DISP_LINE *line, struct address *a, struct function *f ){
	struct ASMFUNC_LINE *func;
	struct name n = {0};
		
	if (! line) return(0);
	func = &line->u.func;
	memset( func, 0, sizeof( struct ASMFUNC_LINE ) );
		
	line->type = ASMFUNCTION;
	line->addr = a->rva;	
	line->addr_pos = CODE_POS(addr_pos);
	
	line->addr_font.font = NAME_FONT(n_sub_font);
	line->addr_font.fgcolor = NAME_COLOR(n_sub_fg);
	line->addr_font.bgcolor = CODE_COLOR(addr_bg);
	
	if ( bdb_index_find( NAME_RVA, &f->rva, &n) )
		snprintf( func->desc, 127, "%s -- FUNCTION 0x%X bytes", n.text, f->size );
	
	func->pos = line->addr_pos + 10;
	return(1);
}

int asm_addsecline( struct DISP_LINE *line, struct address *a, struct section *s){
	struct ASMSEC_LINE *sec;
	char type[6] = {0};
		
	if (! line) return(0);
	sec = &line->u.sec;
	memset( sec, 0, sizeof( struct ASMSEC_LINE ) );
		
	line->type = ASMSECTION;
	line->addr = a->rva;	
	line->addr_pos = CODE_POS(addr_pos);
	
	line->addr_font.font = NAME_FONT(n_sec_font);
	line->addr_font.fgcolor = NAME_COLOR(n_sec_fg);
	line->addr_font.bgcolor = CODE_COLOR(addr_bg);
	type[0] = '(';
	type[1] = ( s->flags & SECTION_READ ) ? 'r' : '-';
	type[2] = ( s->flags & SECTION_WRITE ) ? 'w' : '-';
	type[3] = ( s->flags & SECTION_EXECUTE ) ? 'x' : '-';
	type[4] = ')';
	
	snprintf( sec->desc, 127, "%s -- SECTION %s 0x%X bytes", s->name, type, s->size );
	sec->pos = line->addr_pos + 10;
	return(1);
}

int asm_addstrline( struct DISP_LINE *line, struct address *a, struct string *s){
	struct ASMSTR_LINE *str;
		
	if (! line) return(0);
	str = &line->u.str;
	memset( str, 0, sizeof( struct ASMSTR_LINE ) );
	
	line->type = ASMSTRING;
	line->addr = a->rva;	
	line->addr_pos = CODE_POS(addr_pos);
	
	line->addr_font.font = DATA_FONT(string_font);
	line->addr_font.fgcolor = DATA_COLOR(string_fg);
	line->addr_font.bgcolor = CODE_COLOR(addr_bg);
	
	str->pos = DATA_POS(string_pos);
	strncpy(str->str, s->text, 255);
	
	return(1);
}

int asm_op_font(int type,  struct FONT_PREF *font) {
		
	switch (type & OP_TYPE_MASK) {
		case OP_REG:
			font->font = CODE_FONT(reg_font);
			font->fgcolor = CODE_COLOR(reg_fg);
			font->bgcolor = CODE_COLOR(reg_bg);
			break;
		case OP_ADDR:
		case OP_PTR:
		case OP_OFF:
			font->font = CODE_FONT(mem_font);
			font->fgcolor = CODE_COLOR(mem_fg);
			font->bgcolor = CODE_COLOR(mem_bg);
			break;
		case OP_EXPR:
			font->font = CODE_FONT(expr_font);
			font->fgcolor = CODE_COLOR(expr_fg);
			font->bgcolor = CODE_COLOR(expr_bg);
			break;
		case OP_REL:
		case OP_IMM:
		default:
			font->font = CODE_FONT(imm_font);
			font->fgcolor = CODE_COLOR(imm_fg);
			font->bgcolor = CODE_COLOR(imm_bg);
	}
	return( 1 );
}
		
int asm_addcodeline( struct DISP_LINE *line, struct address *a, struct code *c ){
	int mark = 6;
	char hbuf[4] = {0};
	int x;
	struct ASMCODE_LINE *code;
	struct DISASM_TGT *target = env_get_target();
		
	if (! line) return(0);
	code = &line->u.code;
	memset( code, 0, sizeof( struct ASMCODE_LINE ) );
	line->type = ASMCODE;
	line->addr = c->rva;
	
	/* set up user-defined positions and fonts */
	line->addr_pos = CODE_POS(addr_pos);
	line->addr_font.font = CODE_FONT(addr_font);
	line->addr_font.fgcolor = CODE_COLOR(addr_fg);
	line->addr_font.bgcolor = CODE_COLOR(addr_bg);
	code->hex_pos = CODE_POS(hex_pos);
	code->mnem_pos = CODE_POS(mnem_pos);
	code->dest_pos = CODE_POS(op_pos);
	
	/* set up context-dependent positions/fonts */
	if ( c->destType ) {
		asm_op_font( c->destType, &code->dest_font );
		code_sprint_op( c->dest, c->destType, code->dest, 31 );
		if ( c->srcType ) {
			code->src_pos = code->dest_pos + strlen(code->dest) + 2;
			asm_op_font( c->srcType, &code->src_font );
			code_sprint_op( c->src, c->srcType, code->src, 31 );
			if ( c->auxType ) {
				code->aux_pos = code->src_pos + strlen(code->src) + 2;
				asm_op_font( c->auxType, &code->aux_font );
				code_sprint_op( c->aux, c->auxType, code->aux, 23);
			}
		}
	}
	
	/* copy the code stuff */
	strncpy( code->mnem, c->mnemonic, 15 );
	for ( x = 0; x < CODE_POS(hex_num); x++ ) {
		if ( x < a->size && (a->pa + x) < target->info.size ) {
			sprintf( hbuf, " %02X", (unsigned char) target->image[a->pa + x]);
			strncat( code->hex, hbuf, 64 - strlen(code->hex) );
		} else {
			strncat( code->hex, "   ", 64 - strlen(code->hex) );
		}
	}
	
	return(1);
}

int asm_adddataline( struct DISP_LINE *line, struct address *a ){
	struct ASMDATA_LINE *data;
	struct DISASM_TGT *target = env_get_target();
	char hbuf[4] = {0}, abuf[2] = {0};
	unsigned char x, c;
		
	if (! line) return(0);
	data = &line->u.data;
	memset( data, 0, sizeof( struct ASMDATA_LINE ) );
	line->type = ASMDATA;
	line->addr = a->rva;
	line->addr_pos = DATA_POS(d_addr_pos);
	line->addr_font.font = DATA_FONT(d_addr_font);
	line->addr_font.fgcolor = DATA_COLOR(d_addr_fg);
	line->addr_font.bgcolor = DATA_COLOR(d_addr_bg);
	
	/* set up user-defined positions and fonts */
	data->addr_pos = DATA_POS(d_addr_pos);
	memset( data->hex, 0, 96 );
	memset( data->ascii, 0, 32 );
	for ( x = 0; x < 16; x++ ) {
		/* add a hex and ascii char for this byte */
		if ( x < a->size && (a->pa + x) < target->info.size ) {
			c = (unsigned char) target->image[a->pa + x];
			sprintf( hbuf, " %02X", c);
			strcat( data->hex, hbuf );
			if ( isprint( c ) ) 
				abuf[0] = c;
			else 
				abuf[0] = '.';
			strcat( data->ascii, abuf ); 
		} else {
			strcat( data->hex, "   " );
			strcat( data->ascii, " " );
		}
	}
		
	return(1);
}

int asm_addfxrefline( struct DISP_LINE *line, struct address *a, struct xref *x ){
	struct ASMXREF_LINE *xref;
	struct name n;
	char type[6] = {0};
		
	if (! line) return(0);
	line->type = ASMXREF;
	line->addr = x->from_rva;
	line->addr_pos = CODE_POS(addr_pos);
	
	xref = &line->u.xref;
	memset( xref, 0, sizeof( struct ASMXREF_LINE ) );

	xref->pos = XREF_POS(xref_pos);
	xref->font.font = XREF_FONT(xref_from_font);
	xref->font.fgcolor = XREF_COLOR(xref_from_fg);
	xref->font.bgcolor = XREF_COLOR(xref_from_bg);

	type[0] = '(';
	type[1] = ( x->type & XREF_READ ) ? 'r' : '-';
	type[2] = ( x->type & XREF_WRITE ) ? 'w' : '-';
	type[3] = ( x->type & XREF_EXEC ) ? 'x' : '-';
	type[4] = ')';

	sprintf( xref->text, "Cross reference %s to ", type );
	if ( bdb_index_find( NAME_RVA, &x->to_rva, &n) ) 
		strncpy( xref->addr, n.text, 63 );
	else
		sprintf( xref->addr, "%08X", x->to_rva );
	
	line->addr_font.font = xref->font.font;
	line->addr_font.fgcolor = xref->font.fgcolor;
	line->addr_font.bgcolor = CODE_COLOR(addr_bg);
	return(1);
}

int asm_addtxrefline( struct DISP_LINE *line, struct address *a, struct xref *x ){
	struct ASMXREF_LINE *xref;
	struct name n;
	char type[6] = {0};
		
	if (! line) return(0);
	line->type = ASMXREF;
	line->addr = x->to_rva;
	line->addr_pos = CODE_POS(addr_pos);
	
	xref = &line->u.xref;
	memset( xref, 0, sizeof( struct ASMXREF_LINE ) );

	xref->pos = XREF_POS(xref_pos);
	xref->font.font = XREF_FONT(xref_to_font);
	xref->font.fgcolor = XREF_COLOR(xref_to_fg);
	xref->font.bgcolor = XREF_COLOR(xref_to_bg);

	type[0] = '(';
	type[1] = ( x->type & XREF_READ ) ? 'r' : '-';
	type[2] = ( x->type & XREF_WRITE ) ? 'w' : '-';
	type[3] = ( x->type & XREF_EXEC ) ? 'x' : '-';
	type[4] = ')';

	sprintf( xref->text, "Cross reference %s from ", type );
	if ( bdb_index_find( NAME_RVA, &x->from_rva, &n) ) 
		strncpy( xref->addr, n.text, 63 );
	else
		sprintf( xref->addr, "%08X", x->from_rva );

	line->addr_font.font = xref->font.font;
	line->addr_font.fgcolor = xref->font.fgcolor;
	line->addr_font.bgcolor = CODE_COLOR(addr_bg);
	return(1);
}

int asm_addcmtline( struct DISP_LINE *line, struct address *a, struct comment *c ){
	struct ASMCMNT_LINE *cmt;
		
	if (! line) return(0);
	line->type = ASMCOMMENT;
	line->addr = a->rva;
	line->addr_pos = CODE_POS(addr_pos);
	cmt = &line->u.cmt;
	memset( cmt, 0, sizeof(struct ASMCMNT_LINE) );
	cmt->pos = CMT_POS(cmt_pos);
	
	if ( c->type == CMT_AUTO ) {
		cmt->font.font = CMT_FONT(cmt_auto_font);
		cmt->font.fgcolor = CMT_COLOR(cmt_auto_fg);
		cmt->font.bgcolor = CMT_COLOR(cmt_auto_bg);
	} else {
		cmt->font.font = CMT_FONT(cmt_user_font);
		cmt->font.fgcolor = CMT_COLOR(cmt_user_fg);
		cmt->font.bgcolor = CMT_COLOR(cmt_user_bg);
	}
	
	strncpy(cmt->cmt, c->text, 255);
	line->addr_font.font = cmt->font.font;
	line->addr_font.fgcolor = cmt->font.fgcolor;
	line->addr_font.bgcolor = CODE_COLOR(addr_bg);	
	
	return(1);
}


void asm_display_addline( struct DISPLAY *d, int *i, struct address *a ) {
	/* these 2 are temporary, for testing */
	int cont;
	char buf[256] = {0};
	struct code c;
	struct name n;
	struct function f;
	struct xref x;
	struct address addr;
	struct section sec;
	struct string str;
	struct comment cmt;
	struct xref_from_rva xf;
	struct xref_to_rva xt;
		
	
	if ( a->flags & SECTION && bdb_index_find(SECTION_RVA, &a->rva, &sec) ) {
		asm_addsecline( &d->buf.lines[(*i)++], a, &sec );
		if ( *i >=d->buf.size )  return; 	
	}
	
	if ( bdb_index_find( NAME_RVA, &a->rva, &n ) ) {
		asm_addlabelline( &d->buf.lines[(*i)++], a, &n );
		if ( *i >=d->buf.size )  return; 
	}
	
	if ( a->flags & ADDR_CODE) {
		if ( bdb_index_find( FUNCTION_RVA, &a->rva, &f ) ){
			asm_addfuncline( &d->buf.lines[(*i)++], a, &f );
			if ( *i >= d->buf.size ) return; 
			if ( f.comment && bdb_index_find( COMMENT_ID, &f.comment, &cmt ) ){
				asm_addcmtline( &d->buf.lines[(*i)++], a, &cmt );
				if ( *i >=d->buf.size )  return; 	
			}	
		}
			
		if ( bdb_index_find( CODE_RVA, &a->rva, &c ) ){
			asm_addcodeline( &d->buf.lines[(*i)++], a, &c );
			if ( *i >=d->buf.size ) return; 
		}
	
	} else if ( a->flags & ADDR_STRING && bdb_index_find(STRING_RVA, &a->rva, &str) ) {
			asm_addstrline( &d->buf.lines[(*i)++], a, &str );
			if ( *i >=d->buf.size )  return; 				
	} else {
		memcpy( &addr, a, sizeof(struct address) );
		/* for each 16 bytes of addr size, add line of hexcode */
		for (cont=a->rva + a->size; addr.rva < cont; addr.rva+=16, addr.pa+=16){
			addr.size = (cont - addr.rva > 16) ? 16 : cont - addr.rva;			
			asm_adddataline( &d->buf.lines[(*i)++], &addr);
			if ( *i >=d->buf.size )  return;
		}
	}

	if ( a->comment && bdb_index_find( COMMENT_ID, &a->comment, &cmt ) ){
			asm_addcmtline( &d->buf.lines[(*i)++], a, &cmt );
			if ( *i >=d->buf.size )  return; 	
	}

	xf.from_rva = a->rva;
	xf.to_rva = 0;
	cont = bdb_find_closest_next( XREF_FROM_RVA, &xf, &x );
	while ( cont && x.from_rva == a->rva ) {
		asm_addfxrefline( &d->buf.lines[(*i)++], a, &x );
		if ( *i >=d->buf.size )  return; 
		cont = bdb_index_next( XREF_FROM_RVA, &x );
	}
	
	xt.to_rva = a->rva;
	xt.from_rva = 0;
	cont = bdb_find_closest_next( XREF_TO_RVA, &xt, &x );
	while ( cont && x.to_rva == a->rva ) {
		asm_addtxrefline( &d->buf.lines[(*i)++], a, &x );
		if ( *i >=d->buf.size )  return; 
		cont = bdb_index_next( XREF_TO_RVA, &x );
	}
	
	
	/* normalize i for counter of caller */
	(*i)--;
	
	return;
}


void cb_hscroll_asmwin(GtkAdjustment *adj, float *data){	
	*data = adj->value;
}

void cb_vscroll_asmwin(GtkAdjustment *adj, float *data){
	int old, new; /* convert moronic floats to sensible integers */
		
	if (! asm_display.init) return;
	old = *data;
	new = adj->value;
	*data = adj->value;
	/* deal with scrollbar action : send old & new positions */
	update_win(&asm_display, old, new);
}

