#ifndef SOB_ASM_WIN_H
#define SOB_ASM_WIN_H

#include <gtk/gtk.h>
#include <bdb.h>
#include "sob_ui_prefs.h"



struct ASMCODE_LINE {
	int addr_pos;					/* positions are stored for reverse-mapping */
	int hex_pos;
	char hex[64];
	int mnem_pos;
	char mnem[16];
	struct FONT_PREF dest_font;	/* only context-dependent fonts need be stored */
	int dest_pos;
	char dest[32];
	struct FONT_PREF src_font;
	int src_pos;
	char src[32];
	struct FONT_PREF aux_font;
	int aux_pos;
	char aux[24];
};

struct ASMDATA_LINE {	
	int addr_pos;
	int hex_pos;
	char hex[96];
	int ascii_pos;
	char ascii[32];
};

struct ASMFUNC_LINE {	
	int pos;
	char desc[128];
};

struct ASMLABL_LINE {
	struct FONT_PREF font;
	int pos;
	char name[64];	
};

struct ASMCMNT_LINE {	
	struct FONT_PREF font;
	int pos;
	char cmt[256];	
};

struct ASMSTR_LINE {	
	int pos;
	char str[256];	
};
struct ASMXREF_LINE {	
	struct FONT_PREF font;
	int pos;
	char text[32];
	char addr[64];
};

struct ASMSEC_LINE {
	int pos;
	char desc[128];
};

struct DISPLAY;
struct DISP_LINE;
	
void asm_display_fill(struct DISPLAY *d, GtkText *t, struct DISP_LINE *line);
void asm_display_addline( struct DISPLAY *d, int *i, struct address *a );
int asm_display_total( struct DISPLAY *d );
void cb_hscroll_asmwin(GtkAdjustment *adj, float *data);
void cb_vscroll_asmwin(GtkAdjustment *adj, float *data);
#endif
