#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <bastard.h>
#include <bdb.h>

#include "support.h"
#include "sob_ui_prefs.h"
#include "sob_ui.h"
#include "db/db_query.h"


extern GtkWidget *sob_main_window;


/* fill/refresh the various columned lists */
void FillSections( void ) {
	db_table *t;
	db_field *name, *addr, *size, *perm;
	db_result *r, *head;
	char *str[4]; 					/* pointers to strings for CList */
	char addr_buf[16], size_buf[16], perm_buf[32];
	
   GtkCList *l = (GtkCList *) lookup_widget(sob_main_window, "SectionList");
		
	t = db_table_by_name(db_schema_by_name("TARGET"), "SECTION");
	name = db_field_by_name(t, "name");
	addr = db_field_by_name(t, "rva");
	size = db_field_by_name(t, "size");
	perm = db_field_by_name(t, "flags");
	str[1] = addr_buf;
	str[2] = size_buf;
	str[3] = perm_buf;
	
	r = head = db_table_get(t);
	
	while (r) {
		str[0] = r->data + name->offset;
		sprintf( addr_buf, "0x%08X", *(int *)(r->data + addr->offset));
		sprintf( size_buf, "0x%X", *(int *)(r->data + size->offset));
		/* TODO: translate PERMS to human-readable values */
		sprintf( perm_buf, "0x%08X", *(int *)(r->data + perm->offset));
		
		gtk_clist_append( l, str);
		r = r->next;
	}
	
	db_result_free(head);
	return;
}

void ClearSections(){
   GtkCList *l = (GtkCList *) lookup_widget(sob_main_window, "SectionList");
	gtk_clist_clear( l );
	return;
}
void RefreshSections( void ){
	ClearSections();
	FillSections();
}


void FillNames( void ) {
	db_table *t;
	db_field *name, *addr, *type;
	db_result *r, *head;
	char *str[3]; 					
	char addr_buf[16], type_buf[32];
   GtkCList *l = (GtkCList *) lookup_widget(sob_main_window, "NameList");
	
	
	t = db_table_by_name(db_schema_by_name("TARGET"), "NAME");
	name = db_field_by_name(t, "text");
	addr = db_field_by_name(t, "rva");
	type = db_field_by_name(t, "type");
	str[1] = addr_buf;
	str[2] = type_buf;
	
	r = head = db_table_get(t);
	
	while (r) {
		str[0] = r->data + name->offset;
		sprintf( addr_buf, "0x%08X", *(int *)(r->data + addr->offset));
		sprintf( type_buf, "0x%08X", *(int *)(r->data + type->offset));
		
		gtk_clist_append( l, str);
		r = r->next;
	}
	
	db_result_free(head);
	return;
}

void ClearNames(){
   GtkCList *l = (GtkCList *) lookup_widget(sob_main_window, "NameList");
	gtk_clist_clear( l );
	return;
}

void RefreshNames( void ){
	ClearNames();
	FillNames();
} 

int list_xrefs_to( unsigned long rva, char *buf, int len ) {
	struct xref_to_rva xt;
	struct xref x;
	int cont;
	char tmp[12];
	
	xt.to_rva = rva;
	xt.from_rva = 0;
	cont = bdb_find_closest_next( XREF_TO_RVA, &xt, &x );
	while ( cont && x.to_rva == rva && len - strlen(buf) > 9 ) {
		sprintf( tmp, "%08X", x.from_rva );
		if (! strstr( buf, tmp ) ) {
			strcat( buf, tmp );
			strcat( buf, " ");
		}
		cont = bdb_index_next( XREF_TO_RVA, &x );
	}
	return(1);
}

int list_xrefs_from( unsigned long rva, char *buf, int len ) {
	struct xref_from_rva xf;
	struct xref x;
	int cont;
	char tmp[12];
	
	xf.from_rva = rva;
	xf.to_rva = 0;
	cont = bdb_find_closest_next( XREF_FROM_RVA, &xf, &x );
	while ( cont && x.from_rva == rva && len - strlen(buf) > 9 ) {
		sprintf( tmp, "%08X ", x.to_rva );
		strcat( buf, tmp );
		cont = bdb_index_next( XREF_FROM_RVA, &x );
	}
	return(1);
}		

int list_xrefs_fromfunc( struct function *f, char *buf, int len ){
	struct code c;
	char xfrom[32];
	int cont;
	
	cont = bdb_index_find( CODE_RVA, &f->rva, &c ); 
	while ( cont && (c.rva - f->rva) < f->size ) {
		memset( xfrom, 0, 32 );
		list_xrefs_from( c.rva, xfrom, 32 );
		strncat( buf, xfrom, len - strlen(buf) -1 );
		cont = bdb_index_next(CODE_RVA, &c);
	}
}

void FillFunctions( void ) {
	char *str[5]; 					
	char addr_buf[16], *xrefto, *xreffrom;
	
	struct function f;
	struct name n;
	struct comment c;
	int cont;
		
	GtkCList *l = (GtkCList *) lookup_widget(sob_main_window, "FuncList");

	str[1] = addr_buf;
	str[2] = xrefto = calloc( 128, 1);
	if (! xrefto) return;
	str[3] = xreffrom = calloc( 512, 1);
	if (! xreffrom) { free(xrefto); return; }

	cont = bdb_index_first( FUNCTION_RVA, &f );
	while ( cont ){
		sprintf( addr_buf, "0x%08X", f.rva);
		/* get name */
		if (bdb_index_find( NAME_RVA, &f.rva, &n ))
			str[0] = n.text;
		else 
			str[0] = "";
		if ( f.comment && bdb_index_find(COMMENT_ID, &f.comment, &c) )
			str[4] = c.text;
		else
			str[4] = "";
		
		list_xrefs_to( f.rva, xrefto, 128 );
		list_xrefs_fromfunc( &f, xreffrom, 512 );
		
		gtk_clist_append( l, str);
		memset( xrefto, 0, 128);
		memset( xreffrom, 0, 512 );
		cont = bdb_index_next( FUNCTION_RVA, &f );	
	}
	
	free(xrefto);
	free(xreffrom);
	return;
} 

void ClearFunctions( ) {
	GtkCList *l = (GtkCList *) lookup_widget(sob_main_window, "FuncList");
	gtk_clist_clear( l );
	return;
}

void RefreshFunctions( void ){
	ClearFunctions();
	FillFunctions();
}


void FillImports( void ) {
	char *str[4]; 					
	char addr_buf[16], *xrefto;
	struct lib lib;
	struct import_addr i;
	struct name n;
	int cont;
   	GtkCList *l = (GtkCList *) lookup_widget(sob_main_window, "ImportList");
		
	xrefto = calloc( 1024, 1);
	if (! xrefto ) return;
		
	str[2] = addr_buf;
	str[3] = xrefto;
	
	cont = bdb_index_first( IMPORT_ADDR_RVA, &i );
	while (cont) {
		sprintf( addr_buf, "0x%08X", i.rva);
		if ( bdb_index_find( NAME_RVA, &i.rva, &n ) ) 
			str[0] = n.text;
		else
			str[0] = "";
		
		if ( bdb_index_find( LIB_ID, &i.library, &lib) )
			str[1] = lib.name;
		else 
			str[1] = "";
		
		list_xrefs_to( i.rva, xrefto, 1024 );
		gtk_clist_append( l, str);
		memset( xrefto, 0, 1024);
		cont = bdb_index_next(IMPORT_ADDR_RVA, &i);
	}
	
	free(xrefto);
	return;
} 

void ClearImports(){
	GtkCList *l = (GtkCList *) lookup_widget(sob_main_window, "ImportList");
	gtk_clist_clear( l );
	return;
}

void RefreshImports( void ){
	ClearImports();
	FillImports();
}


void FillStrings( void ) {
	char *str[3]; 					
	char addr_buf[16], *xrefto;
	struct string s;
	int cont;
	GtkCList *l = (GtkCList *) lookup_widget(sob_main_window, "StringList");
		
	xrefto = calloc( 1024, 1 );
	if (! xrefto) return;
	str[0] = s.text;
	str[1] = addr_buf;
	str[2] = xrefto;
	
	cont = bdb_index_first( STRING_RVA, &s);
	while (cont) {
		sprintf( addr_buf, "0x%08X",s.rva);
		list_xrefs_to(s.rva, xrefto, 1024);		
		gtk_clist_append( l, str);
		memset( xrefto, 0, 1024 );
		cont = bdb_index_next( STRING_RVA, &s );
	}
	
	free(xrefto);
	return;
}

void ClearStrings(){
	GtkCList *l = (GtkCList *) lookup_widget(sob_main_window, "StringList");
	gtk_clist_clear( l );
	return;
}
void RefreshStrings( void ){
	ClearStrings();
	FillStrings();
} 

void ClearHeader() {
	disp_clear_text("HeaderView");
	return;
}

void FillHeader( char *text ) {
	GtkText *t = (GtkText *)lookup_widget(sob_main_window, "HeaderView");
	ClearHeader();
	gtk_text_insert( t, SOB_FONT(f_fixed_regular), NULL, NULL, text, -1 );
	return;
}

void console_add_text(char *buf, GdkColor *color) {
	GtkText *t;

	t = (GtkText *)lookup_widget(sob_main_window, "Console_STDOUT");
	gtk_text_insert( t, SOB_FONT(f_fixed_regular), color, 
							NULL,  buf, -1 );
	return;
}

void console_err_cb(gpointer data, gint source, GdkInputCondition condition) {
	char buf[512] = {0};
	
	read( source, buf, 512 );	
	console_add_text( buf, SOB_COLOR(f_errcolor));
	return;
}

void console_out_cb(gpointer data, gint source, GdkInputCondition condition) {
	char buf[512] = {0};
	
	fprintf(stderr, "got out cb !\n");
	read( source, buf, 512 );	
	console_add_text( buf, SOB_COLOR(f_errcolor));	
	return;
}

void init_console_win( void ) {
	int pipe_fd[2] = {0};
	
	if (! pipe( pipe_fd ) ) {
		close(STDOUT_FILENO);
		dup2( pipe_fd[1], STDOUT_FILENO);
		gdk_input_add( pipe_fd[0], GDK_INPUT_READ, console_out_cb, NULL );	
	}
	
	if (! pipe( pipe_fd ) ) {
		close(STDERR_FILENO);
		dup2( pipe_fd[1], STDERR_FILENO );
		gdk_input_add( pipe_fd[0], GDK_INPUT_READ, console_err_cb, NULL ); 
	}
	
	return;
}


