#ifndef SOB_UI_H
#define SOB_UI_H

#include <gtk/gtk.h>
#include "sob_asm_win.h"
#include "sob_int_win.h"
#include "sob_fin_win.h"


extern GtkWidget *sob_main_window; /* global main-window definition */


/* ----------------------- DIALOGS ----------------------- */
struct lfd_child {
	GtkFrame *frame;  /* Frame to hold VBox */
	GtkVBox  *box;		/* VBox for dynamic controls */
	GList *list;		/* string list for combo box */
	/* data values */
};

struct  lfd_dlg {		/* lfd is short for "load file dialog" */
	GtkWidget *self;
	int init;
	struct lfd_child disasm;
	struct lfd_child format;
	struct lfd_child cpu;
	struct lfd_child asmblr;
	struct lfd_child comp;
	struct lfd_child os;
	struct lfd_child hll;
} ;


extern struct lfd_dlg load_file_dlg;
	

#define ASMCODE 	0x1
#define ASMDATA 	0x2
#define ASMFUNCTION 0x3
#define ASMLABEL 	0x4
#define ASMCOMMENT 	0x5
#define ASMSTRING	0x6
#define ASMXREF		0x7
#define ASMSECTION	0x08
#define INTDIR		0x10
#define INTCODE		0x11
#define INTDATA		0x12
#define INTFUNC		0x13
#define INTCOMMENT	0x14

#define DISPLINE_EMPTY 0xFF
	
/* --------------------- CODE DISPLAYS --------------------- */
struct DISP_LINE {
	int type;
	unsigned long addr;				/* id in DB this line is tied to */
	int addr_pos;
	struct FONT_PREF addr_font;
	char text[80];					/* empty line */
	union DISP_LINE_U{
		struct ASMCODE_LINE code;		/* addr = c->rva */
		struct ASMDATA_LINE data;
		struct ASMFUNC_LINE func;
		struct ASMLABL_LINE label;
		struct ASMCMNT_LINE cmt;
		struct ASMSTR_LINE str;
		struct ASMSEC_LINE sec;
		struct ASMXREF_LINE xref;
		struct INTDIR_LINE idir;		/* addr = i->id */
		struct INTCODE_LINE icode;
		struct INTDATA_LINE idata;
		struct INTFUNC_LINE ifunc;
		struct INTCMNT_LINE icmt;
	} u;
	struct DISP_LINE *next;
};


struct DISP_BUFFER {
	int size; 			/* # lines in buffer: user-configured */
	int line_size;		/* # of chars in a line */
	int base;		   /* line containing load_display_buf rva */ 
	long start;			/* starting rva of buffer */
	long end;			/* ending rva of buffer */
	struct DISP_LINE *lines;
};

/* useful for database abstraction */
union DB_CODE_UNION {
	struct code c;
	struct int_code i;
	struct fin_code f;
	struct address a;
};

typedef void (*DISPLAY_ADDLINE_FN)(struct DISPLAY *, int *, void *);
typedef void (*DISPLAY_FILL_FN)(struct DISPLAY *, GtkText *, struct DISP_LINE *);
typedef int (*DISPLAY_TOTAL_FN)(struct DISPLAY *);
	
struct DISPLAY {
	/* these are set during struct initialization */
	char *name, *hs_name, *vs_name;	/* widget names */
	void *hs_cb, *vs_cb;			/* scrollbar callbacks */
	unsigned long table;			/* DB table display is tied to */
	DISPLAY_ADDLINE_FN addline;
	DISPLAY_FILL_FN fill;
	DISPLAY_TOTAL_FN total;
	/* these are dynamic */
	int size;			/* number of lines in a GtkText Widget "page" */
	int start, end;   	/* buffer indexes of first, last line */
	int current;		/* display index of current line */
	int init;
	int upper, lower; 	/* upper/lower sb bounds */
	int db_total;		/* total number of lines in DB */
	float x, y;			/* saved X and Y co-ords: Gtk doesn't do this ;( */
	struct DISP_BUFFER buf;
};

/* these are in the sob_asm_win, sob_int_win, sob_fin_win C files */
extern struct DISPLAY asm_display, int_display, fin_display;




int init_load_file_dlg();
int create_dlg_from_datfile(char *filename, struct lfd_child *c);
int create_disasm_dlg(char *dir);

void init_ui_main();
void init_display_win(struct DISPLAY *d, char *name);
void init_display_view(struct DISPLAY *d);
void free_disp_buffer(struct DISPLAY *d);
void reset_ui_main();
	
int get_addr_index_of_addr(struct DISPLAY *d, long addr);
unsigned long get_first_addr(struct DISPLAY *d);
unsigned long get_last_addr(struct DISPLAY *d);
int get_total_lines(struct DISPLAY *d);
long get_addr_from_offset(struct DISPLAY *d, long addr, int offset);
int get_buf_idx_from_addr(struct DISP_BUFFER *buf, long addr);
	
void load_display_buf(struct DISPLAY *d, long addr);
int load_display_buf_middle(struct DISPLAY *d, long addr);
int load_win_buf(struct DISPLAY *d, long addr);
	
void disp_clear_text( char *name);
void disp_load_text_from_file( GtkText *t, char *filename);
int disp_fill_to_pos(GtkText *t, int start, int pos);
int update_win(struct DISPLAY *d, int old, int new);
int fill_win( struct DISPLAY *d, int start);
void calc_win_size(struct DISPLAY *d);
int config_win( struct DISPLAY *d, int start );
	
#endif
