
#include <stdio.h>
#include <stdlib.h>
#include <bastard.h>
#include <bdb.h>

#include "sob_ui_prefs.h"
#include "sob_ui.h"
#include "sob_cfg.h"
#include "support.h"



/* these are copies of the 'real' fonts for pointer-init convenience */
GdkFont *var, *var_bold, *var_italic, *fixed, *fixed_bold, *fixed_italic;

/*    config file nonsense   */
struct SOB_CFG_ITEM uiprefs_code[] = {
	{"address.pos",read_int, write_int, {{0}} },
	{"address.font", read_font, write_font, {{(long) &fixed,0}} },
	{"address.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xFF00, 0xD700, 0x00} } },
	{"address.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x6100, 0x6100, 0x6100} } },
	{"hex.pos",read_int, write_int, {{8, 0}} },
	{"hex.num",read_int, write_int, {{6, 0}} },
	{"hex.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"hex.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xEE00, 0xB400, 0x2200} } },
	//{"hex.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x00, 0x00, 0x00} } },
	{"hex.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"mnemonic.pos",read_int, write_int, {{27, 0}} },
	{"mnemonic.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"mnemonic.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x0, 0x0, 0xCD00} } },
	{"mnemonic.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"operands.pos",read_int, write_int, {{37, 0}} },
	{"reg.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"reg.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x0, 0xEE00, 0x0} } },
	{"reg.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"imm.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"imm.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xEE00, 0x2C00, 0x2C00} } },
	{"imm.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"mem.font",read_font, write_font, {{(long) &fixed, 0}} },
	//{"mem.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xCD00, 0xAD00, 0x0} } },
	{"mem.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xFF00, 0xFF00, 0xFF00} } },
	{"mem.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"expr.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"expr.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x0, 0xCD00, 0xCD00} } },
	{"expr.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{NULL, NULL, NULL, {{0}} }
},	uiprefs_data[] = {
	{"address.pos" ,read_int, write_int, {{0}} },
	{"address.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"address.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xFF00, 0xD700, 0x00} } },
	{"address.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x6100, 0x6100, 0x6100} } },
	{"hex.pos",read_int, write_int, {{8, 0}} },
	{"hex.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"hex.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xEE00, 0xB400, 0x2200} } },
	{"hex.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x00, 0x00, 0x00} } },	
	{"ascii.pos",read_int, write_int, {{57, 0}} },
	{"ascii.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"ascii.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xFF00, 0xFF00, 0x0} } },
	{"ascii.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },	
	{"string.pos",read_int, write_int, {{30, 0}} },
	{"string.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"string.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xCD00, 0x2900, 0x0900} } },
	{"string.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },	
	{NULL, NULL, NULL, {{0}} }
},	uiprefs_xref[] = {
	{"pos",read_int, write_int, {{30,0}} },
	{"from.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"from.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x6800, 0x2200, 0x8B00} } },
	{"from.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"to.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"to.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x5500, 0x1A00, 0x8B00} } },
	{"to.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{NULL, NULL, NULL, {{0}} }
},	uiprefs_cmt[] = {
	{"pos",read_int, write_int, {30, 0} },
	{"c_auto.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"c_auto.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8B00, 0x6500, 0x0800} } },
	{"c_auto.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"c_user.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"c_user.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x0, 0x8B00, 0x0} } },
	{"c_user.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{NULL, NULL, NULL, {{0}} }
}, uiprefs_name[] = {
	{"n_auto.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"n_auto.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xCD00, 0x3700, 0x00} } },
	{"n_auto.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"n_user.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"n_user.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x9100, 0x2C00, 0xEE0} } },
	{"n_user.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"n_symbol.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"n_symbol.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xFF00, 0xFF00, 0xFF00} } },	
	{"n_symbol.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },	
	{"n_sub.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"n_sub.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x2700, 0x4000, 0x8B00} } },
	{"n_sub.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"n_struct.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"n_struct.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xEE00, 0x0, 0xEE00} } },
	{"n_struct.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"n_import.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"n_import.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xFF00, 0x7F00, 0x00} } },
	{"n_import.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"n_export.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"n_export.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xEE00, 0x3000, 0xA700} } },
	{"n_export.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"n_section.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"n_section.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8B00, 0x0000, 0x0000} } },
	{"n_section.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{NULL, NULL, NULL, {{0}} }
}, uiprefs_intcode[] = {
	{"mnemonic.pos",read_int, write_int, {{8, 0}} },
	{"mnemonic.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"mnemonic.fgcolor", read_gdkcolor, write_gdkcolor,{ {0, 0x0, 0x0, 0xCD00} } },
	{"mnemonic.bgcolor", read_gdkcolor, write_gdkcolor,{ {0, 0x8500, 0x8500, 0x8500} } },
	{"dir.pos",read_int, write_int, {{0}} },
	{"dir.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"dir.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x0000, 0xff00, 0xff00} } },
	{"dir.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"operands.pos",read_int, write_int, {{24, 0}} },
	{"reg.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"reg.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x0, 0xEE00, 0x0} } },
	{"reg.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{"imm.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"imm.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0xEE00, 0x2C00, 0x2C00} } },
	{"imm.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{NULL, NULL, NULL, {{0}} }
}, uiprefs_fincode[] = {
	{"code.pos",read_int, write_int, {{8, 0}} },
	{"code.font",read_font, write_font, {{(long) &fixed, 0}} },
	{"code.fgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x0, 0x0, 0x0} } },
	{"code.bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },
	{NULL, NULL, NULL, {{0}} }
}, uiprefs_fonts[] = {
	{"fixed.regular",read_font, write_font, {{(long) &fixed, 0}} },
	{"fixed.bold",read_font, write_font, {{(long) &fixed_bold, 0}} },
	{"fixed.italic",read_font, write_font, {{(long) &fixed_italic, 0}} },
	{"var.regular",read_font, write_font, {{(long) &var, 0}} },
	{"var.bold",read_font, write_font, {{(long) &var_bold, 0}} },
	{"var.italic",read_font, write_font, {{(long) &var_italic, 0}} },
	{"fgcolor", read_gdkcolor, write_gdkcolor, { {0, 0x0, 0x0, 0x0} } },
	{"bgcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8500, 0x8500, 0x8500} } },	
	{"errcolor",read_gdkcolor, write_gdkcolor, { {0, 0x8B00, 0x0000, 0x0000} } },
	{NULL, NULL, NULL, {{0}} }
};

struct SOB_CFG_ITEM ui_prefs_cfg[] = {
	{ "code", read_uipref_section, write_uipref_section, {{(long)uiprefs_code,0}} },
	{ "data", read_uipref_section, write_uipref_section, {{(long)uiprefs_data,0}} },
	{ "xref", read_uipref_section, write_uipref_section, {{(long)uiprefs_xref,0}} },
	{ "cmt", read_uipref_section, write_uipref_section, {{(long)uiprefs_cmt,0}} },
	{ "name", read_uipref_section, write_uipref_section, {{(long)uiprefs_name,0}} },
	{ "intcode", read_uipref_section, write_uipref_section, {{(long)uiprefs_intcode,0}} },
	{ "fincode", read_uipref_section, write_uipref_section, {{(long)uiprefs_fincode,0}} },
	{ "fonts", read_uipref_section, write_uipref_section, {{(long)uiprefs_fonts,0}} },
	{ NULL }
};

struct USER_UI_PREFS prefs = {uiprefs_code, uiprefs_data, uiprefs_xref, uiprefs_cmt, 
								uiprefs_name, uiprefs_intcode, uiprefs_fincode, uiprefs_fonts};

int set_ui_textstyle( char *name ) {
	GtkStyle *s;
	GtkWidget *w;
	
	w = lookup_widget(sob_main_window, name);
	s = gtk_widget_get_style( w );
	s = ( s ) ? gtk_style_copy(s) : calloc( sizeof( GtkStyle ), 1 );
	memcpy( &s->text[GTK_STATE_NORMAL], SOB_COLOR(f_fgcolor), sizeof(GdkColor));
	memcpy( &s->base[GTK_STATE_NORMAL], SOB_COLOR(f_bgcolor), sizeof(GdkColor));
	gtk_widget_set_style(w, s);	
	return(1);
}

int init_ui_prefs(){
	GdkFont *font;
	GdkColormap *cmap;
	
	/* copy 6 main fonts to the global structures */
	fixed = gdk_font_load("-*-courier-medium-r-normal-*-*-100-*-*-*-*-*-*");
	fixed_bold = gdk_font_load("-*-courier-bold-r-normal-*-*-100-*-*-*-*-*-*");
	fixed_italic = gdk_font_load("-*-courier-medium-i-normal-*-*-100-*-*-*-*-*-*");
	var = gdk_font_load("-*-times-medium-r-normal-*-*-100-*-*-*-*-*-*");	
	var_bold = gdk_font_load("-*-times-bold-r-normal-*-*-100-*-*-*-*-*-*");
	var_italic = gdk_font_load("-*-times-medium-i-normal-*-*-100-*-*-*-*-*-*");
	
	cmap = gdk_colormap_get_system();
	
	/* configure text widgets to match user prefs */
	set_ui_textstyle("AsmView");
	set_ui_textstyle("IntView");
	set_ui_textstyle("FinView");

	return(1);
}

/* config file crap */
void read_ui_prefs( struct SOB_CFG_ITEM *item, char *line ){
	return;
}
void write_ui_prefs( struct SOB_CFG_ITEM *item, char *buf, int len ){
	return;
}
	
void read_uipref_section( struct SOB_CFG_ITEM *item, char *line ){
	return;
}
void write_uipref_section( struct SOB_CFG_ITEM *item, char *buf, int len ){
	return;
}
	
void read_gdkcolor(struct SOB_CFG_ITEM *item, char *line){
	return;
}
void write_gdkcolor(struct SOB_CFG_ITEM *item, char *buf, int len ){
	return;
}
void read_font(struct SOB_CFG_ITEM *item, char *line ){
	return;
}
void write_font(struct SOB_CFG_ITEM *item, char *buf, int len){
	return;
}
void read_int(struct SOB_CFG_ITEM *item, char *line){
	return;
}
void write_int(struct SOB_CFG_ITEM *item, char *buf, int len) {
	return;
}
					
