#include <stdlib.h>
#include <vm.h>
#include <extension.h>


int vm_init()
{
	vm_init_stack;
	return (1);
}

int vm_add_regtbl_entry(int index, char *mnemonic, int size, int type)
{
	if (index >= ext_arch->sz_regtable)
		return (0);
	ext_arch->reg_table[index].size = size;
	ext_arch->reg_table[index].type = type;
	strncpy(ext_arch->reg_table[index].mnemonic, mnemonic, 8);
	return (1);
}

char *vm_get_reg_name(int index)
{
	if (index >= ext_arch->sz_regtable)
		return (0);
	return (ext_arch->reg_table[index].mnemonic);
}

int vm_get_reg_byname(char *name)
{
	int x;
	for ( x = 0; x < ext_arch->sz_regtable; x++ ) {
		if (! strcmp( ext_arch->reg_table[x].mnemonic, name) )
			return(x);
	}
	return (0);
}

int vm_get_reg_size(int index)
{
	if (index >= ext_arch->sz_regtable)
		return (0);
	return (ext_arch->reg_table[index].size);
}

int vm_get_reg_type(int index)
{
	if (index >= ext_arch->sz_regtable)
		return (0);
	return (ext_arch->reg_table[index].type);
}

int vm_get_num_regs()
{
	return (ext_arch->sz_regtable);
}

void vm_cleanup()
{
	vm_cleanup_stack();
	return;
}

void *vm_do_reg_op(int reg, int op, void *operand)
{

	/*switch (op){
	   case REGOP_READ:
	   break;
	   case REGOP_WRITE:
	   break;
	   case REGOP_ADD:
	   break;
	   case REGOP_SUBTRACT:
	   break;
	   case REGOP_R_SHIFT:
	   break;
	   case REGOP_L_SHIFT:
	   break;
	   default:
	   break;
	   } */
	return (operand);
}

int vm_read_reg( int reg, struct VM_DATA *dest ) {
	if (reg >= ext_arch->sz_regtable)
		return (0);
	memcpy( dest->u.buf, ext_arch->reg_table[reg].data.u.buf, 16);
	return(1);
}

int vm_write_reg( int reg, struct VM_DATA *src ) {
	if (reg >= ext_arch->sz_regtable)
		return (0);
	memcpy( ext_arch->reg_table[reg].data.u.buf, src->u.buf, 16);
	return(1);
}

struct VM_STACK vm_stack_head, *vm_sp;

int vm_init_stack( ){
	memset( &vm_stack_head, 0, sizeof(struct VM_STACK) );
	vm_sp = &vm_stack_head;
	return(1);
}

int vm_cleanup_stack(){
	struct VM_STACK *s = vm_stack_head.next;
	while( s ) {
		vm_stack_head.next = s->next;
		free( s );
		s = vm_stack_head.next;
	}
	return(1);
}

int vm_push_stack( struct VM_DATA *src ) {
	struct VM_STACK *s;
	if (! src) return(0);
	s = calloc( sizeof(struct VM_STACK), 1 );
	if (! s) return(0);
	if (! vm_sp) vm_sp = &vm_stack_head;
	vm_sp->next = s;
	s->prev = vm_sp;
	vm_sp = s;
	memcpy( s->data.u.buf, src->u.buf, 16 );
	return(1);
}

int vm_pop_stack( struct VM_DATA *dest ) {
	if (! dest) return(0);
	if ( ! vm_sp || vm_sp == &vm_stack_head ) return(0);
	memcpy( dest->u.buf, vm_sp->data.u.buf, 16 );
	vm_sp = vm_sp->prev;
	if (! vm_sp) vm_sp = &vm_stack_head;
	free(vm_sp->next);
	vm_sp->next = NULL;
	return(1);
}

int vm_push_operand( long op, unsigned int type ) {
	struct VM_DATA d = {0};

	switch (type & OP_TYPE_MASK) {
		case OP_REG:
			if ( op == ext_arch->SP )
				d.flags = VM_STACK_SP;
			else if ( op == ext_arch->FP )
				d.flags = VM_STACK_FP;
			else if ( op == ext_arch->IP )
				d.flags = VM_STACK_RET;
			vm_read_reg( op, &d );
			break;
		case OP_IMM:
			d.u.i = op;
			break;
		case OP_PTR:
			d.flags = VM_STACK_PTR;
		case OP_ADDR:
			d.u.p = (int *)op;
			break;
		default:
			/* push 0 */
			d.flags = VM_STACK_DYNVAL;
	}
	return( vm_push_stack( &d ) );
}

long vm_pop_operand( long op, unsigned int type ) {
	struct VM_DATA d;

	vm_pop_stack( &d );

	if ( type & OP_TYPE_MASK == OP_REG ) {
		vm_write_reg( op, &d );
	}
	/* else discard */
	return( d.u.i );
}

int vm_frame_stack() {
	struct VM_DATA d;

	/* save old vm_fp */
	d.flags = VM_STACK_SAVE;
	d.u.p = vm_sp;
	vm_push_stack( &d );
	return(1);
}

int vm_unframe_stack() {
	struct VM_DATA d;
	while( vm_sp->prev && vm_sp->data.flags != VM_STACK_SAVE ){
		vm_pop_stack( &d );
	}
	if ( vm_sp->data.flags == VM_STACK_SAVE ) {
		vm_pop_stack( &d );
	}
	/* stack pointer is now restored either to saved pos or top of stack */
	return(1);
}
