/*

clean-osf.8759.c

Linux/OSF-8759 aka Linux/OSF-A Virus Cleaner

               by Druid <druid@vmatrics.org>


After getting my computer infected with this damn virus I searched the net
for a program to clean it. Because I couldn't find any, I wrote one ;)

This program will scan the filesystem and tell you if you have this virus.
When the virus is found, it will desinfect the file and hopefully restore
the file to its original form.

Compile: gcc clean-osf.8759.c -o clean-osf.8759-ps

Why clean-osf.8759-ps? Because the virus won't infect files ending in ps :P


Taken from some virus analysis on the net:

> OSF.8759 is a Linux virus infecting ELF executable programs.
>
> OSF consists of two quite distinct parts: a viral part and a backdoor part.
>
> The virus checks if its code is executed under the debugger and if so, it skips
> the file infection routine altogether. This routine is also avoided if the
> infected file is executed from the /proc or /dev directories. Otherwise, it
> infects up to 201 files in the current directory as well as up to 201 files in
> the /bin directory. The virus avoids infecting the "ps" program (and all programs
> with names ending with the string "ps").
>
> Infected files increase their size by 8759 bytes. The virus marks all infected
> programs by setting a value of the byte at offset 0x0A to 2.
>
> The backdoor procedure establishes a server listening on port 3049 (or higher).
> Depending on the contents of packets received from a client OSF may present a
> remote user with an interactive shell or execute commands on a local system using
> the syntax: "/bin/sh -c command".


http://www.vMatriCS.oRg

Greetz: vMatriCS + Casper & the other Dionis admins (including me :))

-mY master iz Druid

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <errno.h>
#include <dirent.h>
#include <termios.h>
#include <fcntl.h>


// Linux/OSF signature - 34 bytes
#define SIGNATURE "\xeb\x1fOSF                            \xb8"
#define SIGSIZE (sizeof(SIGNATURE)-1)
#define BODY_SIZE 0x1000
#define HEAD_SIZE (SIGSIZE + 4) // signature size + original entry point


// ELF32 stuff

// ELF32 file header
typedef struct
{
  unsigned char e_ident[16];
  unsigned short e_type;
  unsigned short e_machine;
  unsigned int e_version;
  unsigned int e_entry;
  unsigned int e_phoff;
  unsigned int e_shoff;
  unsigned int e_flags;
  unsigned short e_ehsize;
  unsigned short e_phentsize;
  unsigned short e_phnum;
  unsigned short e_shentsize;
  unsigned short e_shnum;
  unsigned short e_shstrndx;
} ELFHDR;

// ELF32 program header
typedef struct
{
  unsigned int p_type;
  unsigned int p_offset;
  unsigned int p_vaddr;
  unsigned int p_paddr;
  unsigned int p_filesz;
  unsigned int p_memsz;
  unsigned int p_flags;
  unsigned int p_align;
} ELFPHDR;

#define PT_LOAD 1

// ELF32 section header
typedef struct
{
  unsigned int sh_name;
  unsigned int sh_type;
  unsigned int sh_flags;
  unsigned int sh_addr;
  unsigned int sh_offset;
  unsigned int sh_size;
  unsigned int sh_link;
  unsigned int sh_info;
  unsigned int sh_addralign;
  unsigned int sh_entsize;
} ELFSHDR;

// stats
int dirs = 0, files = 0, infected = 0, cleaned = 0, unknown = 0;

// options
int clean = 1, prompt = 0, recursive = 1, symlinks = 0, stayonfs = 0, execonly = 0, skipspecial = 1;

// globals
dev_t current_dev;


void print_stats()
{
  printf("\n***** Scan Results *****\n\n");

  if(!files) printf("No files were actually scanned.\nYou should change the targets/options\n");
  else if(!infected) printf("None of the scanned files are infected with Linux/OSF-8759.\nYour are probably safe ;)\n");
  else if(!cleaned) printf("Your sistem IS INFECTED with Linux/OSF-8759!\nNO file was cleaned!\n");
  else if(cleaned < infected) printf("Your system IS STILL INFECTED with Linux/OSF-8759!\nSome files were not cleaned. You should try to clean / delete / restore them.\n");
  else printf("Your system was infected with Linux/OSF/8759!\nThanks to this proggy the virus was removed ;)\n");

  printf("\n");

  printf("Directories : %6d\n", dirs);
  printf("Files       : %6d\n", files);
  printf("Infected    : %6d\n", infected);
  printf("Cleaned     : %6d\n", cleaned);
  printf("Unknown     : %6d\n", unknown);
  printf("\n");
}

void ctrlc(int i)
{
  printf("\n\nScan canceled by user\n");
  print_stats();
  exit(0);
}

int scan_file(const char *fname)
{
  int ret = 0, i;
  FILE *fd, *oldfd = NULL;
  ELFHDR elfhdr;
  ELFPHDR phdr;
  ELFSHDR sect;
  char buf[4096];
  long off, len, size;
  unsigned int virus_start = 0, offset_bd, orig_entry;
  unsigned char vir_sig[HEAD_SIZE];
  char opt;
  struct stat st;

  files++; // increase stats

  fd = fopen(fname, "rb");
  if(!fd)
  {
    printf(" - unreadable: %s\n", strerror(errno));
    errno = 0;
    return 0;
  }

  // read header
  if(fread(&elfhdr, sizeof(ELFHDR), 1, fd) != 1) goto err;
  if(memcmp(elfhdr.e_ident, "\x7f" "ELF", 4)) goto err;

  // virus sign
  if(elfhdr.e_ident[10] != '\x02') goto err;

  // find the program headers and search for signature
  fseek(fd, elfhdr.e_phoff, SEEK_SET);

  for(i = 0; i < elfhdr.e_phnum; i++)
  {
    if(fread(&phdr, sizeof(ELFPHDR), 1, fd) != 1) goto err;

    if(!virus_start && phdr.p_type == PT_LOAD)
    {
      // the signature should be here if it's infected
      if(phdr.p_offset + phdr.p_filesz < BODY_SIZE + sizeof(ELFHDR))
      {
        printf("%s - infection marker, but no space for sig\n", fname);
	unknown++;
        goto err;
      }
      virus_start = phdr.p_offset + phdr.p_filesz - BODY_SIZE;
      off = ftell(fd); // save position
      fseek(fd, virus_start, SEEK_SET);
      if(fread(&vir_sig, 1, HEAD_SIZE, fd) != HEAD_SIZE) goto err;
      if(memcmp(vir_sig, SIGNATURE, SIGSIZE))
      {
        printf("%s - infection marker, but no signature\n", fname);
	unknown++;
        goto err;
      }

      // signature found, file infected
      ret++;
      infected++;
      printf("Infected: %s", fname); fflush(stdout);

      // prompt user for action if -v
      if(prompt)
      {
        struct termios t, old;

	printf("\nClean (Yes / No / clean All / Clean none / eXit) ? "); fflush(stdout);

        tcgetattr(0, &t);
        old = t;
	t.c_lflag &= ~ICANON;
        t.c_cc[VMIN] = 1;
        t.c_cc[VTIME] = 0;
        tcsetattr(0, TCSANOW, &t);
        read(fileno(stdin), &opt, 1);
        tcsetattr(0, TCSANOW, &old);
	printf("\n");

	switch(opt & 0xdf)
	{
        case 'Y':
          clean = 1;
	  break;

        case 'N':
          clean = 0;
	  break;

        case 'A':
          clean = 1;
	  prompt = 0;
	  break;

        case 'C':
          clean = 0;
	  prompt = 0;
	  break;

        case 'X':
	  ctrlc(0);
	  exit(0);
	}

        printf("Infected: %s", fname); fflush(stdout);
      }

      // don't clean if -s
      if(!clean)
      {
        fclose(fd);
	errno = 0;
	return 0;
      }

      // offset to backdoor code is saved in the ident file of ELF header
      offset_bd = *(unsigned int*) &elfhdr.e_ident[12];
      offset_bd -= BODY_SIZE;

      // open a temp file for writing
      oldfd = fd;
      fd = tmpfile();
      if(!fd) goto err;

      // copy infected file, without the virus or backdoor code

      // first copy everything before the virus code
      fseek(oldfd, 0, SEEK_SET);
      size = virus_start;
      while(size)
      {
        len = fread(buf, 1, size < sizeof(buf) ? size : sizeof(buf), oldfd);
        if(!len) break;
        fwrite(buf, 1, len, fd);
        size -= len;
      }

      // then copy the rest, starting after the virus code
      fseek(oldfd, virus_start + BODY_SIZE, SEEK_SET);
      size = offset_bd - virus_start;
      while(size)
      {
        len = fread(buf, 1, size < sizeof(buf) ? size : sizeof(buf), oldfd);
        if(!len) break;
        if(fwrite(buf, 1, len, fd) != len) goto err;
        size -= len;
      }

      fseek(fd, off, SEEK_SET); // restore position

      // viral code is at the end of this section, truncate it
      phdr.p_filesz -= BODY_SIZE;
      phdr.p_memsz -= BODY_SIZE;

      // write it back to the file
      fseek(fd, -sizeof(ELFPHDR), SEEK_CUR);
      if(fwrite(&phdr, sizeof(ELFPHDR), 1, fd) != 1) goto err;
    }

    if(virus_start && phdr.p_offset > virus_start)
    {
      // adjust file offset... we removed the viral code so
      // there's some space left that we must remove
      phdr.p_offset -= BODY_SIZE;

      // write the modified header to the file
      fseek(fd, -sizeof(ELFPHDR), SEEK_CUR);
      if(fwrite(&phdr, sizeof(ELFPHDR), 1, fd) != 1) goto err;
    }
  }

  // adjust section headers offset
  if(elfhdr.e_shoff > virus_start) elfhdr.e_shoff -= BODY_SIZE;

  // process section headers
  if(elfhdr.e_shnum)
  {
    fseek(fd, elfhdr.e_shoff, SEEK_SET);

    // read each section header and adjust file offset if it's after the virus code
    for(i = 0; i < elfhdr.e_shnum; i++)
    {
      if(fread(&sect, sizeof(ELFSHDR), 1, fd) != 1) goto err;

      // if the section is after the viral code
      if(sect.sh_offset > virus_start)
      {
        // adjust section offset
        sect.sh_offset -= BODY_SIZE;
        fseek(fd, -sizeof(ELFSHDR), SEEK_CUR);
        if(fwrite(&sect, sizeof(ELFSHDR), 1, fd) != 1) goto err;
      }
    }
  }

  // original entry point is just after the signature
  orig_entry = *(unsigned int*) &vir_sig[SIGSIZE];

  // final touch, remove infection marker
  // we could leave this byte \x02 so that the virus won't infect it again
  // but then checksums and MD5 sums will be messed up
  elfhdr.e_ident[10] = 0;
  elfhdr.e_entry = orig_entry; // restore entry point
  memset(elfhdr.e_ident + 12, 0, 4); // the virus stores offset to backdoor code here
  fseek(fd, 0, SEEK_SET);
  if(fwrite(&elfhdr, sizeof(ELFHDR), 1, fd) != 1) goto err;

  fclose(oldfd); // close file and reopen rw
  if(stat(fname, &st) == -1) goto err;
  unlink(fname); // delete old
  oldfd = fopen(fname, "w+b");
  if(!oldfd)
  {
    printf(" - unwriteable: %s\n", strerror(errno));
    fclose(fd);
    errno = 0;
    return 0;
  }
  fchmod(fileno(oldfd), st.st_mode);

  // copy infected file
  // only offset_bd bytes (so we won't copy the backdoor code)
  fseek(fd, 0, SEEK_SET);
  while(1)
  {
    len = fread(buf, 1, sizeof(buf), fd);
    if(!len) break;
    fwrite(buf, 1, len, oldfd);
  }

  ret++; // cleaned ;)
  cleaned++;

err:
  if(ret > 1) printf(" - DISINFECTED");
  else if(ret > 0) printf(" - UNABLE TO CLEAN");

  if(errno) printf(" - error: %s\n", strerror(errno));
  else if(ret) printf("\n");

  errno = 0;

  if(fd) fclose(fd);
  if(oldfd) fclose(oldfd);

  return ret;
}

int scan_dir(char *path, int level)
{
  struct stat st;
  DIR *dir;
  struct dirent *de;
  char fname[PATH_MAX+1], *p;

  if(lstat(path, &st) == -1)
  {
    printf("%s - lstat: %s\n", path, strerror(errno));
    return 0;
  }
  if(!symlinks && S_ISLNK(st.st_mode)) return 0; // dont follow symlinks if -l

  if(stat(path, &st) == -1)
  {
    printf("%s - stat: %s\n", path, strerror(errno));
    return 0;
  }
  if(S_ISREG(st.st_mode))
  {
    if(execonly && !(st.st_mode & (S_IXUSR | S_IXGRP | S_IXOTH))) return 0; // scan only executable files if -x
    return scan_file(path); // regular file, scan it
  }
  else if(!S_ISDIR(st.st_mode) || (!recursive && level)) return 0; // don't go into subdirs if -r

  if(!level) current_dev = st.st_dev; // save current device
  if(stayonfs && (st.st_dev != current_dev)) return 0; // don't go on other filesystems is -f

  if(strlen(path) >= PATH_MAX - 1) return 0;
  strcpy(fname, path);
  if(fname[strlen(fname) - 1] != '/') strcat(fname, "/");
  p = fname + strlen(fname);

  // skip special dirs (/proc, /dev) if -p
  if(skipspecial && (!strcmp(fname, "/proc/") || !strcmp(fname, "/dev/"))) return 0;

  dirs++; // increase stats

  dir = opendir(fname);
  if(!dir)
  {
    printf("%s - opendir: %s\n", path, strerror(errno));
    return 0;
  }

  while((de = readdir(dir)))
  {
    if(!strcmp(de->d_name, ".") || !strcmp(de->d_name, "..")) continue;
    strncpy(p, de->d_name, PATH_MAX - (p - fname));
    if(scan_dir(fname, level + 1) == -1) return -1;
  }

  closedir(dir);

  return 0;
}

void usage(char *prog)
{
  printf("\nScan a list of files/dirs for the Linux/OSF-8759 virus\n");
  printf("and desinfect them if the virus is found\n");
  printf("\n");
  printf("Usage: %s [-s] [-v] [-r] [-l] [-f] [-x] [-p] path...\n", prog);
  printf("\t-s\tDon't clean, just report infected files\n");
  printf("\t-v\tPrompt when a virus is found\n");
  printf("\t-r\tDon't recurse directories\n");
  printf("\t-l\tFollow symbolic links\n");
  printf("\t-f\tDon't go on other filesystems\n");
  printf("\t-x\tScan only executable files (+x)\n");
  printf("\t-p\tDon't skip special dirs (/dev, /proc)\n");
  printf("\n");

  exit(-1);
}

int main(int argc, char **argv)
{
  char c;

  printf("\n*** Linux/OSF-8759 Virus Cleaner\n");
  printf("*** by Druid <druid@vmatrics.org>\n");
  printf("*** Greetz: vMatriCS + Casper & the other Dionis admins\n");
  printf("\n");

  while((c = getopt(argc, argv, "svrlfxp")) != -1)
  {
    switch(c)
    {
    case 's':
      clean = 0;
      break;

    case 'v':
      prompt = 1;
      break;

    case 'r':
      recursive = 0;
      break;

    case 'l':
      symlinks = 1;
      break;

    case 'f':
      stayonfs = 1;
      break;

    case 'x':
      execonly = 1;
      break;

    case 'p':
      skipspecial = 0;
      break;

    default:
      usage(argv[0]);
      return -1;
    }
  }

  if(optind >= argc)
  {
    printf("%s: no targets specified\n", argv[0]);
    usage(argv[0]);
    return -1;
  }

  signal(SIGTERM, ctrlc);
  signal(SIGINT, ctrlc);

  while(optind < argc)
  {
    printf("Scanning: %s\n", argv[optind]);
    scan_dir(argv[optind], 0);
    optind++;
  }

  printf("\nScan ended\n");

  print_stats();

  return 0;
}
