Attribute VB_Name = "GCode"
Option Explicit

Public IsoFormat As String
Public LineNumberFormat As String
Public AdditionalScaling As Single

Public LineNumber As Long

Const SCALEFACTOR = 10000

Public Function Value(InVal) As Long
  Value = CLng(Val(InVal) * SCALEFACTOR + 0.5)
End Function


Public Function Generate_GCodeFromArray_All(ByVal FileName As String) As Long
Dim count As Long, Vertex As Long
Dim I As Long, J As Long, R As Long, A1 As Single, A2 As Single
Dim X1 As Long, Y1 As Long, X2 As Long, Y2 As Long

  'points and text will be ignored!
  LineNumber = 0
  Open FileName For Output As #2
    Print #2, LineNumberStr(LineNumber) & " G90; # absolute coordinates "
    Print #2, LineNumberStr(LineNumber) & " G71; # metric programming unit "
   'LINES:
    For count = 0 To ArrTot_Lines - 1
      If LayerArray(LineArray(count).Layer).Goutput Then
        Call GCode_G00(LineArray(count).X0, LineArray(count).Y0)
        Call GCode_G01(LineArray(count).X1, LineArray(count).Y1)
      End If
    Next
    'ARCS:
    For count = 0 To ArrTot_Arcs - 1
      If LayerArray(ArcArray(count).Layer).Goutput Then
        X1 = ArcArray(count).x + ArcArray(count).R * Cos(ArcArray(count).A1)
        Y1 = ArcArray(count).y + ArcArray(count).R * Sin(ArcArray(count).A1)
        X2 = ArcArray(count).x + ArcArray(count).R * Cos(ArcArray(count).A2)
        Y2 = ArcArray(count).y + ArcArray(count).R * Sin(ArcArray(count).A2)
        I = ArcArray(count).x - X1
        J = ArcArray(count).y - Y1
        Call GCode_G00(X1, Y1)
        Call GCode_G03(X2, Y2, I, J)
      End If
    Next
    'CIRCLES
    For count = 0 To ArrTot_Circles - 1
      If LayerArray(CircleArray(count).Layer).Goutput Then
        R = CircleArray(count).R
        X1 = CircleArray(count).x + R
        Y1 = CircleArray(count).y
        X2 = CircleArray(count).x - R
        Y2 = CircleArray(count).y
        Call GCode_G00(X1, Y1)
        Call GCode_G03(X2, Y2, -R, 0)
        Call GCode_G03(X1, Y1, R, 0)
      End If
    Next
    'POLYLINES
    For count = 0 To ArrTot_Polylines - 1
      If LayerArray(PolylineArray(count).Layer).Goutput Then
        Call GCode_G00(VertexArray(PolylineArray(count).Vertex1).x, _
                       VertexArray(PolylineArray(count).Vertex1).y)
        For Vertex = PolylineArray(count).Vertex1 To PolylineArray(count).Vertex2 - 1
          If VertexArray(Vertex).B = 0 Then
            Call GCode_G01(VertexArray(Vertex + 1).x, VertexArray(Vertex + 1).y)
          Else
            Call Bulge2IJ(VertexArray(Vertex).x, VertexArray(Vertex).y, _
                          VertexArray(Vertex + 1).x, VertexArray(Vertex + 1).y, _
                          VertexArray(Vertex).B, I, J, R, A1, A2)
            If VertexArray(Vertex).B > 0 Then
              Call GCode_G03(VertexArray(Vertex + 1).x, VertexArray(Vertex + 1).y, I, J)
            Else
              Call GCode_G02(VertexArray(Vertex + 1).x, VertexArray(Vertex + 1).y, I, J)
            End If
          End If
        Next
        If PolylineArray(count).closed Then
          If VertexArray(PolylineArray(count).Vertex2).B = 0 Then
            Call GCode_G01(VertexArray(PolylineArray(count).Vertex1).x, VertexArray(PolylineArray(count).Vertex1).y)
          Else
            Call Bulge2IJ(VertexArray(PolylineArray(count).Vertex2).x, VertexArray(PolylineArray(count).Vertex2).y, _
                          VertexArray(PolylineArray(count).Vertex1).x, VertexArray(PolylineArray(count).Vertex1).y, _
                          VertexArray(PolylineArray(count).Vertex2).B, I, J, R, A1, A2)
            If VertexArray(Vertex).B > 0 Then
              Call GCode_G03(VertexArray(PolylineArray(count).Vertex1).x, VertexArray(PolylineArray(count).Vertex1).y, I, J)
            Else
              Call GCode_G02(VertexArray(PolylineArray(count).Vertex1).x, VertexArray(PolylineArray(count).Vertex1).y, I, J)
            End If
          End If
        End If
      End If
    Next
    Print #2, LineNumberStr(LineNumber) & " M02; # program end "
  Close #2
  Generate_GCodeFromArray_All = LineNumber
End Function



Public Function LineNumberStr(ByRef LineNumber As Long) As String
  LineNumberStr = "N" & Format(LineNumber, LineNumberFormat)
  LineNumber = LineNumber + 1
End Function

Public Sub GCode_G00(ByVal x As Long, ByVal y As Long)
Dim Linestr As String
  'Ho notato dei problemi di notazione scientifica e con la virgola
  'quindi devo usare format.
  'I have seen problems with the scientific notation, we have to use format!
  Linestr = "X" & Format(x / SCALEFACTOR / AdditionalScaling, IsoFormat) & _
           " Y" & Format(y / SCALEFACTOR / AdditionalScaling, IsoFormat)
  'Per format  bastardo: invece di mettere il punto mi mette . o , a dipendenza del paese
  'Quindi devo rimpiazzare a mano la , con . per sicurezza!
  'Caveat: format uses the decimal placeholder of the country - coul be . or ,
  'But ISO-code needs always . --> let's replace , by . to avoid problems!
  Linestr = Replace(Linestr, ",", ".")
  Print #2, LineNumberStr(LineNumber) & " G00 " & Linestr & ";"
End Sub

Public Sub GCode_G01(ByVal x As Long, ByVal y As Long)
Dim Linestr As String
  Linestr = "X" & Format(x / SCALEFACTOR / AdditionalScaling, IsoFormat) & _
           " Y" & Format(y / SCALEFACTOR / AdditionalScaling, IsoFormat)
  Linestr = Replace(Linestr, ",", ".")
  Print #2, LineNumberStr(LineNumber) & " G01 " & Linestr & ";"
End Sub

Public Sub GCode_G02(ByVal x As Long, ByVal y As Long, _
                      ByVal I As Long, ByVal J As Long)
Dim Linestr As String
  Linestr = "X" & Format(x / SCALEFACTOR / AdditionalScaling, IsoFormat) & _
           " Y" & Format(y / SCALEFACTOR / AdditionalScaling, IsoFormat) & _
           " I" & Format(I / SCALEFACTOR / AdditionalScaling, IsoFormat) & _
           " J" & Format(J / SCALEFACTOR / AdditionalScaling, IsoFormat)
  Linestr = Replace(Linestr, ",", ".")
  Print #2, LineNumberStr(LineNumber) & " G02 " & Linestr & "; "
End Sub

Public Sub GCode_G03(ByVal x As Long, ByVal y As Long, _
                      ByVal I As Long, ByVal J As Long)
Dim Linestr As String
  Linestr = "X" & Format(x / SCALEFACTOR / AdditionalScaling, IsoFormat) & _
           " Y" & Format(y / SCALEFACTOR / AdditionalScaling, IsoFormat) & _
           " I" & Format(I / SCALEFACTOR / AdditionalScaling, IsoFormat) & _
           " J" & Format(J / SCALEFACTOR / AdditionalScaling, IsoFormat)
  Linestr = Replace(Linestr, ",", ".")
  Print #2, LineNumberStr(LineNumber) & " G03 " & Linestr & "; "
End Sub


